/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.menu;

import com.golden.gamedev.GameEngine;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import moagg.game.Strings;
import moagg.game.menu.AbstractMenu;
import moagg.prefs.player.PlayerPrefs;
import moagg.types.prefs.GhostPlayback;
import org.apache.log4j.Logger;

public class GhostMenu
extends AbstractMenu {
    private static Logger log = Logger.getLogger(GhostMenu.class);
    private static final int INDEX_RECORD = 0;
    private static final int INDEX_PLAYBACK = 1;
    private static final int INDEX_PLAYBACK_NAME = 2;
    private static final int INDEX_BACK = 3;
    private static final String KEY_RECORD = "menu.ghost.record";
    private static final String KEY_PLAYBACK = "menu.ghost.playback";
    private static final String KEY_PLAYBACK_MODE_PREFIX = "menu.ghost.playback.";
    private static final String KEY_PLAYBACK_NAME = "menu.ghost.playback-name";
    private static final String KEY_BACK = "menu.back";
    private PlayerPrefs prefs = PlayerPrefs.getInstance();
    private boolean selectRecord = false;
    private boolean selectPlayback = false;
    private int selectedPlayback = 0;
    private boolean selectPlaybackName = false;
    private String playbackName = null;

    public GhostMenu(GameEngine parent, BufferedImage background) {
        super(parent, background);
    }

    public void initResources() {
        log.trace("");
        super.initResources();
        this.initMenuItems();
        this.selectedPlayback = this.prefs.getGhostPlayback().ordinal();
        this.playbackName = this.prefs.getGhostPlaybackName();
    }

    protected void initMenuItems() {
        this.maxTextWidth = 0;
        this.updateMaxTextWidth(Strings.getString(KEY_RECORD));
        this.updateMaxTextWidth(Strings.getString(KEY_PLAYBACK));
        if (this.prefs.getGhostPlayback() == GhostPlayback.NAME) {
            this.updateMaxTextWidth(Strings.getString(KEY_PLAYBACK_NAME));
        }
        this.updateMaxTextWidth(Strings.getString(KEY_BACK));
        this.menuItems.clear();
        this.menuItems.add(new AbstractMenu.MenuItem(100, 100, Strings.getString(KEY_RECORD)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 120, Strings.getString(KEY_PLAYBACK)));
        if (this.prefs.getGhostPlayback() == GhostPlayback.NAME) {
            this.menuItems.add(new AbstractMenu.MenuItem(100, 140, Strings.getString(KEY_PLAYBACK_NAME)));
        }
        this.menuItems.add(new AbstractMenu.MenuItem(100, 160, Strings.getString(KEY_BACK)));
    }

    public void update(long elapsedTime) {
        block10: {
            block12: {
                block11: {
                    block9: {
                        if (!this.selectRecord) break block9;
                        this.prefs.setGhostRecord(!this.prefs.isGhostRecord());
                        this.selectRecord = false;
                        break block10;
                    }
                    if (!this.selectPlayback) break block11;
                    this.selectedPlayback = (this.selectedPlayback + 1) % GhostPlayback.values().length;
                    this.prefs.setGhostPlayback(GhostPlayback.values()[this.selectedPlayback]);
                    this.initMenuItems();
                    this.selectPlayback = false;
                    break block10;
                }
                if (!this.selectPlaybackName) break block12;
                int key = this.bsInput.getKeyPressed();
                switch (key) {
                    case -2147483648: {
                        break;
                    }
                    case 10: {
                        this.prefs.setGhostPlaybackName(this.playbackName);
                        this.selectPlaybackName = false;
                        break;
                    }
                    case 27: {
                        this.playbackName = this.prefs.getGhostPlaybackName();
                        this.selectPlaybackName = false;
                        break;
                    }
                    case 8: {
                        if (this.playbackName.length() > 0) {
                            this.playbackName = this.playbackName.substring(0, this.playbackName.length() - 1);
                            break;
                        }
                        break block10;
                    }
                    case 32: {
                        this.playbackName = this.playbackName + " ";
                        break;
                    }
                    default: {
                        String ch = KeyEvent.getKeyText(key);
                        if (ch.length() == 1) {
                            this.playbackName = this.playbackName + (this.bsInput.isKeyDown(16) ? ch.toUpperCase() : ch.toLowerCase());
                            break;
                        }
                        break block10;
                    }
                }
                break block10;
            }
            super.update(elapsedTime);
        }
    }

    public void enter() {
        switch (this.selectedItemIndex) {
            case 0: {
                this.selectRecord = true;
                break;
            }
            case 1: {
                this.selectPlayback = true;
                break;
            }
            case 2: {
                if (this.prefs.getGhostPlayback() == GhostPlayback.NAME) {
                    this.selectPlaybackName = true;
                    break;
                }
            }
            case 3: {
                this.finish();
            }
        }
    }

    public void render(Graphics2D g) {
        super.render(g);
        int x = 100 + this.maxTextWidth + 32;
        this.renderText(g, Strings.getString("menu.switch." + this.prefs.isGhostRecord()), x, 100, false);
        this.renderText(g, Strings.getString(KEY_PLAYBACK_MODE_PREFIX + (Object)((Object)this.prefs.getGhostPlayback())), x, 120, false);
        if (this.prefs.getGhostPlayback() == GhostPlayback.NAME) {
            this.renderText(g, this.playbackName, x, 140, this.selectPlaybackName);
        }
    }
}

