/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.level.applet;

import com.golden.gamedev.object.GameFont;
import java.awt.Graphics2D;
import moagg.artwork.font.FontFactory;
import moagg.game.Strings;
import moagg.game.level.applet.AbstractApplet;
import moagg.prefs.score.Score;

public class ScoreApplet
extends AbstractApplet {
    private static final int MARGIN = 6;
    private String LABEL = Strings.getString("game.panel.score.label");
    private String YOUR_SCORE = Strings.getString("game.panel.score.your");
    private String BEST_SCORE = Strings.getString("game.panel.score.best");
    private GameFont font = FontFactory.getInstance().getNarrowFont();
    private int width = 0;
    private Score score = null;
    private Score bestScore = null;

    public ScoreApplet() {
        Score dummyScore = new Score();
        dummyScore.setWrecks(10);
        dummyScore.setPoints(10);
        this.width = Math.max(this.width, this.font.getWidth(this.LABEL));
        this.width = Math.max(this.width, this.font.getWidth(this.getYourScoreString(dummyScore)));
        this.width = Math.max(this.width, this.font.getWidth(this.getBestScoreString(dummyScore)));
        this.width += 12;
        this.setWidth(this.width);
    }

    public void setScore(Score score) {
        this.score = score;
    }

    public void setBestScore(Score bestScore) {
        this.bestScore = bestScore;
    }

    public void update(long elapsedTime) {
    }

    protected void renderContent(Graphics2D g) {
        this.font.drawString(g, this.LABEL, this.width - this.font.getWidth(this.LABEL) - 6, 2);
        String yourScoreString = this.getYourScoreString(this.score);
        this.font.drawString(g, yourScoreString, this.width - this.font.getWidth(yourScoreString) - 6, 22);
        if (this.bestScore != null) {
            String bestScoreString = this.getBestScoreString(this.bestScore);
            this.font.drawString(g, bestScoreString, this.width - this.font.getWidth(bestScoreString) - 6, 40);
        }
    }

    protected String getBestScoreString(Score score) {
        return this.BEST_SCORE + " " + this.getScoreString(score);
    }

    protected String getYourScoreString(Score score) {
        return this.YOUR_SCORE + " " + this.getScoreString(score);
    }

    protected String getScoreString(Score score) {
        return score.getWrecks() + " / " + score.getPoints() + " / " + score.getElapsedTimeAsString();
    }
}

