/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.level.applet;

import com.golden.gamedev.object.GameFont;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import moagg.artwork.font.FontFactory;
import moagg.artwork.object.StatusBarImageFactory;
import moagg.game.Strings;
import moagg.game.level.applet.AbstractApplet;
import moagg.model.object.DestroyableObject;

public class ArmorApplet
extends AbstractApplet {
    private static final int MARGIN = 6;
    private String LABEL = Strings.getString("game.panel.armor.label");
    private GameFont font = FontFactory.getInstance().getNarrowFont();
    private BufferedImage armor = StatusBarImageFactory.getInstance().getArmor();
    private DestroyableObject destroyable = null;

    public ArmorApplet() {
        int width = 3 * this.armor.getWidth();
        width = Math.max(width, this.font.getWidth(this.LABEL));
        this.setWidth(width += 12);
    }

    public void setDestroyable(DestroyableObject destroyable) {
        this.destroyable = destroyable;
    }

    public void update(long elapsedTime) {
    }

    protected void renderContent(Graphics2D g) {
        this.font.drawString(g, this.LABEL, 6, 2);
        for (int i = 0; i < this.destroyable.getHealth() - 1; ++i) {
            g.drawImage((Image)this.armor, 6 + i * this.armor.getWidth(), 22, null);
        }
    }
}

