/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.level;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import moagg.game.SystemProperties;

public class LevelStrings {
    private static final String BUNDLE_NAME = "strings";
    private static final String MISSION_TITLE = "mission.title";
    private static final String DESCRIPTION_SUFFIX = "description";
    private static Map<String, ResourceBundle> bundles = null;

    public static void init() {
        bundles = new HashMap<String, ResourceBundle>();
    }

    public static String getMissionTitle(String mission) {
        return LevelStrings.getString(mission, MISSION_TITLE);
    }

    public static String getDescription(String mission, String level) {
        try {
            return LevelStrings.getString(mission, level, DESCRIPTION_SUFFIX);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static String getString(String mission, String key) {
        if (!bundles.containsKey(key)) {
            String missionPath = SystemProperties.getInstance().getMissionsPath();
            if ((missionPath = missionPath.replace('/', '.')).startsWith(".")) {
                missionPath = missionPath.substring(1);
            }
            bundles.put(mission, ResourceBundle.getBundle(missionPath + "." + mission + "." + BUNDLE_NAME));
        }
        return bundles.get(mission).getString(key);
    }

    public static String getString(String mission, String level, String key) {
        return LevelStrings.getString(mission, level.replace(".xml", "") + "." + key);
    }

    public static String getString(String mission, String level, String key, Object ... args) {
        String string = LevelStrings.getString(mission, level, key);
        return MessageFormat.format(string, args);
    }

    static {
        LevelStrings.init();
    }
}

