/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.weapon.tank;

import moagg.artwork.object.ProjectileImageFactory;
import moagg.game.control.GameControl;
import moagg.game.control.weapon.ProjectileFactory;
import moagg.model.object.ShooterObject;
import moagg.model.object.sprite.Laser;
import moagg.model.object.sprite.Ship;
import moagg.model.object.sprite.Tank;
import moagg.model.weapon.Weapon;
import moagg.util.math.AngleUtil;
import moagg.util.math.SinusTable;

public class LaserFactoryImpl
implements ProjectileFactory {
    private static final int LASER_BEAM_LENGTH = 8;
    private static final double LASER_SPEED = 0.3;

    public void createProjectile(ShooterObject shooter, Weapon weapon, GameControl gameControl) {
        Tank tank = (Tank)shooter;
        Ship player = gameControl.getPlayer();
        int x = (int)tank.getX() + tank.getWidth() / 2;
        int y = (int)tank.getY();
        int playerX = (int)player.getX() + player.getWidth() / 2;
        int playerY = (int)player.getY() + player.getHeight() / 2;
        double angle = 0.0;
        switch (tank.getTankType()) {
            case RANDOM: {
                angle = Math.random() * 180.0 + 90.0;
                break;
            }
            case SMART: {
                angle = AngleUtil.getAngle(x, y, playerX, playerY);
            }
        }
        Laser laser = this.createLaser(x, y, angle);
        laser.setHealth(1);
        laser.setShooter(shooter);
        gameControl.addProjectile(laser);
    }

    protected Laser createLaser(int x, int y, double a) {
        Laser laser = new Laser();
        laser.setImage(ProjectileImageFactory.getInstance().getLaserImage(a, 8));
        int r = laser.getWidth();
        laser.setX((double)(x -= laser.getWidth() / 2) + (double)r * SinusTable.sin(a));
        laser.setY((double)(y -= laser.getHeight() / 2) + (double)r * SinusTable.cos(a));
        laser.setSpeed(0.3 * SinusTable.sin(a), 0.3 * SinusTable.cos(a));
        return laser;
    }
}

