/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.weapon.tank;

import moagg.artwork.object.ProjectileImageFactory;
import moagg.game.control.GameControl;
import moagg.game.control.weapon.ProjectileFactory;
import moagg.model.object.ShooterObject;
import moagg.model.object.sprite.Projectile;
import moagg.model.object.sprite.Ship;
import moagg.model.object.sprite.Tank;
import moagg.model.weapon.Weapon;
import moagg.util.math.AngleUtil;
import moagg.util.math.SinusTable;

public class BlasterFactoryImpl
implements ProjectileFactory {
    private static final double PROJECTILE_SPEED = 0.2;

    public void createProjectile(ShooterObject shooter, Weapon weapon, GameControl gameControl) {
        Tank tank = (Tank)shooter;
        Ship player = gameControl.getPlayer();
        int x = (int)tank.getX() + tank.getWidth() / 2;
        int y = (int)tank.getY();
        int playerX = (int)player.getX() + player.getWidth() / 2;
        int playerY = (int)player.getY() + player.getHeight() / 2;
        double angle = 0.0;
        switch (tank.getTankType()) {
            case RANDOM: {
                angle = Math.random() * 180.0 + 90.0;
                break;
            }
            case SMART: {
                angle = AngleUtil.getAngle(x, y, playerX, playerY);
            }
        }
        Projectile projectile = this.createProjectile(x, y, angle);
        projectile.setHealth(1);
        projectile.setShooter(shooter);
        gameControl.addProjectile(projectile);
    }

    protected Projectile createProjectile(int x, int y, double a) {
        Projectile projectile = new Projectile();
        projectile.setImage(ProjectileImageFactory.getInstance().getProjectileImage());
        projectile.setX(x -= projectile.getWidth() / 2);
        projectile.setY(y -= projectile.getHeight());
        projectile.setSpeed(0.2 * SinusTable.sin(a), 0.2 * SinusTable.cos(a));
        return projectile;
    }
}

