/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.weapon.ship;

import moagg.artwork.object.ProjectileImageFactory;
import moagg.game.control.GameControl;
import moagg.game.control.weapon.ProjectileFactory;
import moagg.model.object.ShooterObject;
import moagg.model.object.sprite.Laser;
import moagg.model.object.sprite.Ship;
import moagg.model.weapon.Weapon;
import moagg.util.math.SinusTable;

public class LaserFactoryImpl
implements ProjectileFactory {
    private static final int LASER_BEAM_LENGTH = 8;
    private static final double LASER_SPEED = 0.4;

    public void createProjectile(ShooterObject shooter, Weapon weapon, GameControl gameControl) {
        Ship ship = (Ship)shooter;
        int x = (int)ship.getX() + ship.getWidth() / 2;
        int y = (int)ship.getY() + ship.getHeight() / 2;
        int r = ship.getHeight() / 2;
        double a = ship.getAngle();
        double vx = ship.getHorizontalSpeed();
        double vy = ship.getVerticalSpeed();
        Laser l = this.createLaser(x, y, r, a, vx, vy);
        l.setHealth(1);
        l.setShooter(shooter);
        l.setAngle(a);
        gameControl.addProjectile(l);
    }

    protected Laser createLaser(int x, int y, int r, double a, double vx, double vy) {
        Laser laser = new Laser();
        laser.setImage(ProjectileImageFactory.getInstance().getLaserImage(a, 8));
        laser.setX((double)(x -= laser.getWidth() / 2) + (double)(r += laser.getHeight() / 2) * SinusTable.sin(a));
        laser.setY((double)(y -= laser.getHeight() / 2) + (double)r * SinusTable.cos(a));
        laser.setSpeed(vx += 0.4 * SinusTable.sin(a), vy += 0.4 * SinusTable.cos(a));
        return laser;
    }
}

