/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.weapon.ship;

import moagg.artwork.object.ProjectileImageFactory;
import moagg.game.control.GameControl;
import moagg.game.control.weapon.ProjectileFactory;
import moagg.model.object.ShooterObject;
import moagg.model.object.sprite.Projectile;
import moagg.model.object.sprite.Ship;
import moagg.model.weapon.Weapon;
import moagg.util.math.SinusTable;

public class BlasterFactoryImpl
implements ProjectileFactory {
    private static final double PROJECTILE_SPEED = 0.3;

    public void createProjectile(ShooterObject shooter, Weapon weapon, GameControl gameControl) {
        Ship ship = (Ship)shooter;
        int x = (int)ship.getX() + ship.getWidth() / 2;
        int y = (int)ship.getY() + ship.getHeight() / 2;
        int r = ship.getHeight() / 2;
        double a = ship.getAngle();
        double vx = ship.getHorizontalSpeed();
        double vy = ship.getVerticalSpeed();
        Projectile p = this.createProjectile(x, y, r, a, vx, vy);
        p.setHealth(1);
        p.setShooter(shooter);
        gameControl.addProjectile(p);
    }

    protected Projectile createProjectile(int x, int y, int r, double a, double vx, double vy) {
        Projectile projectile = new Projectile();
        projectile.setImage(ProjectileImageFactory.getInstance().getProjectileImage());
        projectile.setX((double)(x -= projectile.getWidth() / 2) + (double)(r += projectile.getHeight() / 2) * SinusTable.sin(a));
        projectile.setY((double)(y -= projectile.getHeight() / 2) + (double)r * SinusTable.cos(a));
        projectile.setSpeed(vx += 0.3 * SinusTable.sin(a), vy += 0.3 * SinusTable.cos(a));
        return projectile;
    }
}

