/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.weapon.sam;

import moagg.artwork.object.MissileImageFactory;
import moagg.game.control.GameControl;
import moagg.game.control.weapon.ProjectileFactory;
import moagg.model.ControllableImpl;
import moagg.model.DestroyableImpl;
import moagg.model.object.ShooterObject;
import moagg.model.object.sprite.Missile;
import moagg.model.object.sprite.Sam;
import moagg.model.weapon.Weapon;

public class MissileFactoryImpl
implements ProjectileFactory {
    public void createProjectile(ShooterObject shooter, Weapon weapon, GameControl gameControl) {
        Sam sam = (Sam)shooter;
        Missile missile = new Missile();
        missile.setImages(MissileImageFactory.getInstance().getImages());
        missile.setX(sam.getX());
        missile.setY(sam.getY());
        ControllableImpl missileControllable = new ControllableImpl();
        missileControllable.setAngle(this.getInitialMissileAngle(sam));
        missileControllable.setFuelCapacity(sam.getMissileFuel());
        missileControllable.setFuel(sam.getMissileFuel());
        missileControllable.setFuelPerMilliSecond(1L);
        missileControllable.setThrust(true);
        missileControllable.setThrustForce(0.02);
        missileControllable.setMass(100L);
        missileControllable.setRotationSpeed(0.3);
        missile.setControllable(missileControllable);
        DestroyableImpl missileDestroyable = new DestroyableImpl();
        missileDestroyable.setHealth(1);
        missile.setDestroyable(missileDestroyable);
        missile.setShooter(sam);
        missile.setHeading(sam.getMissileHeading());
        missile.setWarhead(sam.getMissileWarhead());
        gameControl.addProjectile(missile);
    }

    protected double getInitialMissileAngle(Sam sam) {
        switch (sam.getOrientation()) {
            case TOP: {
                return 0.0;
            }
            case BOTTOM: {
                return 180.0;
            }
            case LEFT: {
                return 90.0;
            }
            case RIGHT: {
                return 270.0;
            }
        }
        return 0.0;
    }
}

