/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.weapon.mortar;

import moagg.game.control.GameControl;
import moagg.game.control.weapon.mortar.AbstractProjectileFactoryImpl;
import moagg.model.object.ShooterObject;
import moagg.model.object.sprite.Mortar;
import moagg.model.object.sprite.Ship;
import moagg.model.weapon.Weapon;
import moagg.model.weapon.mortar.SmartBarrel;
import moagg.util.math.AngleUtil;
import org.apache.log4j.Logger;

public class SmartProjectileFactoryImpl
extends AbstractProjectileFactoryImpl {
    private static Logger log = Logger.getLogger(SmartProjectileFactoryImpl.class);

    public void createProjectile(ShooterObject shooter, Weapon weapon, GameControl gameControl) {
        Mortar mortar = (Mortar)shooter;
        SmartBarrel barrel = (SmartBarrel)weapon;
        Ship player = gameControl.getPlayer();
        int angle = (int)AngleUtil.getAngle(mortar.getPositionRectangle(), player.getPositionRectangle());
        int checkAngle = AngleUtil.normalize(angle + this.getCenterAngle(mortar));
        if (checkAngle < 90 || checkAngle > 270) {
            log.trace("Skipping projectile creation because angle " + checkAngle + " lies out of range.");
            return;
        }
        this.createProjectile(mortar, barrel, angle, gameControl);
    }
}

