/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.objective;

import moagg.game.control.GameControlImpl;
import moagg.game.control.objective.Objective;
import moagg.model.object.sprite.Crate;
import moagg.model.object.sprite.Platform;
import moagg.model.object.sprite.Ship;

public class BringCrateToPlatform
implements Objective {
    private Crate crate = null;
    private Platform platform = null;
    private boolean addedForUnloading = false;

    public void setCrate(Crate crate) {
        this.crate = crate;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public boolean isReached(GameControlImpl gameControl) {
        Ship ship = gameControl.getPlayer();
        if (this.crate.isRescued()) {
            return true;
        }
        if (!ship.hasCrate(this.crate)) {
            return false;
        }
        if (!ship.isActive()) {
            ship.dropCrate(this.crate);
            this.crate.setActive(false);
            return true;
        }
        if (!this.addedForUnloading && ship.getLandedPlatform() == this.platform) {
            gameControl.addCrateToUnload(this.crate);
            this.addedForUnloading = true;
        }
        return false;
    }
}

