/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler;

import com.golden.gamedev.object.Sprite;
import java.io.IOException;
import java.util.Properties;
import moagg.game.control.GameControlImpl;
import moagg.game.control.handler.GameControlHandler;
import moagg.game.control.weapon.ProjectileFactory;
import moagg.game.control.weapon.ProjectileFactoryDecorator;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.ShooterObject;
import moagg.model.object.sprite.Ship;
import moagg.model.weapon.Weapon;
import moagg.model.weapon.WeaponDecorator;
import moagg.model.weapon.WeaponList;
import org.apache.log4j.Logger;

public class ShootHandler
implements GameControlHandler {
    private static Logger log = Logger.getLogger(ShootHandler.class);
    private static final String PROJECTILE_FACTORIES = "/properties/projectileFactories.properties";
    private Properties projectileFactories = new Properties();

    public ShootHandler() {
        try {
            this.projectileFactories.load(this.getClass().getResourceAsStream(PROJECTILE_FACTORIES));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading '/properties/projectileFactories.properties'", e);
        }
    }

    public void update(GameControlImpl gameControl, long elapsedTime) {
        Ship player = gameControl.getPlayer();
        if (player == null || !player.isActive()) {
            return;
        }
        this.handleShoot(player, gameControl);
        for (MoaggGameObject object : gameControl.getObjects()) {
            if (!(object instanceof ShooterObject) || !gameControl.isBackgroundBetween(player, object)) continue;
            this.handleShoot((ShooterObject)object, gameControl);
        }
    }

    protected void handleShoot(ShooterObject shooter, GameControlImpl gameControl) {
        this.handleShoot(shooter, shooter.getWeapon(), gameControl);
    }

    protected void handleShoot(ShooterObject shooter, Weapon weapon, GameControlImpl gameControl) {
        if (!((Sprite)shooter).isActive()) {
            return;
        }
        if (weapon == null) {
            return;
        }
        if (weapon instanceof WeaponList) {
            for (Weapon w : ((WeaponList)weapon).getWeapons()) {
                this.handleShoot(shooter, w, gameControl);
            }
        } else if (weapon.isShoot()) {
            log.trace(shooter.getClass().getName() + " / " + weapon.getClass().getName());
            ProjectileFactory factory = this.createProjectileFactory(weapon);
            if (weapon instanceof WeaponDecorator) {
                ProjectileFactory realFactory = this.createProjectileFactory(((WeaponDecorator)weapon).getWeapon());
                ((ProjectileFactoryDecorator)factory).setProjectileFactory(realFactory);
            }
            factory.createProjectile(shooter, weapon, gameControl);
        }
    }

    protected ProjectileFactory createProjectileFactory(Weapon weapon) {
        try {
            Class<?> factoryClass = Class.forName(this.projectileFactories.getProperty(weapon.getClass().getName()));
            return (ProjectileFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating ProjectileFactory for '" + weapon.getClass().getName() + "'", e);
        }
    }
}

