/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler;

import moagg.game.control.GameControl;
import moagg.game.control.GameControlImpl;
import moagg.game.control.handler.GameControlHandler;
import moagg.model.object.sprite.Platform;
import moagg.model.object.sprite.Ship;
import moagg.types.math.Rectangle;
import moagg.types.math.Vector;
import org.apache.log4j.Logger;

public class LandingHandler
implements GameControlHandler {
    private static Logger log = Logger.getLogger(LandingHandler.class);

    public void update(GameControlImpl gameControl, long elapsedTime) {
        Ship player = gameControl.getPlayer();
        this.checkShipLanded(player, gameControl);
        this.checkShipTakeoff(player, gameControl);
        this.checkShipOnFuelPlatform(player, elapsedTime);
    }

    protected void checkShipLanded(Ship player, GameControlImpl gameControl) {
        if (!player.isLanded() && player.isAligned()) {
            Rectangle r = new Rectangle(player.getLandingZone());
            r.translate((int)player.getX(), (int)player.getY());
            for (Platform platform : gameControl.getPlatforms()) {
                if (!platform.getLandingZone().contains(r)) continue;
                double vyRel = player.getVerticalSpeed() - platform.getVerticalSpeed();
                double vxAbs = Math.abs(player.getHorizontalSpeed());
                if (vyRel < 0.0) {
                    log.trace("Can't land on platform " + platform.getID() + " with relative vertical speed " + vyRel);
                    break;
                }
                if (vyRel < 0.04 && vxAbs < 0.04) {
                    log.trace("Detected ship landing on platform " + platform.getID() + " with relative vertical speed " + vyRel);
                    this.landPlayerOnPlatform(player, platform);
                    gameControl.callScript("onLanded", platform);
                    break;
                }
                if (vyRel < 0.08) {
                    if (vxAbs > 0.04) {
                        log.trace("Ship is going to h bounce from platform " + platform.getID());
                        player.setHorizontalSpeed(player.getHorizontalSpeed() * 0.5);
                        player.setVerticalSpeed((-player.getVerticalSpeed() - vxAbs) * 0.5 / 2.0);
                        break;
                    }
                    if (vyRel > 0.04) {
                        log.trace("Ship is going to v bounce from platform " + platform.getID());
                        player.addSpeed(new Vector(0.0, -vyRel * 1.5));
                        break;
                    }
                }
                log.trace("Ship is too fast for landing on platform " + platform.getID());
            }
        }
    }

    protected void checkShipTakeoff(Ship player, GameControl gameControl) {
        if (player.isLanded() && player.isThrust()) {
            log.trace("Detected ship takeoff.");
            Platform platform = player.getLandedPlatform();
            player.setLandedPlatform(null);
            gameControl.callScript("onTakeOff", platform);
        }
    }

    protected void checkShipOnFuelPlatform(Ship player, long elapsedTime) {
        Platform platform = player.getLandedPlatform();
        if (platform == null || !platform.isFuelPlatform()) {
            return;
        }
        long newFuel = player.getFuel() + elapsedTime * 5L;
        if (newFuel > player.getFuelCapacity()) {
            newFuel = player.getFuelCapacity();
        }
        player.setFuel(newFuel);
    }

    protected void landPlayerOnPlatform(Ship player, Platform platform) {
        player.setLandedPlatform(platform);
        player.setSpeed(0.0, 0.0);
        player.setY(Math.floor(player.getY()) + platform.getY() - Math.floor(platform.getY()));
        player.setX(Math.floor(player.getX()) + platform.getX() - Math.floor(platform.getX()));
    }
}

