/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler;

import com.golden.gamedev.object.Sprite;
import moagg.game.control.GameControlImpl;
import moagg.game.control.handler.GameControlHandler;
import moagg.model.object.ControllableObject;
import moagg.model.object.sprite.GhostShip;
import moagg.model.object.sprite.Particle;
import moagg.types.math.Vector;
import moagg.util.RandomTool;
import moagg.util.math.SinusTable;

public class CreateThrustParticlesHandler
implements GameControlHandler {
    public static final double THRUST_PARTICLE_FUZZ = 10.0;
    public static final double THRUST_PARTICLE_SPEED = 0.15;
    public static final int THRUST_PARTICLE_LIFETIME = 175;
    public static final int THRUST_PARTICLE_LIFETIME_FUZZ = 75;

    public void update(GameControlImpl gameControl, long elapsedTime) {
        for (Sprite sprite : gameControl.getGhostsSpriteGroup().getSprites()) {
            if (!(sprite instanceof ControllableObject)) continue;
            this.handleObject((ControllableObject)sprite, gameControl);
        }
        for (Sprite sprite : gameControl.getPlayersSpriteGroup().getSprites()) {
            if (!(sprite instanceof ControllableObject)) continue;
            this.handleObject((ControllableObject)sprite, gameControl);
        }
        for (Sprite sprite : gameControl.getProjectilesSpriteGroup().getSprites()) {
            if (!(sprite instanceof ControllableObject)) continue;
            this.handleObject((ControllableObject)sprite, gameControl);
        }
    }

    protected void handleObject(ControllableObject co, GameControlImpl gameControl) {
        if (!((Sprite)co).isActive() || !co.isThrust() || co.getFuel() == 0L) {
            return;
        }
        Particle particle = this.createThrustParticle(co);
        particle.setGhost(co instanceof GhostShip);
        gameControl.addParticle(particle);
    }

    protected Particle createThrustParticle(ControllableObject co) {
        int x = (int)co.getX() + co.getWidth() / 2;
        int y = (int)co.getY() + co.getHeight() / 2;
        int r = co.getHeight() / 2;
        double a = RandomTool.getRandom(co.getAngle(), 10.0);
        Particle thrust = new Particle();
        thrust.setCollision(true);
        thrust.setGradient(true);
        thrust.setX((double)x - (double)r * SinusTable.sin(a));
        thrust.setY((double)y - (double)r * SinusTable.cos(a));
        Vector v = Vector.sub(co.getSpeed(), Vector.exp(0.15, a));
        thrust.setSpeed(v);
        thrust.setLifeTime(RandomTool.getRandom(175, 75));
        return thrust;
    }
}

