/*
 * Decompiled with CFR 0.152.
 */
package moagg.game;

import com.golden.gamedev.GameEngine;
import java.awt.Graphics2D;
import moagg.artwork.font.FontFactory;
import moagg.game.Strings;
import moagg.game.menu.AbstractMenu;
import moagg.prefs.player.PlayerPrefs;
import moagg.types.prefs.Difficulty;
import org.apache.log4j.Logger;

public class SelectDifficultyScreen
extends AbstractMenu {
    private static Logger log = Logger.getLogger(SelectDifficultyScreen.class);
    private static final int INDEX_EASY = 0;
    private static final int INDEX_HARD = 1;
    private static final String KEY_LABEL = "difficulty.label";
    private static PlayerPrefs prefs = PlayerPrefs.getInstance();

    public SelectDifficultyScreen(GameEngine parent) {
        super(parent);
    }

    public void initResources() {
        log.trace("");
        FontFactory.getInstance().init(this);
        super.initResources();
    }

    protected void initMenuItems() {
        this.menuItems.clear();
        this.menuItems.add(new AbstractMenu.MenuItem(100, 140, Difficulty.EASY.getLabel()));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 160, Difficulty.HARD.getLabel()));
    }

    public void render(Graphics2D g) {
        super.render(g);
        this.renderText(g, Strings.getString(KEY_LABEL), 100, 100, false);
    }

    public void enter() {
        Difficulty difficulty = null;
        switch (this.selectedItemIndex) {
            case 0: {
                difficulty = Difficulty.EASY;
                break;
            }
            case 1: {
                difficulty = Difficulty.HARD;
            }
        }
        prefs.setDifficulty(difficulty);
        this.parent.nextGameID = 0;
        this.finish();
    }
}

