/*
 * Decompiled with CFR 0.152.
 */
package moagg.game;

import com.golden.gamedev.GameEngine;
import com.golden.gamedev.GameObject;
import com.golden.gamedev.object.GameFont;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import moagg.artwork.font.FontFactory;
import moagg.artwork.sound.MusicClips;
import moagg.game.HighScoreGameObject;
import moagg.game.LevelGameObject;
import moagg.game.Strings;
import moagg.game.level.LevelStrings;
import moagg.level.MissionReader;
import moagg.model.object.sprite.Ship;
import moagg.prefs.ghost.Ghost;
import moagg.prefs.handicap.HandicapPrefs;
import moagg.prefs.player.PlayerPrefs;
import moagg.prefs.score.LevelKey;
import moagg.prefs.score.Score;
import moagg.prefs.score.ScoreEntries;
import moagg.prefs.score.ScoreEntry;
import moagg.prefs.score.ScorePrefs;
import org.apache.log4j.Logger;

public class MissionGameObject
extends GameObject {
    private static Logger log = Logger.getLogger(MissionGameObject.class);
    private static final int MARGIN = 16;
    private static final String KEY_TOP_5_HIGH_SCORES = "menu.mission.top5";
    private static final String KEY_SCORE_HEADER = "menu.mission.top5.score";
    private static final String KEY_DATE_HEADER = "menu.mission.top5.date";
    private static final String KEY_NAME_HEADER = "menu.mission.top5.name";
    private PlayerPrefs playerPrefs = PlayerPrefs.getInstance();
    private HandicapPrefs handicapPrefs = HandicapPrefs.getInstance();
    private ScorePrefs scorePrefs = ScorePrefs.getInstance();
    private MusicClips musicClips = MusicClips.getInstance();
    private MissionReader.MissionEntry mission = null;
    private ArrayList<String> levels = null;
    private int selectedLevelIndex = 0;
    private LevelGameObject levelGame = null;
    private ScoreEntries scores = null;
    private BufferedImage background = null;
    private GameFont font = null;
    private GameFont scoreFont = null;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private BufferedImage preview = null;
    private String[] description = null;

    public MissionGameObject(GameEngine parent, BufferedImage background, MissionReader.MissionEntry mission) {
        super(parent);
        this.background = background;
        this.mission = mission;
    }

    public void initResources() {
        log.trace("MissionGameObject initializing");
        this.levels = new ArrayList<String>(this.mission.levels);
        this.selectedLevelIndex = HandicapPrefs.getInstance().getLastPlayedLevel(this.mission.directory);
        this.font = FontFactory.getInstance().getMenuFont();
        this.scoreFont = FontFactory.getInstance().getNarrowFont();
        this.preview = ImageUtil.createImage((int)this.parent.getWidth(), (int)(this.parent.getHeight() - 64), (int)3);
        this.initLevel();
    }

    protected void initLevel() {
        this.initLevel(null);
    }

    protected void initLevel(Ship player) {
        log.trace("MissionGameObject loading level " + this.levels.get(this.selectedLevelIndex));
        this.handicapPrefs.updateLastPlayedLevel(this.mission.directory, this.selectedLevelIndex);
        this.levelGame = new LevelGameObject(this.parent, this.mission.directory, this.levels.get(this.selectedLevelIndex));
        this.levelGame.setPlayer(player);
        this.levelGame.initForPreview();
        this.scores = this.scorePrefs.getScoreEntries(new LevelKey(this.mission.directory, this.levels.get(this.selectedLevelIndex)));
        Graphics2D g = this.preview.createGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.preview.getWidth(), this.preview.getHeight());
        this.levelGame.renderPreview(g);
        g.dispose();
        String descriptionString = LevelStrings.getDescription(this.mission.directory, this.levels.get(this.selectedLevelIndex));
        this.description = descriptionString != null ? descriptionString.split("\\n") : null;
        log.trace("MissionGameObject finished loading level.");
    }

    public void render(Graphics2D g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.parent.getWidth(), this.parent.getHeight());
        if (this.background != null) {
            g.drawImage(this.background, null, null);
        }
        String text = LevelStrings.getMissionTitle(this.mission.directory) + " (level " + (this.selectedLevelIndex + 1) + "/" + this.levels.size() + ")";
        this.font.drawString(g, text, 100, 20);
        g.drawImage(this.preview, 16, 60, this.preview.getWidth() / 2, this.preview.getHeight() / 2, null);
        int y = 60;
        if (this.description != null) {
            for (String line : this.description) {
                y = this.font.drawText(g, line, 1, this.getWidth() / 2 + 32, y, this.getWidth() / 2 - 48, 0, 0);
            }
        }
        if (!this.scores.isEmpty()) {
            this.renderHighScores(g);
        }
    }

    protected void renderHighScores(Graphics2D g) {
        int y = this.getHeight() * 316 / 480;
        this.font.drawString(g, Strings.getString(KEY_TOP_5_HIGH_SCORES), 16, y);
        int xScore = 260;
        int xDate = 290;
        int xName = 450;
        this.scoreFont.drawString(g, Strings.getString(KEY_SCORE_HEADER), xScore - this.scoreFont.getWidth(Strings.getString(KEY_SCORE_HEADER)), y += 34);
        this.scoreFont.drawString(g, Strings.getString(KEY_DATE_HEADER), xDate, y);
        this.scoreFont.drawString(g, Strings.getString(KEY_NAME_HEADER), xName, y);
        int rank = 1;
        y += this.scoreFont.getHeight() + 4;
        for (ScoreEntry entry : this.scores) {
            Score score = entry.getScore();
            String scoreString = score.getWrecks() + " / " + score.getPoints() + " / " + score.getElapsedTimeAsString();
            this.scoreFont.drawString(g, String.valueOf(rank++) + ".", 48, y);
            this.scoreFont.drawString(g, scoreString, xScore - this.scoreFont.getWidth(scoreString), y);
            this.scoreFont.drawString(g, this.sdf.format(entry.getDate()), xDate, y);
            this.scoreFont.drawString(g, entry.getName(), xName, y);
            y += this.scoreFont.getHeight();
        }
    }

    public void update(long elapsedTime) {
        this.musicClips.update(elapsedTime);
        if (this.keyPressed(39)) {
            if (this.selectedLevelIndex < this.levels.size() - 1 && this.selectedLevelIndex < this.handicapPrefs.getHandicap(this.mission.directory)) {
                ++this.selectedLevelIndex;
                this.initLevel();
            }
        } else if (this.keyPressed(37)) {
            if (this.selectedLevelIndex > 0) {
                --this.selectedLevelIndex;
                this.initLevel();
            }
        } else if (this.keyPressed(36)) {
            this.selectedLevelIndex = 0;
            this.initLevel();
        } else if (this.keyPressed(35)) {
            this.selectedLevelIndex = Math.min(this.levels.size() - 1, this.handicapPrefs.getHandicap(this.mission.directory));
            this.initLevel();
        } else if (this.keyPressed(10)) {
            this.playLevel();
            if (this.selectedLevelIndex == this.levels.size()) {
                --this.selectedLevelIndex;
            }
            this.initLevel();
        } else if (this.keyPressed(27)) {
            this.finish();
        }
    }

    protected void playLevel() {
        Ship player = null;
        while (this.selectedLevelIndex < this.levels.size()) {
            LevelKey levelKey = new LevelKey(this.mission.directory, this.levels.get(this.selectedLevelIndex));
            if (player != null) {
                this.initLevel(player);
            }
            if (!this.scores.isEmpty()) {
                this.levelGame.setBestScore(this.scores.first().getScore());
            }
            if (this.playerPrefs.isGhostRecord()) {
                Ghost ghostRecord = new Ghost();
                ghostRecord.setShipType(this.playerPrefs.getShipType());
                this.levelGame.setGhostRecord(ghostRecord);
            }
            Ghost ghostPlayback = null;
            switch (this.playerPrefs.getGhostPlayback()) {
                case NONE: {
                    break;
                }
                case OWN: {
                    ghostPlayback = Ghost.load(levelKey, this.playerPrefs.getName());
                    break;
                }
                case NAME: {
                    ghostPlayback = Ghost.load(levelKey, this.playerPrefs.getGhostPlaybackName());
                }
            }
            this.levelGame.setGhostPlayback(ghostPlayback);
            this.levelGame.start();
            player = this.levelGame.getPlayer();
            if (!this.levelGame.isContinueWithNextLevel()) break;
            ScoreEntry entry = new ScoreEntry(this.playerPrefs.getName(), this.levelGame.getScore());
            ScoreEntry bestOfPlayer = this.scorePrefs.getBestScoreOfPlayer(levelKey, this.playerPrefs.getName());
            boolean newEntry = this.scorePrefs.addScore(levelKey, entry);
            this.handicapPrefs.updateHandicap(this.mission.directory, this.selectedLevelIndex + 1);
            if (newEntry) {
                if ((bestOfPlayer == null || entry.compareTo(bestOfPlayer) < 0) && this.levelGame.getGhostRecord() != null) {
                    this.levelGame.getGhostRecord().save(levelKey, this.playerPrefs.getName());
                }
                BufferedImage background = new BufferedImage(this.parent.getWidth(), this.parent.getHeight(), 1);
                Graphics2D g = background.createGraphics();
                this.levelGame.render(g);
                g.dispose();
                HighScoreGameObject highScoreGame = new HighScoreGameObject(this.parent, background, this.scorePrefs.getScoreEntries(levelKey), entry);
                highScoreGame.start();
            }
            ++this.selectedLevelIndex;
        }
    }

    protected void initGhost(LevelKey levelKey) {
    }
}

