/*
 * Decompiled with CFR 0.152.
 */
package moagg.game;

import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.collision.BasicCollisionGroup;
import com.golden.gamedev.object.collision.CollisionShape;
import java.awt.image.BufferedImage;
import moagg.model.level.Map;
import moagg.model.object.sprite.AbstractMoaggAnimatedSprite;
import moagg.model.object.sprite.AbstractMoaggSprite;
import moagg.types.math.Rectangle;

public abstract class AbstractMoaggMapCollisionGroup
extends BasicCollisionGroup {
    private Map map = null;

    public AbstractMoaggMapCollisionGroup(Map map) {
        this.map = map;
    }

    public boolean isCollide(Sprite sprite1, Sprite object, CollisionShape shape1, CollisionShape shape2) {
        Rectangle roClip;
        Rectangle ro = new Rectangle((int)object.getX(), (int)object.getY(), object.getWidth(), object.getHeight());
        if (!ro.equals(roClip = ro.intersect(new Rectangle(0, 0, this.map.getWidth() * 16, this.map.getHeight() * 16)))) {
            return true;
        }
        BufferedImage imgObject = object.getImage();
        int[] rgbObject = this.getRGB(object);
        for (int y = 0; y < ro.getH(); ++y) {
            for (int x = 0; x < ro.getW(); ++x) {
                int p1 = this.getRGB(imgObject, rgbObject, x, y);
                int p2 = this.getRGB(this.map.getImage(), this.map.getRGB(), ro.getX() + x, ro.getY() + y);
                if (p1 == 0 || p2 == 0) continue;
                return true;
            }
        }
        return false;
    }

    protected int[] getRGB(Sprite sprite) {
        if (sprite instanceof AbstractMoaggSprite) {
            return ((AbstractMoaggSprite)sprite).getRGB();
        }
        if (sprite instanceof AbstractMoaggAnimatedSprite) {
            return ((AbstractMoaggAnimatedSprite)sprite).getRGB();
        }
        return null;
    }

    protected int getRGB(BufferedImage img, int[] rgb, int x, int y) {
        int pixel = 0;
        pixel = rgb != null ? rgb[y * img.getWidth() + x] : img.getRGB(x, y);
        return pixel & 0xFFFFFF;
    }
}

