/*
 * Decompiled with CFR 0.152.
 */
package moagg.game;

import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.collision.BasicCollisionGroup;
import com.golden.gamedev.object.collision.CollisionShape;
import java.awt.image.BufferedImage;
import moagg.model.object.sprite.AbstractMoaggAnimatedSprite;
import moagg.types.math.Rectangle;

public abstract class AbstractMoaggCollisionGroup
extends BasicCollisionGroup {
    public boolean isCollide(Sprite sprite1, Sprite sprite2, CollisionShape shape1, CollisionShape shape2) {
        Rectangle r2;
        Rectangle r1 = new Rectangle((int)sprite1.getX(), (int)sprite1.getY(), sprite1.getWidth(), sprite1.getHeight());
        Rectangle clip = r1.intersect(r2 = new Rectangle((int)sprite2.getX(), (int)sprite2.getY(), sprite2.getWidth(), sprite2.getHeight()));
        if (clip == null) {
            return false;
        }
        BufferedImage img1 = sprite1.getImage();
        BufferedImage img2 = sprite2.getImage();
        int[] rgb1 = this.getRGB(sprite1);
        int[] rgb2 = this.getRGB(sprite2);
        int xOffset1 = clip.getX() - r1.getX();
        int yOffset1 = clip.getY() - r1.getY();
        int xOffset2 = clip.getX() - r2.getX();
        int yOffset2 = clip.getY() - r2.getY();
        for (int y = 0; y < clip.getH(); ++y) {
            for (int x = 0; x < clip.getW(); ++x) {
                int p1 = this.getRGB(img1, rgb1, xOffset1 + x, yOffset1 + y);
                int p2 = this.getRGB(img2, rgb2, xOffset2 + x, yOffset2 + y);
                if (p1 == 0 || p2 == 0) continue;
                return true;
            }
        }
        return false;
    }

    protected int[] getRGB(Sprite sprite) {
        if (sprite instanceof AbstractMoaggAnimatedSprite) {
            return ((AbstractMoaggAnimatedSprite)sprite).getRGB();
        }
        return null;
    }

    protected int getRGB(BufferedImage img, int[] rgb, int x, int y) {
        int pixel = 0;
        pixel = rgb != null ? rgb[y * img.getWidth() + x] : img.getRGB(x, y);
        return pixel & 0xFFFFFF;
    }
}

