/*
 * Decompiled with CFR 0.152.
 */
package moagg.artwork.object;

import com.golden.gamedev.GameObject;
import com.golden.gamedev.util.ImageUtil;
import java.awt.image.BufferedImage;
import moagg.artwork.object.AbstractImageFactory;
import moagg.types.Orientation;
import moagg.types.TurretType;
import org.apache.log4j.Logger;

public class TurretImageFactory
extends AbstractImageFactory {
    private static Logger log = Logger.getLogger(TurretImageFactory.class);
    private static final String PATH = "/gfx/object/decoration/turret/";
    private static TurretImageFactory instance = new TurretImageFactory();
    private BufferedImage[][] turrets = null;
    private int[] turretHeight = null;

    public static TurretImageFactory getInstance() {
        return instance;
    }

    public void init(GameObject loader) {
        log.trace("Loading images.");
        TurretType[] values = TurretType.values();
        this.turrets = new BufferedImage[Orientation.values().length][values.length];
        this.turretHeight = new int[values.length];
        block0: for (TurretType turretType : values) {
            BufferedImage img = loader.getImage(PATH + turretType.getName() + ".png");
            for (int j = 0; j < Orientation.values().length; ++j) {
                this.turrets[j][turretType.ordinal()] = ImageUtil.rotate((BufferedImage)img, (int)(j * 90));
            }
            int x = img.getWidth() / 2;
            for (int y = img.getHeight() - 1; y >= 0; --y) {
                if (img.getRGB(x, y) != 0) continue;
                this.turretHeight[turretType.ordinal()] = img.getHeight() - y;
                log.trace("Calculated turret height of type " + (Object)((Object)turretType) + ": " + this.turretHeight[turretType.ordinal()]);
                continue block0;
            }
        }
        log.trace("Finished.");
    }

    public BufferedImage getImage(Orientation orientation, TurretType type) {
        log.trace("Getting image for a " + (Object)((Object)orientation) + "/" + (Object)((Object)type) + " turret.");
        return this.turrets[orientation.ordinal()][type.ordinal()];
    }

    public int getTurretHeight(TurretType type) {
        return this.turretHeight[type.ordinal()];
    }
}

