/*
 * Decompiled with CFR 0.152.
 */
package moagg.artwork.object;

import com.golden.gamedev.GameObject;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import moagg.artwork.object.AbstractImageFactory;
import moagg.types.Orientation;
import moagg.types.math.Point;
import moagg.types.math.Rectangle;
import moagg.util.ArgumentChecker;
import moagg.util.ArrayTool;
import moagg.util.ImageTool;
import org.apache.log4j.Logger;

public class ThornImageFactory
extends AbstractImageFactory {
    private static Logger log = Logger.getLogger(ThornImageFactory.class);
    private static final String PATH = "/gfx/object/decoration/thorn/";
    private static final int BASE_HEIGHT = 5;
    private static final int TIP_HEIGHT = 5;
    private static ThornImageFactory instance = new ThornImageFactory();
    private BufferedImage[] base = new BufferedImage[Orientation.values().length];
    private BufferedImage[] shaft = new BufferedImage[Orientation.values().length];
    private BufferedImage[] tip = new BufferedImage[Orientation.values().length];
    private int[][] rgbBase = new int[Orientation.values().length][];
    private int[][] rgbShaft = new int[Orientation.values().length][];
    private int[][] rgbTip = new int[Orientation.values().length][];

    public static ThornImageFactory getInstance() {
        return instance;
    }

    public void init(GameObject loader) {
        int i;
        log.trace("Loading images.");
        BufferedImage img = loader.getImage("/gfx/object/decoration/thorn/base.png");
        for (i = 0; i < this.base.length; ++i) {
            this.base[i] = ImageUtil.rotate((BufferedImage)img, (int)(i * 90));
            this.rgbBase[i] = ImageTool.getRGB(this.base[i]);
        }
        img = loader.getImage("/gfx/object/decoration/thorn/shaft.png");
        for (i = 0; i < this.shaft.length; ++i) {
            this.shaft[i] = ImageUtil.rotate((BufferedImage)img, (int)(i * 90));
            this.rgbShaft[i] = ImageTool.getRGB(this.shaft[i]);
        }
        img = loader.getImage("/gfx/object/decoration/thorn/tip.png");
        for (i = 0; i < this.tip.length; ++i) {
            this.tip[i] = ImageUtil.rotate((BufferedImage)img, (int)(i * 90));
            this.rgbTip[i] = ImageTool.getRGB(this.tip[i]);
        }
        log.trace("Finished.");
    }

    public BufferedImage[] getImages(Orientation orientation, int size) {
        ArgumentChecker.checkIntRange(size, 2, Integer.MAX_VALUE);
        log.trace("Getting images for a " + (Object)((Object)orientation) + "/" + size + " thorn.");
        int frames = 16 * (size - 1);
        BufferedImage[] images = new BufferedImage[2 * frames];
        for (int frame = 0; frame < frames; ++frame) {
            images[frame] = this.createImage(orientation, size, frame);
            images[2 * frames - 1 - frame] = images[frame];
        }
        return images;
    }

    protected BufferedImage createImage(Orientation orientation, int size, int height) {
        int w = 0;
        int h = 0;
        switch (orientation) {
            case TOP: 
            case BOTTOM: {
                w = 1;
                h = size;
                break;
            }
            case LEFT: 
            case RIGHT: {
                w = size;
                h = 1;
            }
        }
        BufferedImage image = ImageUtil.createImage((int)(16 * w), (int)(16 * h), (int)3);
        Graphics2D g = image.createGraphics();
        int x = 0;
        int y = 0;
        int heightTiles = height / 16;
        int heightRemainder = height % 16;
        switch (orientation) {
            case TOP: {
                g.drawImage(this.base[orientation.ordinal()], null, x, y);
                g.drawImage(this.shaft[orientation.ordinal()], 0, y += 5, 16, y + heightRemainder, 0, 16 - heightRemainder, 16, 16, null);
                y += heightRemainder;
                for (int i = 0; i < heightTiles; ++i) {
                    g.drawImage(this.shaft[orientation.ordinal()], null, x, y);
                    y += 16;
                }
                g.drawImage(this.tip[orientation.ordinal()], null, x, y);
                break;
            }
            case BOTTOM: {
                y = (size - 1) * 16;
                g.drawImage(this.base[orientation.ordinal()], null, x, y);
                g.drawImage(this.shaft[orientation.ordinal()], 0, (y -= 5) + 16 - heightRemainder, 16, y + 16, 0, 0, 16, heightRemainder, null);
                y -= heightRemainder;
                for (int i = 0; i < heightTiles; ++i) {
                    g.drawImage(this.shaft[orientation.ordinal()], null, x, y);
                    y -= 16;
                }
                g.drawImage(this.tip[orientation.ordinal()], null, x, y);
                break;
            }
            case LEFT: {
                g.drawImage(this.base[orientation.ordinal()], null, x, y);
                g.drawImage(this.shaft[orientation.ordinal()], x += 5, 0, x + heightRemainder, 16, 16 - heightRemainder, 0, 16, 16, null);
                x += heightRemainder;
                for (int i = 0; i < heightTiles; ++i) {
                    g.drawImage(this.shaft[orientation.ordinal()], null, x, y);
                    x += 16;
                }
                g.drawImage(this.tip[orientation.ordinal()], null, x, y);
                break;
            }
            case RIGHT: {
                x = (size - 1) * 16;
                g.drawImage(this.base[orientation.ordinal()], null, x, y);
                g.drawImage(this.shaft[orientation.ordinal()], (x -= 5) + 16 - heightRemainder, 0, x + 16, 16, 0, 0, heightRemainder, 16, null);
                x -= heightRemainder;
                for (int i = 0; i < heightTiles; ++i) {
                    g.drawImage(this.shaft[orientation.ordinal()], null, x, y);
                    x -= 16;
                }
                g.drawImage(this.tip[orientation.ordinal()], null, x, y);
            }
        }
        g.dispose();
        return image;
    }

    public int[][] getRGB(Orientation orientation, int size) {
        int frames = 16 * (size - 1);
        int[][] rgb = new int[2 * frames][];
        for (int frame = 0; frame < frames; ++frame) {
            rgb[frame] = this.getRGB(orientation, size, frame);
            rgb[2 * frames - 1 - frame] = rgb[frame];
        }
        return rgb;
    }

    protected int[] getRGB(Orientation orientation, int size, int height) {
        int w = 0;
        int h = 0;
        switch (orientation) {
            case TOP: 
            case BOTTOM: {
                w = 16;
                h = 16 * size;
                break;
            }
            case LEFT: 
            case RIGHT: {
                w = 16 * size;
                h = 16;
            }
        }
        int[] rgb = new int[w * h];
        int x = 0;
        int y = 0;
        int heightTiles = height / 16;
        int heightRemainder = height % 16;
        switch (orientation) {
            case TOP: {
                ArrayTool.copy(this.rgbBase[orientation.ordinal()], 16, new Rectangle(0, 0, 16, 5), rgb, w, new Point(x, y));
                ArrayTool.copy(this.rgbShaft[orientation.ordinal()], 16, new Rectangle(0, 16 - heightRemainder, 16, heightRemainder), rgb, w, new Point(x, y += 5));
                y += heightRemainder;
                for (int i = 0; i < heightTiles; ++i) {
                    ArrayTool.copy(this.rgbShaft[orientation.ordinal()], 16, new Rectangle(0, 0, 16, 16), rgb, w, new Point(x, y));
                    y += 16;
                }
                ArrayTool.copy(this.rgbTip[orientation.ordinal()], 16, new Rectangle(0, 0, 16, 5), rgb, w, new Point(x, y));
                break;
            }
            case BOTTOM: {
                y = (size - 1) * 16;
                ArrayTool.copy(this.rgbBase[orientation.ordinal()], 16, new Rectangle(0, 11, 16, 5), rgb, w, new Point(x, y + 16 - 5));
                ArrayTool.copy(this.rgbShaft[orientation.ordinal()], 16, new Rectangle(0, 0, 16, heightRemainder), rgb, w, new Point(x, (y -= 5) + 16 - heightRemainder));
                y -= heightRemainder;
                for (int i = 0; i < heightTiles; ++i) {
                    ArrayTool.copy(this.rgbShaft[orientation.ordinal()], 16, new Rectangle(0, 0, 16, 16), rgb, w, new Point(x, y));
                    y -= 16;
                }
                ArrayTool.copy(this.rgbTip[orientation.ordinal()], 16, new Rectangle(0, 11, 16, 5), rgb, w, new Point(x, y + 16 - 5));
                break;
            }
            case LEFT: {
                ArrayTool.copy(this.rgbBase[orientation.ordinal()], 16, new Rectangle(0, 0, 5, 16), rgb, w, new Point(x, y));
                ArrayTool.copy(this.rgbShaft[orientation.ordinal()], 16, new Rectangle(16 - heightRemainder, 0, heightRemainder, 16), rgb, w, new Point(x += 5, y));
                x += heightRemainder;
                for (int i = 0; i < heightTiles; ++i) {
                    ArrayTool.copy(this.rgbShaft[orientation.ordinal()], 16, new Rectangle(0, 0, 16, 16), rgb, w, new Point(x, y));
                    x += 16;
                }
                ArrayTool.copy(this.rgbTip[orientation.ordinal()], 16, new Rectangle(0, 0, 5, 16), rgb, w, new Point(x, y));
                break;
            }
            case RIGHT: {
                x = (size - 1) * 16;
                ArrayTool.copy(this.rgbBase[orientation.ordinal()], 16, new Rectangle(11, 0, 5, 16), rgb, w, new Point(x + 16 - 5, y));
                ArrayTool.copy(this.rgbShaft[orientation.ordinal()], 16, new Rectangle(0, 0, heightRemainder, 16), rgb, w, new Point((x -= 5) + 16 - heightRemainder, y));
                x -= heightRemainder;
                for (int i = 0; i < heightTiles; ++i) {
                    ArrayTool.copy(this.rgbShaft[orientation.ordinal()], 16, new Rectangle(0, 0, 16, 16), rgb, w, new Point(x, y));
                    x -= 16;
                }
                ArrayTool.copy(this.rgbTip[orientation.ordinal()], 16, new Rectangle(11, 0, 5, 16), rgb, w, new Point(x + 16 - 5, y));
            }
        }
        return rgb;
    }
}

