/*
 * Decompiled with CFR 0.152.
 */
package moagg.artwork.object;

import com.golden.gamedev.GameObject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import moagg.artwork.object.AbstractImageFactory;
import moagg.util.math.SinusTable;
import org.apache.log4j.Logger;

public class ProjectileImageFactory
extends AbstractImageFactory {
    private static Logger log = Logger.getLogger(ProjectileImageFactory.class);
    private static final String PATH = "/gfx/object/projectile/";
    private static ProjectileImageFactory instance = new ProjectileImageFactory();
    private BufferedImage projectile = null;
    private BufferedImage grenade = null;

    public static ProjectileImageFactory getInstance() {
        return instance;
    }

    public void init(GameObject loader) {
        log.trace("Loading images.");
        this.projectile = loader.getImage("/gfx/object/projectile/projectile.png");
        this.grenade = loader.getImage("/gfx/object/projectile/grenade.png");
        log.trace("Finished.");
    }

    public BufferedImage getProjectileImage() {
        return this.projectile;
    }

    public BufferedImage getGrenadeImage() {
        return this.grenade;
    }

    public BufferedImage getLaserImage(double angle, int beamLength) {
        BufferedImage image = new BufferedImage(beamLength, beamLength, 2);
        int m = beamLength / 2;
        Graphics2D g = image.createGraphics();
        g.setColor(new Color(255, 64, 64));
        g.drawLine(m + (int)((double)m * SinusTable.sin(angle)), m + (int)((double)m * SinusTable.cos(angle)), m + (int)((double)m * SinusTable.sin(angle + 180.0)), m + (int)((double)m * SinusTable.cos(angle + 180.0)));
        g.dispose();
        return image;
    }
}

