/*
 * Decompiled with CFR 0.152.
 */
package moagg.artwork.object;

import com.golden.gamedev.GameObject;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import moagg.artwork.object.AbstractImageFactory;
import moagg.types.PlatformEdge;
import moagg.util.ArgumentChecker;
import org.apache.log4j.Logger;

public class PlatformImageFactory
extends AbstractImageFactory {
    private static Logger log = Logger.getLogger(PlatformImageFactory.class);
    private static final String PATH = "/gfx/object/decoration/platform/";
    private static final int FRAMES = 2;
    private static PlatformImageFactory instance = new PlatformImageFactory();
    private BufferedImage[][] left = new BufferedImage[PlatformEdge.values().length][2];
    private BufferedImage center = null;
    private BufferedImage[][] right = new BufferedImage[PlatformEdge.values().length][2];
    private int platformHeight = 0;

    public static PlatformImageFactory getInstance() {
        return instance;
    }

    public void init(GameObject loader) {
        log.trace("Loading images.");
        for (PlatformEdge edge : EnumSet.range(PlatformEdge.NO_EDGE, PlatformEdge.NUMBER_9)) {
            this.left[edge.ordinal()][0] = loader.getImage("/gfx/object/decoration/platform/leftno" + edge.ordinal() + ".png");
            this.left[edge.ordinal()][1] = this.left[edge.ordinal()][0];
            this.right[edge.ordinal()][0] = loader.getImage("/gfx/object/decoration/platform/rightno" + edge.ordinal() + ".png");
            this.right[edge.ordinal()][1] = this.right[edge.ordinal()][0];
        }
        for (PlatformEdge edge : EnumSet.range(PlatformEdge.firstColor(), PlatformEdge.lastColor())) {
            for (int i = 0; i < 2; ++i) {
                this.left[edge.ordinal()][i] = loader.getImage(PATH + edge.getName() + "left" + (i + 1) + ".png");
                this.right[edge.ordinal()][i] = loader.getImage(PATH + edge.getName() + "right" + (i + 1) + ".png");
            }
        }
        this.left[PlatformEdge.FUEL.ordinal()][0] = loader.getImage("/gfx/object/decoration/platform/leftfuel.png");
        this.left[PlatformEdge.FUEL.ordinal()][1] = this.left[PlatformEdge.FUEL.ordinal()][0];
        this.right[PlatformEdge.FUEL.ordinal()][0] = loader.getImage("/gfx/object/decoration/platform/rightfuel.png");
        this.right[PlatformEdge.FUEL.ordinal()][1] = this.right[PlatformEdge.FUEL.ordinal()][0];
        this.center = loader.getImage("/gfx/object/decoration/platform/center.png");
        this.initPlatformHeight();
        log.trace("Finished.");
    }

    protected void initPlatformHeight() {
        for (int y = this.center.getHeight() - 1; y >= 0; --y) {
            if (this.center.getRGB(0, y) != 0) continue;
            this.platformHeight = this.center.getHeight() - y;
            break;
        }
        log.trace("Calculated platform height: " + this.platformHeight);
    }

    public BufferedImage[] getImages(PlatformEdge leftEdge, PlatformEdge rightEdge, int size) {
        ArgumentChecker.checkIntRange(size, 4, Integer.MAX_VALUE);
        log.trace("Getting images for a " + (Object)((Object)leftEdge) + "/" + (Object)((Object)rightEdge) + "/" + size + " platform.");
        BufferedImage[] img = new BufferedImage[2];
        for (int i = 0; i < img.length; ++i) {
            img[i] = ImageUtil.createImage((int)(16 * size), (int)16, (int)3);
            Graphics2D g = img[i].createGraphics();
            g.drawImage((Image)this.left[leftEdge.ordinal()][i], 0, 0, null);
            for (int j = 1; j < size - 1; ++j) {
                g.drawImage((Image)this.center, 16 * j, 0, null);
            }
            g.drawImage((Image)this.right[rightEdge.ordinal()][i], 16 * (size - 1), 0, null);
            g.dispose();
        }
        return img;
    }

    public int[][] getRGB(PlatformEdge leftEdge, PlatformEdge rightEdge, int size) {
        int[][] rgb = new int[2][256 * size];
        for (int i = 0; i < 2; ++i) {
            for (int y = 0; y < 16; ++y) {
                int yOff = y * (16 * size);
                for (int x = 0; x < 16 * size; ++x) {
                    int pixel = 0;
                    pixel = x < 16 ? this.left[leftEdge.ordinal()][i].getRGB(x, y) : (x < 16 * (size - 1) ? this.center.getRGB(x % 16, y) : this.right[rightEdge.ordinal()][i].getRGB(x % 16, y));
                    rgb[i][yOff + x] = pixel;
                }
            }
        }
        return rgb;
    }

    public int getPlatformHeight() {
        return this.platformHeight;
    }
}

