/*
 * Decompiled with CFR 0.152.
 */
package moagg.artwork.object;

import com.golden.gamedev.GameObject;
import com.golden.gamedev.util.ImageUtil;
import java.awt.image.BufferedImage;
import moagg.artwork.object.AbstractControllableImageFactory;
import moagg.types.math.Rectangle;
import org.apache.log4j.Logger;

public class MissileImageFactory
extends AbstractControllableImageFactory {
    private static Logger log = Logger.getLogger(MissileImageFactory.class);
    private static final String PATH = "/gfx/object/projectile/";
    private static MissileImageFactory instance = new MissileImageFactory();
    private BufferedImage[] missiles = new BufferedImage[60];
    private Rectangle landingZone = null;

    public static MissileImageFactory getInstance() {
        return instance;
    }

    public void init(GameObject loader) {
        log.trace("Loading images.");
        BufferedImage missile = loader.getImage("/gfx/object/projectile/missile.png");
        for (int i = 0; i < 60; ++i) {
            this.missiles[i] = ImageUtil.rotate((BufferedImage)missile, (int)(180 - 6 * i));
        }
        this.landingZone = this.calculateLandingZone(missile);
        log.trace("Calculated landing zone for missile.");
        log.trace("Finished.");
    }

    public BufferedImage[] getImages() {
        log.trace("Getting images for a missile.");
        return this.missiles;
    }

    public Rectangle getLandingZone() {
        return this.landingZone;
    }
}

