/*
 * Decompiled with CFR 0.152.
 */
package moagg.artwork.object;

import com.golden.gamedev.GameObject;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import moagg.artwork.object.AbstractImageFactory;
import moagg.types.HVOrientation;
import moagg.util.ArgumentChecker;
import org.apache.log4j.Logger;

public class BarrierImageFactory
extends AbstractImageFactory {
    private static Logger log = Logger.getLogger(BarrierImageFactory.class);
    private static final String PATH = "/gfx/object/decoration/barrier/";
    private static final int FRAMES = 2;
    private static BarrierImageFactory instance = new BarrierImageFactory();
    private BufferedImage[] left = new BufferedImage[HVOrientation.values().length];
    private BufferedImage[] beam = new BufferedImage[HVOrientation.values().length];
    private BufferedImage[] right = new BufferedImage[HVOrientation.values().length];
    private BufferedImage deactivated = null;

    public static BarrierImageFactory getInstance() {
        return instance;
    }

    public void init(GameObject loader) {
        int i;
        log.trace("Loading images.");
        BufferedImage img = loader.getImage("/gfx/object/decoration/barrier/left.png");
        for (i = 0; i < this.left.length; ++i) {
            this.left[i] = ImageUtil.rotate((BufferedImage)img, (int)(i * 90));
        }
        img = loader.getImage("/gfx/object/decoration/barrier/beam.png");
        for (i = 0; i < this.beam.length; ++i) {
            this.beam[i] = ImageUtil.rotate((BufferedImage)img, (int)(i * 90));
        }
        img = loader.getImage("/gfx/object/decoration/barrier/right.png");
        for (i = 0; i < this.right.length; ++i) {
            this.right[i] = ImageUtil.rotate((BufferedImage)img, (int)(i * 90));
        }
        this.deactivated = loader.getImage("/gfx/object/decoration/barrier/deactivated.png");
        log.trace("Finished.");
    }

    public BufferedImage[] getImages(HVOrientation hvOrientation, int size) {
        ArgumentChecker.checkIntRange(size, 3, Integer.MAX_VALUE);
        log.trace("Getting images for a " + (Object)((Object)hvOrientation) + "/" + size + " thorn.");
        BufferedImage[] images = new BufferedImage[]{this.createImage(hvOrientation, size, false), this.createImage(hvOrientation, size, true)};
        return images;
    }

    protected BufferedImage createImage(HVOrientation hvOrientation, int size, boolean activated) {
        int w = 0;
        int h = 0;
        switch (hvOrientation) {
            case HORIZONTAL: {
                w = 16 * size;
                h = 16;
                break;
            }
            case VERTICAL: {
                w = 16;
                h = 16 * size;
            }
        }
        BufferedImage img = ImageUtil.createImage((int)w, (int)h, (int)3);
        Graphics2D g = img.createGraphics();
        int x = 0;
        int y = 0;
        g.drawImage((Image)this.left[hvOrientation.ordinal()], x, y, null);
        switch (hvOrientation) {
            case HORIZONTAL: {
                for (x = 16; x < (size - 1) * 16; x += 16) {
                    g.drawImage((Image)(activated ? this.beam[hvOrientation.ordinal()] : this.deactivated), x, y, null);
                }
                break;
            }
            case VERTICAL: {
                for (y = 16; y < (size - 1) * 16; y += 16) {
                    g.drawImage((Image)(activated ? this.beam[hvOrientation.ordinal()] : this.deactivated), x, y, null);
                }
                break;
            }
        }
        g.drawImage((Image)this.right[hvOrientation.ordinal()], x, y, null);
        g.dispose();
        return img;
    }

    public int[][] getRGB(HVOrientation hvOrientation, int size) {
        int[][] rgb = new int[2][256 * size];
        int w = 0;
        int h = 0;
        switch (hvOrientation) {
            case HORIZONTAL: {
                w = 16 * size;
                h = 16;
                break;
            }
            case VERTICAL: {
                w = 16;
                h = 16 * size;
            }
        }
        for (int i = 0; i < 2; ++i) {
            for (int y = 0; y < h; ++y) {
                int yOff = y * w;
                for (int x = 0; x < w; ++x) {
                    int pixel = 0;
                    switch (hvOrientation) {
                        case HORIZONTAL: {
                            if (x < 16) {
                                pixel = this.left[hvOrientation.ordinal()].getRGB(x, y);
                                break;
                            }
                            if (x < 16 * (size - 1)) {
                                pixel = i == 0 ? 0 : this.beam[hvOrientation.ordinal()].getRGB(x % 16, y);
                                break;
                            }
                            pixel = this.right[hvOrientation.ordinal()].getRGB(x % 16, y);
                            break;
                        }
                        case VERTICAL: {
                            pixel = y < 16 ? this.left[hvOrientation.ordinal()].getRGB(x, y) : (y < 16 * (size - 1) ? (i == 0 ? 0 : this.beam[hvOrientation.ordinal()].getRGB(x, y % 16)) : this.right[hvOrientation.ordinal()].getRGB(x, y % 16));
                        }
                    }
                    rgb[i][yOff + x] = pixel;
                }
            }
        }
        return rgb;
    }
}

