/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.lwjgl;

import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.engine.graphics.WindowExitListener;
import com.golden.gamedev.engine.lwjgl.LWJGLGraphics;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;

public class LWJGLMode
implements BaseGraphics,
Comparator {
    private Dimension a;
    private boolean b;
    private boolean c;
    private WindowListener d;
    private Graphics2D e;

    public LWJGLMode(Dimension dimension, boolean bl, boolean bl2) {
        this.a = dimension;
        this.b = bl;
        this.c = bl2;
        this.d();
        this.c();
        this.e = new LWJGLGraphics();
        this.d = WindowExitListener.getInstance();
    }

    public LWJGLMode(Dimension dimension, boolean bl) {
        this(dimension, bl, true);
    }

    private void c() {
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.a.width, (double)this.a.height, (double)0.0, (double)-1.0, (double)1.0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private void d() {
        try {
            DisplayMode displayMode;
            DisplayMode displayMode2;
            if (this.b) {
                LWJGLMode lWJGLMode = this;
                displayMode2 = lWJGLMode.u(lWJGLMode.a);
            } else {
                displayMode2 = displayMode = new DisplayMode(this.a.width, this.a.height);
            }
            if (displayMode2 == null) {
                throw new Exception();
            }
            Display.setDisplayMode((DisplayMode)displayMode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("LWJGL Error: Unable to set desired display mode (" + this.a.width + "x" + this.a.height + "x" + 16 + ")");
        }
        try {
            Display.setTitle((String)"Golden T Game Engine");
            Display.setFullscreen((boolean)this.b);
            Display.setVSyncEnabled((boolean)this.c);
            Display.create();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("LWJGL Error: Unable to initialize display");
        }
    }

    public Graphics2D getBackBuffer() {
        return this.e;
    }

    public boolean flip() {
        if (Display.isCloseRequested()) {
            this.d.windowClosing(null);
        } else if (Display.isActive()) {
            Display.update();
        } else if (Display.isVisible() || Display.isDirty()) {
            Display.update();
        }
        return true;
    }

    public void cleanup() {
        try {
            Display.destroy();
            return;
        }
        catch (Exception exception) {
            System.err.println("ERROR: Shutting down graphics context " + exception);
            System.exit(-1);
            return;
        }
    }

    public Dimension getSize() {
        return this.a;
    }

    public Component getComponent() {
        return null;
    }

    public String getGraphicsDescription() {
        return "OpenGL LWJGL " + (this.b ? "Full Screen" : "Windowed") + " Mode [" + this.getSize().width + "x" + this.getSize().height + "]" + (this.c ? " with VSync" : "");
    }

    public void setWindowTitle(String string) {
        Display.setTitle((String)string);
    }

    public String getWindowTitle() {
        return Display.getTitle();
    }

    public void setWindowIcon(Image image) {
    }

    public Image getWindowIcon() {
        return null;
    }

    public boolean isFullScreen() {
        return this.b;
    }

    public boolean setFullScreen(boolean bl) {
        if (this.b != bl) {
            try {
                Display.setFullscreen((boolean)bl);
            }
            catch (LWJGLException lWJGLException) {
                return false;
            }
            this.b = bl;
        }
        return true;
    }

    public boolean isVSync() {
        return this.c;
    }

    public void setVSync(boolean bl) {
        if (this.c != bl) {
            Display.setVSyncEnabled((boolean)bl);
            this.c = bl;
        }
    }

    public void setWindowListener(WindowListener windowListener) {
        this.d = windowListener;
    }

    public WindowListener getWindowListener() {
        return this.d;
    }

    private DisplayMode u(Dimension dimension) {
        try {
            DisplayMode[] displayModeArray = Display.getAvailableDisplayModes();
            ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
            int n = 0;
            while (n < displayModeArray.length) {
                if (displayModeArray[n].getWidth() == dimension.width && displayModeArray[n].getHeight() == dimension.height) {
                    arrayList.add(displayModeArray[n]);
                }
                ++n;
            }
            if (arrayList.size() == 0) {
                return null;
            }
            DisplayMode[] displayModeArray2 = arrayList.toArray(new DisplayMode[0]);
            Arrays.sort(displayModeArray2, this);
            return displayModeArray2[0];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int compare(Object object, Object object2) {
        DisplayMode displayMode = (DisplayMode)object;
        DisplayMode displayMode2 = (DisplayMode)object2;
        int n = displayMode.getFrequency() > 75 ? 5000 * displayMode.getFrequency() : 0;
        int n2 = displayMode2.getFrequency() > 75 ? 5000 * displayMode2.getFrequency() : 0;
        return (displayMode2.getBitsPerPixel() - displayMode.getBitsPerPixel()) * 1000 + (displayMode2.getFrequency() - displayMode.getFrequency()) - (n2 - n);
    }
}

