/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.util;

import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static final GraphicsConfiguration CONFIG = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    private static final MediaTracker b;

    public static BufferedImage getImage(URL uRL, int n) {
        try {
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            ImageUtil.i(image);
            BufferedImage bufferedImage = ImageUtil.createImage(image.getWidth(null), image.getHeight(null), n);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage;
        }
        catch (Exception exception) {
            System.err.println("ERROR: Unable to load Image = " + uRL);
            exception.printStackTrace();
            return ImageUtil.createImage(50, 50);
        }
    }

    public static BufferedImage getImage(URL uRL) {
        return ImageUtil.getImage(uRL, 1);
    }

    public static BufferedImage getImage(URL uRL, Color color) {
        try {
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            ImageUtil.i(image);
            return ImageUtil.applyMask(image, color);
        }
        catch (Exception exception) {
            System.err.println("ERROR: Unable to load Image = " + uRL);
            exception.printStackTrace();
            return ImageUtil.createImage(50, 50);
        }
    }

    public static BufferedImage[] getImages(URL uRL, int n, int n2, int n3) {
        return ImageUtil.splitImages(ImageUtil.getImage(uRL, n3), n, n2);
    }

    public static BufferedImage[] getImages(URL uRL, int n, int n2) {
        return ImageUtil.splitImages(ImageUtil.getImage(uRL), n, n2);
    }

    public static BufferedImage[] getImages(URL uRL, int n, int n2, Color color) {
        return ImageUtil.splitImages(ImageUtil.getImage(uRL, color), n, n2);
    }

    public static BufferedImage createImage(int n, int n2, int n3) {
        return CONFIG.createCompatibleImage(n, n2, n3);
    }

    public static BufferedImage createImage(int n, int n2) {
        return ImageUtil.createImage(n, n2, 1);
    }

    private static void i(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        try {
            b.addImage(image, 0);
            b.waitForAll();
            if ((b.statusID(0, true) & 4) != 0) {
                throw new RuntimeException();
            }
            return;
        }
        catch (Exception exception) {
            b.removeImage(image, 0);
            throw exception;
        }
    }

    public static BufferedImage applyMask(Image image, Color color) {
        BufferedImage bufferedImage = ImageUtil.createImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        int n = 0;
        while (n < bufferedImage.getHeight()) {
            int n2 = 0;
            while (n2 < bufferedImage.getWidth()) {
                int n3 = bufferedImage.getRGB(n2, n);
                if (n3 == color.getRGB()) {
                    bufferedImage.setRGB(n2, n, n3 & 0xFFFFFF);
                }
                ++n2;
            }
            ++n;
        }
        return bufferedImage;
    }

    public static BufferedImage[] splitImages(BufferedImage bufferedImage, int n, int n2) {
        int n3 = n * n2;
        int n4 = 0;
        int n5 = bufferedImage.getWidth() / n;
        int n6 = bufferedImage.getHeight() / n2;
        BufferedImage[] bufferedImageArray = new BufferedImage[n3];
        int n7 = 0;
        while (n7 < n2) {
            int n8 = 0;
            while (n8 < n) {
                int n9 = bufferedImage.getColorModel().getTransparency();
                bufferedImageArray[n4] = ImageUtil.createImage(n5, n6, n9);
                Graphics2D graphics2D = bufferedImageArray[n4].createGraphics();
                graphics2D.drawImage(bufferedImage, 0, 0, n5, n6, n8 * n5, n7 * n6, (n8 + 1) * n5, (n7 + 1) * n6, null);
                graphics2D.dispose();
                ++n4;
                ++n8;
            }
            ++n7;
        }
        return bufferedImageArray;
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = bufferedImage.getColorModel().getTransparency();
        BufferedImage bufferedImage2 = ImageUtil.createImage(n2, n3, n4);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.rotate(Math.toRadians(n), n2 / 2, n3 / 2);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage resize(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getColorModel().getTransparency();
        BufferedImage bufferedImage2 = ImageUtil.createImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage flip(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = ImageUtil.createImage(n, n2, bufferedImage.getColorModel().getTransparency());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, n, 0, 0, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static void saveImage(BufferedImage bufferedImage, File file) {
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            return;
        }
        catch (IOException iOException) {
            System.err.println("ERROR: unable to save = " + file);
            iOException.printStackTrace();
            return;
        }
    }

    public static byte[] toByteArray(BufferedImage bufferedImage, String string) {
        if (bufferedImage != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            try {
                ImageIO.write((RenderedImage)bufferedImage, string, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException.toString());
            }
            return byteArrayOutputStream.toByteArray();
        }
        return new byte[0];
    }

    public static BufferedImage fromByteArray(byte[] byArray) {
        try {
            if (byArray != null && byArray.length > 0) {
                return ImageIO.read(new ByteArrayInputStream(byArray));
            }
            return null;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.toString());
        }
    }

    static {
        Canvas canvas = new Canvas();
        b = new MediaTracker(canvas);
    }
}

