/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.font;

import com.golden.gamedev.object.GameFont;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class SystemFont
implements GameFont {
    private final Font a;
    private final FontMetrics b;
    private int c;
    private int d;
    private Color e;

    public SystemFont(Font font, Color color) {
        this.a = font;
        this.e = color;
        Graphics2D graphics2D = ImageUtil.createImage(1, 1).createGraphics();
        this.b = graphics2D.getFontMetrics(font);
        this.c = this.b.getMaxAscent() + this.b.getMaxDescent() + this.b.getLeading();
        this.d = this.c - this.b.getDescent();
        graphics2D.dispose();
    }

    public SystemFont(Font font) {
        this(font, null);
    }

    public int drawString(Graphics2D graphics2D, String string, int n, int n2) {
        if (graphics2D.getFont() != this.a) {
            graphics2D.setFont(this.a);
        }
        if (this.e != null) {
            graphics2D.setColor(this.e);
        }
        graphics2D.drawString(string, n, n2 + this.d);
        return n + this.getWidth(string);
    }

    public int drawString(Graphics2D graphics2D, String string, int n, int n2, int n3, int n4) {
        if (n == 1) {
            return this.drawString(graphics2D, string, n2, n3);
        }
        if (n == 3) {
            return this.drawString(graphics2D, string, n2 + n4 / 2 - this.getWidth(string) / 2, n3);
        }
        if (n == 2) {
            return this.drawString(graphics2D, string, n2 + n4 - this.getWidth(string), n3);
        }
        if (n == 4) {
            int n5 = n4 - this.getWidth(string);
            if (n5 <= 0) {
                return this.drawString(graphics2D, string, n2, n3);
            }
            int n6 = string.length();
            int n7 = 0;
            int n8 = 0;
            while (n8 < n6) {
                if (string.charAt(n8++) != ' ') continue;
                ++n7;
            }
            if (n7 > 0) {
                n7 = (n5 + n7 * this.getWidth(' ')) / n7;
            }
            n8 = 0;
            while (n8 < n6) {
                int n9 = string.indexOf(32, n8);
                if (n9 == -1) {
                    n9 = n6;
                }
                String string2 = string.substring(n8, n9);
                this.drawString(graphics2D, string2, n2, n3);
                n2 += this.getWidth(string2) + n7;
                n8 = n9 + 1;
            }
            return n2;
        }
        return 0;
    }

    public int drawText(Graphics2D graphics2D, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = true;
        int n7 = string.length();
        int n8 = n6;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n7) {
            char c = string.charAt(n11++);
            n8 += this.getWidth(c);
            if (c - 32 == 0) {
                n9 = n11 - 1;
            }
            if (n8 < n4) continue;
            if (bl) {
                int n12 = n;
                this.drawString(graphics2D, string.substring(n10, n9), n12, n12 == 2 ? n2 : n2 + n6, n3, n4 - n6);
                bl = false;
            } else {
                this.drawString(graphics2D, string.substring(n10, n9), n, n2, n3, n4);
            }
            n3 += this.getHeight() + n5;
            n8 = 0;
            n10 = n11 = n9 + 1;
        }
        if (bl) {
            int n13 = n;
            this.drawString(graphics2D, string.substring(n10, n11), n13, n13 == 2 ? n2 : n2 + n6, n3, n4 - n6);
        } else if (n8 != 0) {
            this.drawString(graphics2D, string.substring(n10, n11), n == 2 ? 2 : 1, n2, n3, n4);
        }
        return n3 + this.getHeight();
    }

    public Font getFont() {
        return this.a;
    }

    public FontMetrics getFontMetrics() {
        return this.b;
    }

    public Color getColor() {
        return this.e;
    }

    public void setColor(Color color) {
        this.e = color;
    }

    public int getWidth(String string) {
        return this.b.stringWidth(string);
    }

    public int getWidth(char c) {
        return this.b.charWidth(c);
    }

    public int getHeight() {
        return this.c;
    }

    public String toString() {
        return super.toString() + " " + "[basefont=" + this.a + ", color=" + this.e + "]";
    }

    public boolean isAvailable(char c) {
        return true;
    }
}

