/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.collision;

import com.golden.gamedev.object.collision.CollisionShape;

public class CollisionRect
implements CollisionShape {
    public double x = 0.0;
    public double y = 0.0;
    public int width = 0;
    public int height = 0;
    private int e;
    private int f;

    public void grow(int n, int n2) {
        if (n >= 0) {
            this.width += n;
        } else {
            this.x += (double)n;
            this.width -= n;
        }
        if (n2 >= 0) {
            this.height += n2;
            return;
        }
        this.y += (double)n2;
        this.height -= n2;
    }

    public void shrink(int n, int n2) {
        if (n >= 0) {
            this.width -= n;
        } else {
            this.x -= (double)n;
            this.width += n;
        }
        if (n2 >= 0) {
            this.height -= n2;
            return;
        }
        this.y -= (double)n2;
        this.height += n2;
    }

    public boolean intersects(CollisionShape collisionShape) {
        if (this.x < collisionShape.getX()) {
            this.e = (int)this.x;
            this.f = (int)Math.ceil(collisionShape.getX());
        } else {
            this.e = (int)Math.ceil(this.x);
            this.f = (int)collisionShape.getX();
        }
        return this.e + this.width > this.f && this.e < this.f + collisionShape.getWidth() && this.y + (double)this.height > collisionShape.getY() && this.y < collisionShape.getY() + (double)collisionShape.getHeight();
    }

    public void setBounds(double d, double d2, int n, int n2) {
        this.x = d;
        this.y = d2;
        this.width = n;
        this.height = n2;
    }

    public void setBounds(CollisionRect collisionRect) {
        this.setBounds(collisionRect.x, collisionRect.y, collisionRect.width, collisionRect.height);
    }

    public void setLocation(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void move(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return super.toString() + " " + "[x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

