/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.graphics;

import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.engine.graphics.WindowExitListener;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class FullScreenMode
implements BaseGraphics,
Comparator {
    public static final GraphicsDevice DEVICE = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    public static final GraphicsConfiguration CONFIG = DEVICE.getDefaultConfiguration();
    private Frame d;
    private Dimension e;
    private VolatileImage f;
    private BufferStrategy g;
    private Graphics2D h;
    static Class a;

    public FullScreenMode(Dimension dimension, boolean bl) {
        this.e = dimension;
        if (!DEVICE.isFullScreenSupported()) {
            throw new RuntimeException("Full Screen Exclusive Mode is not supported");
        }
        this.d = new Frame("Golden T Game Engine", CONFIG);
        try {
            this.d.setIconImage(ImageUtil.getImage((a == null ? (a = FullScreenMode.a("com.golden.gamedev.engine.graphics.FullScreenMode")) : a).getResource("Icon.png")));
        }
        catch (Exception exception) {}
        this.d.addWindowListener(WindowExitListener.getInstance());
        this.d.setResizable(false);
        this.d.setIgnoreRepaint(true);
        this.d.setLayout(null);
        this.d.setUndecorated(true);
        this.d.dispose();
        DEVICE.setFullScreenWindow(this.d);
        if (!DEVICE.isDisplayChangeSupported()) {
            DEVICE.setFullScreenWindow(null);
            this.d.dispose();
            throw new RuntimeException("Changing Display Mode is not supported");
        }
        FullScreenMode fullScreenMode = this;
        DisplayMode displayMode = fullScreenMode.q(fullScreenMode.e);
        if (displayMode == null) {
            DEVICE.setFullScreenWindow(null);
            this.d.dispose();
            throw new RuntimeException("Changing Display Mode to " + this.e.width + "x" + this.e.height + " is not supported");
        }
        DEVICE.setDisplayMode(displayMode);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        if (bl) {
            this.c();
        } else {
            this.d();
        }
        this.d.requestFocus();
    }

    private void c() {
        this.d.createBufferStrategy(2);
        while (this.g == null) {
            try {
                this.g = this.d.getBufferStrategy();
            }
            catch (Exception exception) {}
        }
        while (true) {
            try {
                this.getBackBuffer();
                return;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private void d() {
        if (this.f != null) {
            this.f.flush();
            this.f = null;
        }
        this.f = CONFIG.createCompatibleVolatileImage(this.e.width, this.e.height);
    }

    public Graphics2D getBackBuffer() {
        if (this.h == null) {
            if (this.g == null) {
                if (this.f.validate(CONFIG) == 2) {
                    this.d();
                }
                this.h = this.f.createGraphics();
            } else {
                this.h = (Graphics2D)this.g.getDrawGraphics();
            }
        }
        return this.h;
    }

    public boolean flip() {
        this.h.dispose();
        this.h = null;
        if (this.g == null) {
            this.d.getGraphics().drawImage(this.f, 0, 0, null);
            Toolkit.getDefaultToolkit().sync();
            return !this.f.contentsLost();
        }
        this.g.show();
        Toolkit.getDefaultToolkit().sync();
        return !this.g.contentsLost();
    }

    public void cleanup() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        try {
            Thread.sleep(200L);
            if (this.d != null) {
                this.d.dispose();
            }
            return;
        }
        catch (Exception exception) {
            System.err.println("ERROR: Shutting down graphics context " + exception);
            System.exit(-1);
            return;
        }
    }

    public Dimension getSize() {
        return this.e;
    }

    public Component getComponent() {
        return this.d;
    }

    public Frame getFrame() {
        return this.d;
    }

    public boolean isBufferStrategy() {
        return this.g != null;
    }

    public String getGraphicsDescription() {
        return "Full Screen Mode [" + this.getSize().width + "x" + this.getSize().height + "]" + (this.g != null ? " with BufferStrategy" : "");
    }

    public void setWindowTitle(String string) {
        this.d.setTitle(string);
    }

    public String getWindowTitle() {
        return this.d.getTitle();
    }

    public void setWindowIcon(Image image) {
        try {
            this.d.setIconImage(image);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Image getWindowIcon() {
        return this.d.getIconImage();
    }

    private DisplayMode q(Dimension dimension) {
        DisplayMode[] displayModeArray = DEVICE.getDisplayModes();
        ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
        int n = 0;
        while (n < displayModeArray.length) {
            if (displayModeArray[n].getWidth() == dimension.width && displayModeArray[n].getHeight() == dimension.height) {
                arrayList.add(displayModeArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        DisplayMode[] displayModeArray2 = arrayList.toArray(new DisplayMode[0]);
        Arrays.sort(displayModeArray2, this);
        return displayModeArray2[0];
    }

    public int compare(Object object, Object object2) {
        DisplayMode displayMode = (DisplayMode)object;
        DisplayMode displayMode2 = (DisplayMode)object2;
        int n = displayMode.getRefreshRate() > 75 ? 5000 * displayMode.getRefreshRate() : 0;
        int n2 = displayMode2.getRefreshRate() > 75 ? 5000 * displayMode2.getRefreshRate() : 0;
        return (displayMode2.getBitDepth() - displayMode.getBitDepth()) * 1000 + (displayMode2.getRefreshRate() - displayMode.getRefreshRate()) - (n2 - n);
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

