/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine;

import com.golden.gamedev.engine.BaseIO;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BaseLoader {
    private BaseIO a;
    private Color b;
    private Map c;
    private Map d;

    public BaseLoader(BaseIO baseIO, Color color) {
        this.a = baseIO;
        this.b = color;
        this.c = new HashMap(5);
        this.d = new HashMap(30);
    }

    public BufferedImage getImage(String string, boolean bl) {
        BufferedImage bufferedImage = (BufferedImage)this.c.get(string);
        if (bufferedImage == null) {
            URL uRL = this.a.getURL(string);
            bufferedImage = bl ? ImageUtil.getImage(uRL, this.b) : ImageUtil.getImage(uRL);
            this.c.put(string, bufferedImage);
        }
        return bufferedImage;
    }

    public BufferedImage getImage(String string) {
        return this.getImage(string, true);
    }

    public BufferedImage[] getImages(String string, int n, int n2, boolean bl) {
        BufferedImage[] bufferedImageArray = (BufferedImage[])this.d.get(string);
        if (bufferedImageArray == null) {
            URL uRL = this.a.getURL(string);
            bufferedImageArray = bl ? ImageUtil.getImages(uRL, n, n2, this.b) : ImageUtil.getImages(uRL, n, n2);
            this.d.put(string, bufferedImageArray);
        }
        return bufferedImageArray;
    }

    public BufferedImage[] getImages(String string, int n, int n2) {
        return this.getImages(string, n, n2, true);
    }

    public void storeImage(String string, BufferedImage bufferedImage) {
        if (this.c.get(string) != null) {
            throw new ArrayStoreException("Key -> " + string + " is bounded to " + this.c.get(string));
        }
        this.c.put(string, bufferedImage);
    }

    public void storeImages(String string, BufferedImage[] bufferedImageArray) {
        if (this.d.get(string) != null) {
            throw new ArrayStoreException("Key -> " + string + " is bounded to " + this.d.get(string));
        }
        this.d.put(string, bufferedImageArray);
    }

    public BufferedImage getStoredImage(String string) {
        return (BufferedImage)this.c.get(string);
    }

    public BufferedImage[] getStoredImages(String string) {
        return (BufferedImage[])this.d.get(string);
    }

    public boolean removeImage(BufferedImage bufferedImage) {
        Iterator iterator = this.c.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != bufferedImage) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeImages(BufferedImage[] bufferedImageArray) {
        Iterator iterator = this.d.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != bufferedImageArray) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public BufferedImage removeImage(String string) {
        return (BufferedImage)this.c.remove(string);
    }

    public BufferedImage[] removeImages(String string) {
        return (BufferedImage[])this.d.remove(string);
    }

    public BaseIO getBaseIO() {
        return this.a;
    }

    public void setBaseIO(BaseIO baseIO) {
        this.a = baseIO;
    }

    public Color getMaskColor() {
        return this.b;
    }

    public void setMaskColor(Color color) {
        this.b = color;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = this.c.keySet().iterator();
        Iterator iterator2 = this.d.keySet().iterator();
        stringBuffer.append("\"");
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("\"");
        stringBuffer2.append("\"");
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            BufferedImage[] bufferedImageArray = (BufferedImage[])this.d.get(string);
            int n = bufferedImageArray == null ? -1 : bufferedImageArray.length;
            stringBuffer2.append(string).append("(").append(n).append(")");
            if (!iterator2.hasNext()) continue;
            stringBuffer2.append(",");
        }
        stringBuffer2.append("\"");
        return super.toString() + " " + "[maskColor=" + this.b + ", BaseIO=" + this.a + ", imageLoaded=" + stringBuffer + ", imagesLoaded=" + stringBuffer2 + "]";
    }
}

