/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine;

import java.io.File;
import java.io.InputStream;
import java.net.URL;

public class BaseIO {
    public static final int CLASS_URL = 1;
    public static final int WORKING_DIRECTORY = 2;
    public static final int CLASS_LOADER = 3;
    public static final int SYSTEM_LOADER = 4;
    private Class e;
    private ClassLoader f;
    private int g;

    public BaseIO(Class clazz, int n) {
        this.e = clazz;
        this.f = clazz.getClassLoader();
        this.g = n;
    }

    public BaseIO(Class clazz) {
        this(clazz, 1);
    }

    public URL getURL(String string, int n) {
        URL uRL = null;
        try {
            switch (n) {
                case 1: {
                    uRL = this.e.getResource(string);
                    break;
                }
                case 2: {
                    File file = new File(string);
                    if (file.exists()) {
                        uRL = file.toURL();
                    }
                    break;
                }
                case 3: {
                    uRL = this.f.getResource(string);
                    break;
                }
                case 4: {
                    uRL = ClassLoader.getSystemResource(string);
                }
            }
        }
        catch (Exception exception) {}
        if (uRL == null) {
            throw new RuntimeException(this.getException(string, n, "getURL"));
        }
        return uRL;
    }

    public URL getURL(String string) {
        URL uRL = null;
        try {
            uRL = this.getURL(string, this.g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRL == null) {
            int n = 0;
            while (uRL == null && !this.getModeString(++n).equals("[UNKNOWN-MODE]")) {
                try {
                    uRL = this.getURL(string, n);
                }
                catch (Exception exception) {}
            }
            if (uRL == null) {
                throw new RuntimeException(this.getException(string, this.g, "getURL"));
            }
            this.g = n;
        }
        return uRL;
    }

    public InputStream getStream(String string, int n) {
        InputStream inputStream = null;
        try {
            switch (n) {
                case 1: {
                    inputStream = this.e.getResourceAsStream(string);
                    break;
                }
                case 2: {
                    inputStream = new File(string).toURL().openStream();
                    break;
                }
                case 3: {
                    inputStream = this.f.getResourceAsStream(string);
                    break;
                }
                case 4: {
                    inputStream = ClassLoader.getSystemResourceAsStream(string);
                }
            }
        }
        catch (Exception exception) {}
        if (inputStream == null) {
            throw new RuntimeException(this.getException(string, n, "getStream"));
        }
        return inputStream;
    }

    public InputStream getStream(String string) {
        InputStream inputStream = null;
        try {
            inputStream = this.getStream(string, this.g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream == null) {
            int n = 0;
            while (inputStream == null && !this.getModeString(++n).equals("[UNKNOWN-MODE]")) {
                try {
                    inputStream = this.getStream(string, n);
                }
                catch (Exception exception) {}
            }
            if (inputStream == null) {
                throw new RuntimeException(this.getException(string, this.g, "getStream"));
            }
            this.g = n;
        }
        return inputStream;
    }

    public File getFile(String string, int n) {
        File file = null;
        try {
            switch (n) {
                case 1: {
                    file = new File(this.e.getResource(string).getFile().replaceAll("%20", " "));
                    break;
                }
                case 2: {
                    file = new File(string);
                    break;
                }
                case 3: {
                    file = new File(this.f.getResource(string).getFile().replaceAll("%20", " "));
                    break;
                }
                case 4: {
                    file = new File(ClassLoader.getSystemResource(string).getFile().replaceAll("%20", " "));
                }
            }
        }
        catch (Exception exception) {}
        if (file == null) {
            throw new RuntimeException(this.getException(string, n, "getFile"));
        }
        return file;
    }

    public File getFile(String string) {
        File file = null;
        try {
            file = this.getFile(string, this.g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null) {
            int n = 0;
            while (file == null && !this.getModeString(++n).equals("[UNKNOWN-MODE]")) {
                try {
                    file = this.getFile(string, n);
                }
                catch (Exception exception) {}
            }
            if (file == null) {
                throw new RuntimeException(this.getException(string, this.g, "getFile"));
            }
            this.g = n;
        }
        return file;
    }

    public File setFile(String string, int n) {
        File file = null;
        try {
            switch (n) {
                case 1: {
                    file = new File(this.e.getResource("").getFile().replaceAll("%20", " ") + File.separator + string);
                    break;
                }
                case 2: {
                    file = new File(string);
                    break;
                }
                case 3: {
                    file = new File(this.f.getResource("").getFile().replaceAll("%20", " ") + File.separator + string);
                    break;
                }
                case 4: {
                    file = new File(ClassLoader.getSystemResource("").getFile().replaceAll("%20", " ") + File.separator + string);
                }
            }
        }
        catch (Exception exception) {}
        if (file == null) {
            throw new RuntimeException(this.getException(string, n, "setFile"));
        }
        return file;
    }

    public File setFile(String string) {
        File file = null;
        try {
            file = this.setFile(string, this.g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null) {
            int n = 0;
            while (file == null && !this.getModeString(++n).equals("[UNKNOWN-MODE]")) {
                try {
                    file = this.setFile(string, n);
                }
                catch (Exception exception) {}
            }
            if (file == null) {
                throw new RuntimeException(this.getException(string, this.g, "setFile"));
            }
            this.g = n;
        }
        return file;
    }

    public String getRootPath(int n) {
        switch (n) {
            case 1: {
                return this.e.getResource("").toString();
            }
            case 2: {
                return System.getProperty("user.dir") + File.separator;
            }
            case 3: {
                return this.f.getResource("").toString();
            }
            case 4: {
                return ClassLoader.getSystemResource("").toString();
            }
        }
        return "[UNKNOWN-MODE]";
    }

    public String getModeString(int n) {
        switch (n) {
            case 1: {
                return "Class-URL";
            }
            case 2: {
                return "Working-Directory";
            }
            case 3: {
                return "Class-Loader";
            }
            case 4: {
                return "System-Loader";
            }
        }
        return "[UNKNOWN-MODE]";
    }

    public int getMode() {
        return this.g;
    }

    public void setMode(int n) {
        this.g = n;
    }

    protected String getException(String string, int n, String string2) {
        return "Resource not found: " + this.getRootPath(n) + string;
    }

    public void setBase(Class clazz) {
        this.e = clazz;
        this.f = clazz.getClassLoader();
    }

    public Class getBase() {
        return this.e;
    }

    public ClassLoader getLoader() {
        return this.f;
    }

    public String toString() {
        BaseIO baseIO = this;
        return super.toString() + " " + "[mode=" + baseIO.getModeString(baseIO.g) + ", baseClass=" + this.e + ", classLoader=" + this.f + "]";
    }
}

