/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev;

import com.golden.gamedev.GameEngine;
import com.golden.gamedev.engine.BaseAudio;
import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.engine.BaseIO;
import com.golden.gamedev.engine.BaseInput;
import com.golden.gamedev.engine.BaseLoader;
import com.golden.gamedev.engine.BaseTimer;
import com.golden.gamedev.object.Background;
import com.golden.gamedev.object.GameFont;
import com.golden.gamedev.object.GameFontManager;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.util.ImageUtil;
import com.golden.gamedev.util.Utility;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;

public abstract class GameObject {
    public final GameEngine parent;
    public BaseGraphics bsGraphics;
    public BaseIO bsIO;
    public BaseLoader bsLoader;
    public BaseInput bsInput;
    public BaseTimer bsTimer;
    public BaseAudio bsMusic;
    public BaseAudio bsSound;
    public GameFontManager fontManager;
    private boolean j;
    private boolean k;

    public GameObject(GameEngine gameEngine) {
        this.parent = gameEngine;
        this.b();
    }

    private void b() {
        this.bsGraphics = this.parent.bsGraphics;
        this.bsIO = this.parent.bsIO;
        this.bsLoader = this.parent.bsLoader;
        this.bsInput = this.parent.bsInput;
        this.bsTimer = this.parent.bsTimer;
        this.bsMusic = this.parent.bsMusic;
        this.bsSound = this.parent.bsSound;
        this.fontManager = this.parent.fontManager;
    }

    public final void start() {
        this.b();
        GameFont gameFont = this.parent.fpsFont;
        if (!this.k) {
            this.initResources();
            this.k = true;
        }
        this.j = false;
        System.gc();
        System.runFinalization();
        this.bsInput.refresh();
        this.bsTimer.refresh();
        long l = 0L;
        block0: while (true) {
            this.update(l);
            this.parent.update(l);
            this.bsInput.update(l);
            while (!this.j && this.parent.isRunning()) {
                Graphics2D graphics2D = this.bsGraphics.getBackBuffer();
                this.render(graphics2D);
                this.parent.render(graphics2D);
                if (!this.parent.isDistribute()) {
                    if (graphics2D.getClip() != null) {
                        graphics2D.setClip(null);
                    }
                    if (graphics2D.getComposite() != null && graphics2D.getComposite() != AlphaComposite.SrcOver) {
                        graphics2D.setComposite(AlphaComposite.SrcOver);
                    }
                    gameFont.drawString(graphics2D, "FPS = " + this.getCurrentFPS() + "/" + this.getFPS(), 9, this.getHeight() - 21);
                    gameFont.drawString(graphics2D, "GTGE", this.getWidth() - 65, 9);
                }
                if (!this.bsGraphics.flip()) continue;
                l = this.bsTimer.sleep();
                if (l <= 100L) continue block0;
                l = 100L;
                continue block0;
            }
            break;
        }
    }

    public void finish() {
        this.j = true;
    }

    public abstract void initResources();

    public abstract void update(long var1);

    public abstract void render(Graphics2D var1);

    public int getRandom(int n, int n2) {
        return Utility.getRandom(n, n2);
    }

    public int getWidth() {
        return this.bsGraphics.getSize().width;
    }

    public int getHeight() {
        return this.bsGraphics.getSize().height;
    }

    public BufferedImage takeScreenShot() {
        BufferedImage bufferedImage = ImageUtil.createImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.render(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void takeScreenShot(File file) {
        ImageUtil.saveImage(this.takeScreenShot(), file);
    }

    public int playMusic(String string) {
        return this.bsMusic.play(string);
    }

    public int playSound(String string) {
        return this.bsSound.play(string);
    }

    public void setFPS(int n) {
        this.bsTimer.setFPS(n);
    }

    public int getCurrentFPS() {
        return this.bsTimer.getCurrentFPS();
    }

    public int getFPS() {
        return this.bsTimer.getFPS();
    }

    public void drawFPS(Graphics2D graphics2D, int n, int n2) {
        this.fontManager.getFont("FPS Font").drawString(graphics2D, "FPS = " + this.getCurrentFPS() + "/" + this.getFPS(), n, n2);
    }

    public int getMouseX() {
        return this.bsInput.getMouseX();
    }

    public int getMouseY() {
        return this.bsInput.getMouseY();
    }

    public boolean checkPosMouse(int n, int n2, int n3, int n4) {
        return this.getMouseX() >= n && this.getMouseY() >= n2 && this.getMouseX() <= n3 && this.getMouseY() <= n4;
    }

    public boolean checkPosMouse(Sprite sprite, boolean bl) {
        Background background = sprite.getBackground();
        if (this.getMouseX() < background.getClip().x || this.getMouseY() < background.getClip().y || this.getMouseX() > background.getClip().x + background.getClip().width || this.getMouseY() > background.getClip().y + background.getClip().height) {
            return false;
        }
        double d = (double)this.getMouseX() + background.getX() - (double)background.getClip().x;
        double d2 = (double)this.getMouseY() + background.getY() - (double)background.getClip().y;
        if (bl) {
            try {
                return (sprite.getImage().getRGB((int)(d - sprite.getX()), (int)(d2 - sprite.getY())) & 0xFF000000) != 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return d >= sprite.getX() && d2 >= sprite.getY() && d <= sprite.getX() + (double)sprite.getWidth() && d2 <= sprite.getY() + (double)sprite.getHeight();
    }

    public boolean click() {
        return this.bsInput.isMousePressed(1);
    }

    public boolean rightClick() {
        return this.bsInput.isMousePressed(3);
    }

    public boolean keyDown(int n) {
        return this.bsInput.isKeyDown(n);
    }

    public boolean keyPressed(int n) {
        return this.bsInput.isKeyPressed(n);
    }

    public void hideCursor() {
        this.bsInput.setMouseVisible(false);
    }

    public void showCursor() {
        this.bsInput.setMouseVisible(true);
    }

    public void setMaskColor(Color color) {
        this.bsLoader.setMaskColor(color);
    }

    public BufferedImage getImage(String string, boolean bl) {
        return this.bsLoader.getImage(string, bl);
    }

    public BufferedImage getImage(String string) {
        return this.bsLoader.getImage(string);
    }

    public BufferedImage[] getImages(String string, int n, int n2, boolean bl) {
        return this.bsLoader.getImages(string, n, n2, bl);
    }

    public BufferedImage[] getImages(String string, int n, int n2) {
        return this.bsLoader.getImages(string, n, n2);
    }

    public BufferedImage[] getImages(String string, int n, int n2, boolean bl, String string2, int n3) {
        String string3 = string + string2 + n3;
        BufferedImage[] bufferedImageArray = this.bsLoader.getStoredImages(string3);
        if (bufferedImageArray == null) {
            BufferedImage[] bufferedImageArray2 = this.getImages(string, n, n2, bl);
            int n4 = string2.length() / n3;
            bufferedImageArray = new BufferedImage[n4];
            int n5 = 0;
            while (n5 < n4) {
                bufferedImageArray[n5] = bufferedImageArray2[Integer.parseInt(string2.substring(n5 * n3, (n5 + 1) * n3))];
                ++n5;
            }
            this.bsLoader.storeImages(string3, bufferedImageArray);
        }
        return bufferedImageArray;
    }

    public BufferedImage[] getImages(String string, int n, int n2, String string2, int n3) {
        return this.getImages(string, n, n2, true, string2, n3);
    }

    public BufferedImage[] getImages(String string, int n, int n2, boolean bl, int n3, int n4) {
        String string2 = n3 + string + n4;
        BufferedImage[] bufferedImageArray = this.bsLoader.getStoredImages(string2);
        if (bufferedImageArray == null) {
            BufferedImage[] bufferedImageArray2 = this.getImages(string, n, n2, bl);
            int n5 = n4 - n3 + 1;
            bufferedImageArray = new BufferedImage[n5];
            int n6 = 0;
            while (n6 < n5) {
                bufferedImageArray[n6] = bufferedImageArray2[n3 + n6];
                ++n6;
            }
            this.bsLoader.storeImages(string2, bufferedImageArray);
        }
        return bufferedImageArray;
    }

    public BufferedImage[] getImages(String string, int n, int n2, int n3, int n4) {
        return this.getImages(string, n, n2, true, n3, n4);
    }
}

