/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev;

import com.golden.gamedev.Game$1;
import com.golden.gamedev.Game$2;
import com.golden.gamedev.GameEngine;
import com.golden.gamedev.engine.BaseAudio;
import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.engine.BaseIO;
import com.golden.gamedev.engine.BaseInput;
import com.golden.gamedev.engine.BaseLoader;
import com.golden.gamedev.engine.BaseTimer;
import com.golden.gamedev.engine.audio.MidiRenderer;
import com.golden.gamedev.engine.audio.WaveRenderer;
import com.golden.gamedev.engine.input.AWTInput;
import com.golden.gamedev.engine.timer.SystemTimer;
import com.golden.gamedev.funbox.ErrorNotificationDialog;
import com.golden.gamedev.object.Background;
import com.golden.gamedev.object.GameFont;
import com.golden.gamedev.object.GameFontManager;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.util.ImageUtil;
import com.golden.gamedev.util.Utility;
import java.applet.Applet;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.Serializable;
import java.net.URL;

public abstract class Game {
    public static final String GTGE_VERSION = "0.2.3";
    public BaseGraphics bsGraphics;
    public BaseIO bsIO;
    public BaseLoader bsLoader;
    public BaseInput bsInput;
    public BaseTimer bsTimer;
    public BaseAudio bsMusic;
    public BaseAudio bsSound;
    public GameFontManager fontManager;
    private boolean k;
    private boolean l;
    protected boolean distribute;
    GameFont fpsFont;
    private boolean o;
    private boolean p;
    static Class a;

    public void stop() {
        this.k = false;
    }

    public void finish() {
        this.l = true;
        this.stop();
    }

    public boolean isFinish() {
        return this.l;
    }

    public boolean isRunning() {
        return this.k;
    }

    public final void start() {
        if (!this.k && !this.l) {
            this.k = true;
            URL[] uRLArray = new URL[]{(a == null ? (a = Game.a("com.golden.gamedev.Game")) : a).getResource("Game.dat"), (a == null ? (a = Game.a("com.golden.gamedev.Game")) : a).getResource("Game.fnt"), (a == null ? (a = Game.a("com.golden.gamedev.Game")) : a).getResource("GameEngine.class"), (a == null ? (a = Game.a("com.golden.gamedev.Game")) : a).getResource("GameObject.class")};
            int[] nArray = new int[]{24501, 2107, 2000, 6727};
            try {
                int n = 0;
                while (n < uRLArray.length) {
                    BufferedInputStream bufferedInputStream;
                    if (uRLArray[n] == null) {
                        this.q();
                    }
                    if ((bufferedInputStream = new BufferedInputStream(uRLArray[n].openStream())).available() != nArray[n]) {
                        this.q();
                    }
                    bufferedInputStream.close();
                    ++n;
                }
            }
            catch (Throwable throwable) {
                this.q();
            }
            if (!this.p) {
                boolean bl = this.o = !this.distribute;
            }
            if (!this.o) {
                try {
                    if (!this.p) {
                        this.p = true;
                        this.h();
                    }
                    this.startGameLoop();
                    return;
                }
                catch (Throwable throwable) {
                    this.notifyError(throwable);
                    return;
                }
            }
            if (!this.p) {
                this.p = true;
                this.h();
            }
            this.startGameLoop();
        }
    }

    private void h() {
        this.initEngine();
        if (!this.o) {
            this.showLogo();
        }
        try {
            BufferedImage bufferedImage = ImageUtil.getImage((a == null ? (a = Game.a("com.golden.gamedev.Game")) : a).getResource("Game.fnt"));
            this.fpsFont = this.fontManager.getFont(bufferedImage);
            this.fontManager.removeFont(bufferedImage);
            this.fontManager.putFont("FPS Font", this.fpsFont);
            if (!this.o) {
                this.fpsFont = null;
            }
        }
        catch (Exception exception) {
            this.q();
        }
        System.gc();
        System.runFinalization();
        this.initResources();
    }

    void startGameLoop() {
        System.gc();
        System.runFinalization();
        this.bsTimer.startTimer();
        this.bsTimer.refresh();
        long l = 0L;
        block0: while (true) {
            this.update(l);
            this.bsInput.update(l);
            while (this.k) {
                Graphics2D graphics2D = this.bsGraphics.getBackBuffer();
                this.render(graphics2D);
                if (this.o) {
                    if (graphics2D.getClip() != null) {
                        graphics2D.setClip(null);
                    }
                    if (graphics2D.getComposite() != null && graphics2D.getComposite() != AlphaComposite.SrcOver) {
                        graphics2D.setComposite(AlphaComposite.SrcOver);
                    }
                    this.fpsFont.drawString(graphics2D, "FPS = " + this.getCurrentFPS() + "/" + this.getFPS(), 9, this.getHeight() - 21);
                    this.fpsFont.drawString(graphics2D, "GTGE", this.getWidth() - 65, 9);
                }
                if (!this.bsGraphics.flip()) continue;
                l = this.bsTimer.sleep();
                if (l <= 100L) continue block0;
                l = 100L;
                continue block0;
            }
            break;
        }
        this.bsTimer.stopTimer();
        this.bsSound.stopAll();
        this.bsMusic.stopAll();
        if (this.l) {
            this.bsGraphics.cleanup();
            this.notifyExit();
        }
    }

    protected void initEngine() {
        if (this.bsTimer == null) {
            this.bsTimer = new SystemTimer();
        }
        if (this.bsIO == null) {
            this.bsIO = new BaseIO(this.getClass());
        }
        if (this.bsLoader == null) {
            this.bsLoader = new BaseLoader(this.bsIO, Color.MAGENTA);
        }
        if (this.bsInput == null) {
            this.bsInput = new AWTInput(this.bsGraphics.getComponent());
        }
        if (this.bsMusic == null) {
            this.bsMusic = new BaseAudio(this.bsIO, new MidiRenderer());
            this.bsMusic.setExclusive(true);
            this.bsMusic.setLoop(true);
        }
        if (this.bsSound == null) {
            this.bsSound = new BaseAudio(this.bsIO, new WaveRenderer());
        }
        this.bsTimer.setFPS(100);
        Background.screen = this.bsGraphics.getSize();
        if (this.fontManager == null) {
            this.fontManager = new GameFontManager();
        }
    }

    public abstract void initResources();

    public abstract void update(long var1);

    public abstract void render(Graphics2D var1);

    protected void notifyExit() {
        Serializable serializable;
        if (!(this.bsGraphics instanceof Applet)) {
            try {
                System.exit(0);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        Applet applet = (Applet)((Object)this.bsGraphics);
        BufferedImage bufferedImage = ImageUtil.createImage(this.getWidth(), this.getHeight());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.8f));
            serializable = new Ellipse2D.Float(this.getWidth() / 10, this.getHeight() / 10, this.getWidth() - (this.getWidth() / 10 << 1), this.getHeight() - (this.getHeight() / 10 << 1));
            graphics2D.setClip((Shape)((Object)serializable));
            if (this instanceof GameEngine) {
                ((GameEngine)this).getCurrentGame().render(graphics2D);
            }
            this.render(graphics2D);
            graphics2D.dispose();
        }
        catch (Exception exception) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        serializable = ColorSpace.getInstance(1003);
        BufferedImage bufferedImage2 = new ColorConvertOp((ColorSpace)serializable, null).filter(bufferedImage, null);
        applet.removeAll();
        applet.setIgnoreRepaint(false);
        Game$1 game$1 = new Game$1(this, bufferedImage2);
        game$1.setSize(applet.getSize());
        game$1.addMouseListener(new Game$2(this, applet));
        applet.add(game$1);
        applet.repaint();
        game$1.repaint();
    }

    protected void notifyError(Throwable throwable) {
        new ErrorNotificationDialog(throwable, this.bsGraphics, this.getClass().getName(), null);
    }

    public final boolean isDistribute() {
        return !this.o;
    }

    public final void showLogo() {
        block17: {
            Object object;
            this.hideCursor();
            SystemTimer systemTimer = new SystemTimer();
            systemTimer.setFPS(20);
            this.bsInput.refresh();
            BufferedImage bufferedImage = null;
            try {
                BufferedImage bufferedImage2 = ImageUtil.getImage((a == null ? (a = Game.a("com.golden.gamedev.Game")) : a).getResource("Game.dat"));
                bufferedImage = ImageUtil.resize(bufferedImage2, this.getWidth(), this.getHeight());
                bufferedImage2.flush();
            }
            catch (Exception exception) {
                this.q();
            }
            try {
                this.p(Color.BLACK);
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            float f = 0.0f;
            systemTimer.startTimer();
            boolean bl = true;
            block8: while (f < 1.0f) {
                while (this.k) {
                    double d;
                    Graphics2D graphics2D = this.bsGraphics.getBackBuffer();
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                    object = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                    graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                    graphics2D.setComposite((Composite)object);
                    if (!this.bsGraphics.flip()) continue;
                    if (bl) {
                        bl = false;
                        systemTimer.refresh();
                    }
                    long l = systemTimer.sleep();
                    double d2 = 6.5E-4 * (double)l;
                    if (d > 0.22) {
                        d2 = 0.22 + d2 / 6.0;
                    }
                    f = (float)((double)f + d2);
                    if (!this.o(l)) continue block8;
                    this.p(Color.BLACK);
                    bufferedImage.flush();
                    bufferedImage = null;
                    return;
                }
                break block17;
            }
            block10: while (this.k) {
                Graphics2D graphics2D = this.bsGraphics.getBackBuffer();
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                if (!this.bsGraphics.flip()) continue;
                int n = 0;
                while (n++ < 50) {
                    if (!this.k) break block10;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (!this.o(50L)) continue;
                    this.p(Color.BLACK);
                    bufferedImage.flush();
                    bufferedImage = null;
                    return;
                }
                f = 1.0f;
                systemTimer.refresh();
                block12: while (f > 0.0f) {
                    while (this.k) {
                        double d;
                        object = this.bsGraphics.getBackBuffer();
                        ((Graphics)object).setColor(Color.BLACK);
                        ((Graphics)object).fillRect(0, 0, this.getWidth(), this.getHeight());
                        Composite composite = ((Graphics2D)object).getComposite();
                        ((Graphics2D)object).setComposite(AlphaComposite.getInstance(3, f));
                        ((Graphics)object).drawImage(bufferedImage, 0, 0, null);
                        ((Graphics2D)object).setComposite(composite);
                        if (!this.bsGraphics.flip()) continue;
                        long l = systemTimer.sleep();
                        double d3 = 5.5E-4 * (double)l;
                        if (d > 0.15) {
                            d3 = 0.15 + (d3 - 0.04) / 2.0;
                        }
                        f = (float)((double)f - d3);
                        if (!this.o(l)) continue block12;
                        this.p(Color.BLACK);
                        bufferedImage.flush();
                        bufferedImage = null;
                        return;
                    }
                    break block10;
                }
                bufferedImage.flush();
                bufferedImage = null;
                systemTimer.stopTimer();
                systemTimer = null;
                try {
                    this.p(Color.BLACK);
                    Thread.sleep(100L);
                    return;
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
        }
    }

    private boolean o(long l) {
        boolean bl = this.bsInput.getKeyPressed() != Integer.MIN_VALUE || this.bsInput.getMousePressed() != Integer.MIN_VALUE;
        this.bsInput.update(l);
        return bl;
    }

    private void p(Color color) {
        Graphics2D graphics2D = this.bsGraphics.getBackBuffer();
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.bsGraphics.flip();
        graphics2D = this.bsGraphics.getBackBuffer();
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.bsGraphics.flip();
    }

    private void q() {
        try {
            BufferedImage bufferedImage = ImageUtil.getImage((a == null ? (a = Game.a("com.golden.gamedev.Game")) : a).getResource("Game.fnt"));
            this.fontManager = new GameFontManager();
            GameFont gameFont = this.fontManager.getFont(bufferedImage);
            Graphics2D graphics2D = this.bsGraphics.getBackBuffer();
            graphics2D.setColor(Color.RED.darker());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            gameFont.drawString(graphics2D, "THIS GAME IS USING", 10, 10);
            gameFont.drawString(graphics2D, "GTGE CRACKED VERSION!!", 10, 30);
            gameFont.drawString(graphics2D, "PLEASE REPORT THIS GAME TO", 10, 50);
            gameFont.drawString(graphics2D, "WWW.GOLDENSTUDIOS.OR.ID", 10, 70);
            gameFont.drawString(graphics2D, "THANK YOU....", 10, 105);
            this.bsGraphics.flip();
            this.bsInput = new AWTInput(this.bsGraphics.getComponent());
            try {
                int n = 0;
                do {
                    Thread.sleep(50L);
                } while (++n < 160 && !this.o(50L));
            }
            catch (InterruptedException interruptedException) {}
            this.finish();
        }
        catch (Throwable throwable) {}
        System.out.println("THIS GAME IS USING GTGE CRACKED VERSION!!");
        System.out.println("PLEASE REPORT THIS GAME TO HTTP://WWW.GOLDENSTUDIOS.OR.ID/");
        System.out.println("THANK YOU....");
        System.exit(-1);
    }

    public int getRandom(int n, int n2) {
        return Utility.getRandom(n, n2);
    }

    public int getWidth() {
        return this.bsGraphics.getSize().width;
    }

    public int getHeight() {
        return this.bsGraphics.getSize().height;
    }

    public BufferedImage takeScreenShot() {
        BufferedImage bufferedImage = ImageUtil.createImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.render(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void takeScreenShot(File file) {
        ImageUtil.saveImage(this.takeScreenShot(), file);
    }

    public int playMusic(String string) {
        return this.bsMusic.play(string);
    }

    public int playSound(String string) {
        return this.bsSound.play(string);
    }

    public void setFPS(int n) {
        this.bsTimer.setFPS(n);
    }

    public int getCurrentFPS() {
        return this.bsTimer.getCurrentFPS();
    }

    public int getFPS() {
        return this.bsTimer.getFPS();
    }

    public void drawFPS(Graphics2D graphics2D, int n, int n2) {
        this.fontManager.getFont("FPS Font").drawString(graphics2D, "FPS = " + this.getCurrentFPS() + "/" + this.getFPS(), n, n2);
    }

    public int getMouseX() {
        return this.bsInput.getMouseX();
    }

    public int getMouseY() {
        return this.bsInput.getMouseY();
    }

    public boolean checkPosMouse(int n, int n2, int n3, int n4) {
        return this.getMouseX() >= n && this.getMouseY() >= n2 && this.getMouseX() <= n3 && this.getMouseY() <= n4;
    }

    public boolean checkPosMouse(Sprite sprite, boolean bl) {
        Background background = sprite.getBackground();
        if (this.getMouseX() < background.getClip().x || this.getMouseY() < background.getClip().y || this.getMouseX() > background.getClip().x + background.getClip().width || this.getMouseY() > background.getClip().y + background.getClip().height) {
            return false;
        }
        double d = (double)this.getMouseX() + background.getX() - (double)background.getClip().x;
        double d2 = (double)this.getMouseY() + background.getY() - (double)background.getClip().y;
        if (bl) {
            try {
                return (sprite.getImage().getRGB((int)(d - sprite.getX()), (int)(d2 - sprite.getY())) & 0xFF000000) != 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return d >= sprite.getX() && d2 >= sprite.getY() && d <= sprite.getX() + (double)sprite.getWidth() && d2 <= sprite.getY() + (double)sprite.getHeight();
    }

    public boolean click() {
        return this.bsInput.isMousePressed(1);
    }

    public boolean rightClick() {
        return this.bsInput.isMousePressed(3);
    }

    public boolean keyDown(int n) {
        return this.bsInput.isKeyDown(n);
    }

    public boolean keyPressed(int n) {
        return this.bsInput.isKeyPressed(n);
    }

    public void hideCursor() {
        this.bsInput.setMouseVisible(false);
    }

    public void showCursor() {
        this.bsInput.setMouseVisible(true);
    }

    public void setMaskColor(Color color) {
        this.bsLoader.setMaskColor(color);
    }

    public BufferedImage getImage(String string, boolean bl) {
        return this.bsLoader.getImage(string, bl);
    }

    public BufferedImage getImage(String string) {
        return this.bsLoader.getImage(string);
    }

    public BufferedImage[] getImages(String string, int n, int n2, boolean bl) {
        return this.bsLoader.getImages(string, n, n2, bl);
    }

    public BufferedImage[] getImages(String string, int n, int n2) {
        return this.bsLoader.getImages(string, n, n2);
    }

    public BufferedImage[] getImages(String string, int n, int n2, boolean bl, String string2, int n3) {
        String string3 = string + string2 + n3;
        BufferedImage[] bufferedImageArray = this.bsLoader.getStoredImages(string3);
        if (bufferedImageArray == null) {
            BufferedImage[] bufferedImageArray2 = this.getImages(string, n, n2, bl);
            int n4 = string2.length() / n3;
            bufferedImageArray = new BufferedImage[n4];
            int n5 = 0;
            while (n5 < n4) {
                bufferedImageArray[n5] = bufferedImageArray2[Integer.parseInt(string2.substring(n5 * n3, (n5 + 1) * n3))];
                ++n5;
            }
            this.bsLoader.storeImages(string3, bufferedImageArray);
        }
        return bufferedImageArray;
    }

    public BufferedImage[] getImages(String string, int n, int n2, String string2, int n3) {
        return this.getImages(string, n, n2, true, string2, n3);
    }

    public BufferedImage[] getImages(String string, int n, int n2, boolean bl, int n3, int n4) {
        String string2 = n3 + string + n4;
        BufferedImage[] bufferedImageArray = this.bsLoader.getStoredImages(string2);
        if (bufferedImageArray == null) {
            BufferedImage[] bufferedImageArray2 = this.getImages(string, n, n2, bl);
            int n5 = n4 - n3 + 1;
            bufferedImageArray = new BufferedImage[n5];
            int n6 = 0;
            while (n6 < n5) {
                bufferedImageArray[n6] = bufferedImageArray2[n3 + n6];
                ++n6;
            }
            this.bsLoader.storeImages(string2, bufferedImageArray);
        }
        return bufferedImageArray;
    }

    public BufferedImage[] getImages(String string, int n, int n2, int n3, int n4) {
        return this.getImages(string, n, n2, true, n3, n4);
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

