/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.image.ImageSaver;
import artofillusion.math.Vec2;
import artofillusion.object.FacetedMesh;
import artofillusion.object.Mesh;
import artofillusion.object.ObjectInfo;
import artofillusion.procedural.OutputModule;
import artofillusion.texture.ImageMapTexture;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.ProceduralTexture2D;
import artofillusion.texture.Texture;
import artofillusion.texture.Texture2D;
import artofillusion.texture.UVMapping;
import artofillusion.translators.TextureImageInfo;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class TextureImageExporter {
    private Hashtable textureTable = new Hashtable();
    private File dir;
    private String baseFilename;
    private int quality;
    private int components;
    private int width;
    private int height;
    private int nextID;
    public static final int DIFFUSE = 1;
    public static final int SPECULAR = 2;
    public static final int HILIGHT = 4;
    public static final int TRANSPARENT = 8;
    public static final int EMISSIVE = 16;
    public static final int BUMP = 32;

    public TextureImageExporter(File dir, String baseFilename, int quality, int components, int width, int height) {
        this.dir = dir;
        this.baseFilename = baseFilename;
        this.quality = quality;
        this.components = components;
        this.width = width;
        this.height = height;
        this.nextID = 1;
    }

    public void addObject(ObjectInfo obj) {
        block17: {
            TextureImageInfo info;
            Texture tex;
            block16: {
                tex = obj.getObject().getTexture();
                if (tex == null) {
                    return;
                }
                info = (TextureImageInfo)this.textureTable.get(tex);
                if (info == null) {
                    info = new TextureImageInfo(tex, obj.getObject().getAverageParameterValues());
                    this.textureTable.put(tex, info);
                    if (tex instanceof ImageMapTexture) {
                        ImageMapTexture imt = (ImageMapTexture)tex;
                        info.diffuseFilename = imt.diffuseColor.getImage() != null ? this.newName() : null;
                        info.specularFilename = imt.specularColor.getImage() != null || imt.specularity.getImage() != null ? this.newName() : null;
                        info.hilightFilename = imt.specularColor.getImage() != null || imt.shininess.getImage() != null ? this.newName() : null;
                        info.transparentFilename = imt.transparentColor.getImage() != null || imt.transparency.getImage() != null ? this.newName() : null;
                        info.emissiveFilename = imt.emissiveColor.getImage() != null ? this.newName() : null;
                    } else if (tex instanceof ProceduralTexture2D) {
                        OutputModule[] output = ((ProceduralTexture2D)tex).getProcedure().getOutputModules();
                        info.diffuseFilename = output[0].inputConnected(0) ? this.newName() : null;
                        info.specularFilename = output[1].inputConnected(0) || output[5].inputConnected(0) ? this.newName() : null;
                        info.hilightFilename = output[1].inputConnected(0) || output[6].inputConnected(0) ? this.newName() : null;
                        info.transparentFilename = output[2].inputConnected(0) || output[4].inputConnected(0) ? this.newName() : null;
                        String string = info.emissiveFilename = output[3].inputConnected(0) ? this.newName() : null;
                    }
                }
                if (!(tex instanceof ImageMapTexture)) break block16;
                info.minv = 0.0;
                info.minu = 0.0;
                info.maxv = 1.0;
                info.maxu = 1.0;
                break block17;
            }
            if (!(tex instanceof ProceduralTexture2D)) break block17;
            Mesh mesh = obj.getObject() instanceof Mesh ? (Mesh)obj.getObject() : obj.getObject().convertToTriangleMesh(0.1);
            Mapping2D map = (Mapping2D)obj.getObject().getTextureMapping();
            if (map instanceof UVMapping && mesh instanceof FacetedMesh && ((UVMapping)map).isPerFaceVertex((FacetedMesh)mesh)) {
                Vec2[][] coords = ((UVMapping)map).findFaceTextureCoordinates((FacetedMesh)mesh);
                for (int i = 0; i < coords.length; ++i) {
                    for (int j = 0; j < coords[i].length; ++j) {
                        if (coords[i][j].x < info.minu) {
                            info.minu = coords[i][j].x;
                        }
                        if (coords[i][j].x > info.maxu) {
                            info.maxu = coords[i][j].x;
                        }
                        if (coords[i][j].y < info.minv) {
                            info.minv = coords[i][j].y;
                        }
                        if (!(coords[i][j].y > info.maxv)) continue;
                        info.maxv = coords[i][j].y;
                    }
                }
            } else {
                Vec2[] coords = map.findTextureCoordinates(mesh);
                for (int i = 0; i < coords.length; ++i) {
                    if (coords[i].x < info.minu) {
                        info.minu = coords[i].x;
                    }
                    if (coords[i].x > info.maxu) {
                        info.maxu = coords[i].x;
                    }
                    if (coords[i].y < info.minv) {
                        info.minv = coords[i].y;
                    }
                    if (!(coords[i].y > info.maxv)) continue;
                    info.maxv = coords[i].y;
                }
            }
        }
    }

    private String newName() {
        return this.baseFilename + this.nextID++ + ".jpg";
    }

    public TextureImageInfo getTextureInfo(Texture tex) {
        return tex != null ? (TextureImageInfo)this.textureTable.get(tex) : null;
    }

    public Enumeration getTextures() {
        return this.textureTable.elements();
    }

    public void saveImages() throws IOException, InterruptedException {
        Enumeration e = this.textureTable.keys();
        while (e.hasMoreElements()) {
            Texture tex = (Texture)e.nextElement();
            TextureImageInfo info = (TextureImageInfo)this.textureTable.get(tex);
            if ((this.components & 1) != 0) {
                this.writeComponentImage(info, 0, info.diffuseFilename);
            }
            if ((this.components & 2) != 0) {
                this.writeComponentImage(info, 1, info.specularFilename);
            }
            if ((this.components & 4) != 0) {
                this.writeComponentImage(info, 3, info.hilightFilename);
            }
            if ((this.components & 8) != 0) {
                this.writeComponentImage(info, 2, info.transparentFilename);
            }
            if ((this.components & 0x10) == 0) continue;
            this.writeComponentImage(info, 4, info.emissiveFilename);
        }
    }

    private void writeComponentImage(TextureImageInfo info, int component, String filename) throws IOException, InterruptedException {
        if (filename == null || !(info.texture instanceof Texture2D)) {
            return;
        }
        Image img = ((Texture2D)info.texture).createComponentImage(info.minu, info.maxu, info.minv, info.maxv, this.width, this.height, component, 0.0, info.paramValue);
        ImageSaver.saveImage((Image)img, (File)new File(this.dir, filename), (int)0, (int)this.quality);
    }
}

