/*
 * Decompiled with CFR 0.152.
 */
package nik777.chat;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nik777.xlate.StringEditor;

public class ChatTextPane
extends JTextPane
implements ChangeListener,
MouseWheelListener {
    private static final int NAME = 0;
    private static final int NAMECOLOR = 1;
    private static final int MSG = 2;
    private static final int MSGCOLOR = 3;
    protected static final String urlEdit = "gs/</&lt;/gs/>/&gt;/gs;(^| )(http://.*?)( |$);$1<a href=\"$2\">$2</a>$3;";
    private int miRows;
    private int miColumns;
    private int miNbrLinesPerPage;
    private int miWidth;
    private int miHeight;
    private int miNameColWidth;
    private int miTopLine = 0;
    private int miFontHeight;
    private boolean mbReformatLines = true;
    private boolean mbHangingIndent = true;
    private Image mImage;
    private Graphics mGraphics;
    private Font mFont;
    private FontMetrics mFontMetrics;
    private Scrollbar mScrollbar;
    private Vector mvLines;
    private Vector mvFormatedLines;
    protected StringBuffer fmtBuffer;
    protected JTextPane textPanel;
    protected JScrollBar scroll = null;
    protected boolean scrollSet = false;
    protected StringEditor editor;
    protected boolean wheelScrolling = false;
    protected boolean isAtBottom = true;
    private int miColSize = 20;
    private boolean mbColSizeIsPercent = true;

    public ChatTextPane() {
        this("", 0, 0, false);
    }

    public ChatTextPane(String text) {
        this(text, 0, 0, false);
    }

    public ChatTextPane(int rows, int cols, boolean hangingIndent) {
        this("", rows, cols, hangingIndent);
    }

    public ChatTextPane(String Text, int rows, int cols, boolean hangingIndent) {
        this.miRows = rows;
        this.miColumns = cols;
        this.mbHangingIndent = hangingIndent;
        this.editor = new StringEditor(urlEdit);
        this.setEditable(false);
        this.setContentType("text/html");
        this.mFont = new Font("Dialog", 0, 12);
        this.mScrollbar = new Scrollbar(1, 0, 1, 0, 0);
        this.mvLines = new Vector();
        this.mvFormatedLines = new Vector();
        this.fmtBuffer = new StringBuffer(4096);
        if (Text.length() > 0) {
            this.append(Text);
        }
    }

    public void append(String str) {
        this.appendChatText(str, "000000", "", "");
    }

    public void append(String str, String RGB) {
        this.appendChatText(str, RGB, "", "");
    }

    public void appendChatText(String name, String msg, String RGB) {
        this.appendChatText(name, RGB, msg, RGB);
    }

    public void appendChatText(String name, String nameRGB, String msg, String msgRGB) {
        String[] line = new String[]{name, nameRGB, msg, msgRGB};
        this.mvLines.addElement(line);
        Rectangle rect = this.getBounds();
        if (rect.width > 0) {
            this.render();
        }
    }

    public String getText() {
        StringBuffer sBuffer = new StringBuffer(1024);
        for (int i = 0; i < this.mvLines.size(); ++i) {
            String[] saNextLine = (String[])this.mvLines.elementAt(i);
            sBuffer.append(saNextLine[0]).append(" ").append(saNextLine[2]).append("\n");
        }
        return sBuffer.toString();
    }

    public void clearText() {
        this.mvLines.removeAllElements();
        this.mvFormatedLines.removeAllElements();
    }

    public void setFont(Font font) {
        this.mFont = font;
        this.repaint();
    }

    public synchronized void setText(String str) {
        this.setText(str, "000000");
    }

    public synchronized void setText(String str, String RGB) {
        this.clearText();
        if (str.length() > 0) {
            this.append(str, RGB);
        }
    }

    public synchronized void setNameColumnWidth(int width, boolean isPercent) {
        this.miColSize = width;
        this.mbColSizeIsPercent = isPercent;
        if (isPercent) {
            if (width < 0 || width > 95) {
                width = 20;
            }
            double dNameColWidthPercent = (double)width * 0.01;
            this.miNameColWidth = (int)((double)this.miWidth * dNameColWidthPercent);
        } else {
            if (width < 0 || width > this.miWidth) {
                width = this.miWidth / 3;
            }
            this.miNameColWidth = width;
        }
    }

    private void wordWrap(int lineIndex) {
        String[] saNewLine = (String[])this.mvLines.elementAt(lineIndex);
        boolean bChatMsg = saNewLine[2].length() > 0;
        try {
            String[] NewLine;
            String sNextWord = new String();
            String sChopped = new String();
            boolean bAddUserName = true;
            boolean bWasChatMsg = false;
            int iBodyWidth = bChatMsg ? (this.mbHangingIndent ? this.miWidth - this.miNameColWidth - 50 : this.miWidth - (50 + this.mFontMetrics.stringWidth(saNewLine[0]))) : this.miWidth - 50;
            StringTokenizer tokenizer = new StringTokenizer(bChatMsg ? saNewLine[2] : saNewLine[0]);
            while (tokenizer.hasMoreTokens()) {
                sNextWord = tokenizer.nextToken().toString();
                if (this.mFontMetrics.stringWidth(sNextWord) > iBodyWidth) {
                    sChopped = sChopped + " " + this.chopWord(sNextWord, iBodyWidth);
                    continue;
                }
                sChopped = sChopped + " " + sNextWord;
            }
            tokenizer = new StringTokenizer(sChopped);
            StringBuffer buffer = new StringBuffer(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                sNextWord = tokenizer.nextToken();
                if (this.mFontMetrics.stringWidth(buffer.toString()) + this.mFontMetrics.stringWidth(sNextWord) > iBodyWidth) {
                    NewLine = new String[4];
                    NewLine[1] = saNewLine[1];
                    NewLine[3] = saNewLine[3];
                    if (!this.mbHangingIndent && bWasChatMsg) {
                        NewLine[1] = saNewLine[3];
                    }
                    if (bChatMsg) {
                        NewLine[0] = bAddUserName ? saNewLine[0] : "";
                        NewLine[2] = buffer.toString();
                        bWasChatMsg = true;
                    } else {
                        NewLine[0] = buffer.toString();
                        NewLine[2] = "";
                    }
                    this.mvFormatedLines.addElement(NewLine);
                    buffer = new StringBuffer(sNextWord);
                    bAddUserName = false;
                    if (this.mbHangingIndent || !bWasChatMsg) continue;
                    iBodyWidth = this.miWidth - 50;
                    bChatMsg = false;
                    continue;
                }
                buffer.append(" " + sNextWord);
            }
            NewLine = new String[4];
            NewLine[1] = saNewLine[1];
            NewLine[3] = saNewLine[3];
            if (!this.mbHangingIndent && bWasChatMsg) {
                NewLine[1] = saNewLine[3];
            }
            if (bChatMsg) {
                NewLine[0] = bAddUserName ? saNewLine[0] : "";
                NewLine[2] = "" + buffer;
            } else {
                NewLine[0] = "" + buffer;
                NewLine[2] = "";
            }
            this.mvFormatedLines.addElement(NewLine);
        }
        catch (Exception e) {
            String[] UnformattedLine = new String[4];
            UnformattedLine[1] = saNewLine[1];
            UnformattedLine[3] = saNewLine[3];
            UnformattedLine[0] = saNewLine[0];
            UnformattedLine[2] = saNewLine[2];
            this.mvFormatedLines.addElement(UnformattedLine);
        }
    }

    private String chopWord(String word, int bodyWidth) {
        String sChoppedWord = "";
        for (int i = 0; i < word.length(); ++i) {
            if (this.mFontMetrics.stringWidth(sChoppedWord + word.substring(i, i + 1)) >= bodyWidth) {
                word = word.substring(i - 1);
                sChoppedWord = sChoppedWord + " " + this.chopWord(word, bodyWidth);
                return sChoppedWord;
            }
            sChoppedWord = sChoppedWord + word.substring(i, i + 1);
        }
        return sChoppedWord;
    }

    private void render() {
        if (this.mbReformatLines) {
            this.mbReformatLines = false;
        }
        if (!this.scrollSet) {
            Container parent;
            this.scrollSet = true;
            for (parent = this.getParent(); parent != null && !(parent instanceof JScrollPane); parent = parent.getParent()) {
            }
            if (parent != null) {
                JScrollPane pane = (JScrollPane)parent;
                pane.getViewport().addChangeListener(this);
                pane.addMouseWheelListener(this);
                this.scroll = ((JScrollPane)parent).getVerticalScrollBar();
            }
        }
        this.fmtBuffer.setLength(0);
        this.fmtBuffer.append("<html><table>");
        for (int i = this.miTopLine; i < this.mvLines.size(); ++i) {
            String[] saCurrentLine = (String[])this.mvLines.elementAt(i);
            this.fmtBuffer.append("\n<tr valign=\"top\">").append("<td");
            if (saCurrentLine[2].length() == 0) {
                this.fmtBuffer.append(" colspan=\"2\"");
            } else if (saCurrentLine[0].length() < 25) {
                this.fmtBuffer.append(" nowrap=\"true\"");
            }
            this.fmtBuffer.append("><font name=\"").append(this.mFont.getFontName()).append("\" color=\"").append(saCurrentLine[1]).append("\">").append(this.editor.edit(saCurrentLine[0])).append("</font></td>");
            this.fmtBuffer.append("<td><font name=\"").append(this.mFont.getFontName()).append("\" color=\"").append(saCurrentLine[3]).append("\" >").append(this.breakLongWords(this.editor.edit(saCurrentLine[2]), 30)).append("</font></td></tr>");
        }
        this.fmtBuffer.append("</table></html>");
        try {
            this.read(new StringReader(this.fmtBuffer.toString()), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String breakLongWords(String str, int len) {
        int max = str.length();
        if (max <= len) {
            return str;
        }
        int to = 0;
        StringBuffer sb = new StringBuffer(max + 100);
        int from = 0;
        while (to < max) {
            char c = str.charAt(from);
            for (to = from + 1; to < max && " <>\"'".indexOf(str.charAt(to)) < 0; ++to) {
            }
            if (to - from > len) {
                System.out.println("word is too big");
                if ("'\"".indexOf(c) >= 0 && str.charAt(to) == c) {
                    sb.append(str.substring(from, to));
                } else {
                    to = from + len;
                    for (int i = 0; i < 5 && i < to - from; ++i) {
                        if (Character.isLetterOrDigit(str.charAt(to - i))) continue;
                        to -= i;
                        break;
                    }
                    sb.append(str.substring(from, to)).append("<wr>");
                }
            } else {
                while (to < max && Character.isWhitespace(str.charAt(to))) {
                    ++to;
                }
                sb.append(str.substring(from, to));
            }
            from = to;
        }
        if (from < max) {
            sb.append(str.substring(from));
        }
        return sb.toString();
    }

    public void isAtBottom(boolean tf) {
        this.isAtBottom = tf;
    }

    public void stateChanged(ChangeEvent ev) {
        if (this.isAtBottom && this.scroll != null && (this.wheelScrolling || !this.scroll.getValueIsAdjusting())) {
            this.scroll.setValue(this.scroll.getMaximum() - this.scroll.getVisibleAmount());
            this.isAtBottom = true;
        } else {
            this.isAtBottom = this.scroll.getValue() >= this.scroll.getMaximum() - this.scroll.getVisibleAmount();
        }
        System.out.println("change: isAtBottom=" + this.isAtBottom);
        this.wheelScrolling = false;
    }

    public void mouseWheelMoved(MouseWheelEvent ev) {
        if (this.scroll == null) {
            return;
        }
        this.wheelScrolling = true;
        int max = this.scroll.getMaximum() - this.scroll.getVisibleAmount();
        int pos = this.scroll.getValue() + ev.getUnitsToScroll();
        this.scroll.setValue(pos);
        this.isAtBottom = pos >= max;
    }

    void computeScrollbar(boolean scrollToBottom) {
        if (this.mFontMetrics == null) {
            return;
        }
        int iSBTop = scrollToBottom ? this.mvFormatedLines.size() - this.miNbrLinesPerPage + 1 : (this.mvFormatedLines.size() > this.miNbrLinesPerPage ? this.mScrollbar.getValue() : 0);
        this.mScrollbar.setValues(iSBTop, 10, 0, this.mvFormatedLines.size());
    }

    private Color getColor(String RGB) {
        try {
            int red = Integer.decode("0x" + RGB.substring(0, 2));
            int green = Integer.decode("0x" + RGB.substring(2, 4));
            int blue = Integer.decode("0x" + RGB.substring(4, 6));
            return new Color(red, green, blue);
        }
        catch (Exception e) {
            return Color.black;
        }
    }
}

