/*
 * Decompiled with CFR 0.152.
 */
package nik777.aoi;

import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Insets;

public class ComponentsWindow
extends BDialog {
    protected Widget[] comp;
    protected boolean ok;
    protected Runnable okCallback;
    protected Runnable cancelCallback;
    protected BButton okButton;
    protected BButton cancelButton;

    public ComponentsWindow(WindowWidget parent, String prompt, Widget[] components, String[] labels) {
        this(parent, prompt, components, labels, null, null);
    }

    public ComponentsWindow(WindowWidget parent, String prompt, Widget[] components, String[] labels, Runnable onOK, Runnable onCancel) {
        super(parent, onOK == null && onCancel == null);
        this.init(prompt, components, labels, parent, onOK, onCancel);
    }

    public ComponentsWindow(String prompt, Widget[] components, String[] labels) {
        this.init(prompt, components, labels, null, null, null);
    }

    public ComponentsWindow(String prompt, Widget[] components, String[] labels, Runnable onOK, Runnable onCancel) {
        this.init(prompt, components, labels, null, onOK, onCancel);
    }

    protected void init(String prompt, Widget[] components, String[] labels, WindowWidget parent, Runnable onOK, Runnable onCancel) {
        if (onOK == null && onCancel == null) {
            this.setModal(true);
        }
        this.comp = components;
        this.okCallback = onOK;
        this.cancelCallback = onCancel;
        BorderContainer content = new BorderContainer();
        this.setContent((Widget)content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(10, 10, 10, 10), null));
        content.add((Widget)new BLabel(prompt), BorderContainer.NORTH);
        FormContainer center = new FormContainer(new double[]{0.0, 1.0}, new double[components.length]);
        content.add((Widget)center, BorderContainer.CENTER);
        for (int i = 0; i < components.length; ++i) {
            if (labels[i] == null) {
                center.add(components[i], 0, i, 2, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 0, 2, 0), null));
            } else {
                center.add((Widget)new BLabel(labels[i]), 0, i, new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(2, 0, 2, 5), null));
                center.add(components[i], 1, i, new LayoutInfo(LayoutInfo.WEST, LayoutInfo.BOTH, new Insets(2, 0, 2, 0), null));
            }
            components[i].addEventLink(class$buoy$event$KeyPressedEvent == null ? ComponentsWindow.class$("buoy.event.KeyPressedEvent") : class$buoy$event$KeyPressedEvent, (Object)this, "keyPressed");
        }
        RowContainer buttons = new RowContainer();
        content.add((Widget)buttons, BorderContainer.SOUTH);
        this.okButton = Translate.button("ok", (Object)this, "buttonPressed");
        buttons.add((Widget)this.okButton);
        this.cancelButton = Translate.button("cancel", (Object)this, "buttonPressed");
        buttons.add((Widget)this.cancelButton);
        this.okButton.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        this.cancelButton.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        this.addEventLink(WindowClosingEvent.class, new Object(){

            void processEvent() {
                ComponentsWindow.this.ok = false;
                ComponentsWindow.this.closeWindow();
            }
        });
        this.setDefaultButton(this.okButton);
        this.pack();
        this.setResizable(false);
        if (parent != null) {
            UIUtilities.centerDialog(this, parent);
        }
        this.setVisible(true);
    }

    public boolean clickedOk() {
        return this.ok;
    }

    public void setOkEnabled(boolean enabled) {
        this.okButton.setEnabled(enabled);
    }

    protected void buttonPressed(CommandEvent e) {
        String command = e.getActionCommand();
        this.ok = !command.equals("cancel");
        this.closeWindow();
    }

    protected void closeWindow() {
        if (this.ok && this.okCallback != null) {
            this.okCallback.run();
        }
        if (!this.ok && this.cancelCallback != null) {
            this.cancelCallback.run();
        }
        this.dispose();
        for (int i = 0; i < this.comp.length; ++i) {
            this.comp[i].removeEventLink(class$buoy$event$KeyPressedEvent == null ? ComponentsWindow.class$("buoy.event.KeyPressedEvent") : class$buoy$event$KeyPressedEvent, (Object)this);
        }
    }

    protected void keyPressed(KeyPressedEvent ev) {
        int code = ev.getKeyCode();
        if (code == 27) {
            this.closeWindow();
        }
    }
}

