/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.ThemeManager;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BList;
import buoy.widget.BMenuBar;
import buoy.widget.BOutline;
import buoy.widget.BRadioButton;
import buoy.widget.BScrollPane;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUtilities {
    private static Font defaultFont;
    private static int standardDialogInsets;

    public static void centerWindow(WindowWidget win) {
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Rectangle winBounds = win.getBounds();
        int x = (screenBounds.width - winBounds.width) / 2;
        int y = (screenBounds.height - winBounds.height) / 2;
        if (x < screenBounds.x) {
            x = screenBounds.x;
        }
        if (y < screenBounds.y) {
            y = screenBounds.y;
        }
        win.setBounds(new Rectangle(x, y, winBounds.width, winBounds.height));
    }

    public static void centerDialog(BDialog dlg, WindowWidget parent) {
        Rectangle r1 = parent.getBounds();
        Rectangle r2 = dlg.getBounds();
        int x = r1.x + (r1.width - r2.width) / 2;
        int y = r1.y + (r1.height - r2.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        dlg.setBounds(new Rectangle(x, y, r2.width, r2.height));
    }

    public static void fitWindowToScreen(WindowWidget win) {
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Rectangle winBounds = win.getBounds();
        if (winBounds.x < screenBounds.x) {
            winBounds.x = screenBounds.x;
        }
        if (winBounds.y < screenBounds.y) {
            winBounds.y = screenBounds.y;
        }
        if (winBounds.width > screenBounds.width) {
            winBounds.width = screenBounds.width;
        }
        if (winBounds.height > screenBounds.height) {
            winBounds.height = screenBounds.height;
        }
        win.setBounds(winBounds);
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(Font font) {
        defaultFont = font;
    }

    public static int getStandardDialogInsets() {
        return standardDialogInsets;
    }

    public static void setStandardDialogInsets(int pixels) {
        standardDialogInsets = pixels;
    }

    public static void applyDefaultFont(Widget w) {
        if (UIUtilities.getDefaultFont() == null) {
            return;
        }
        w.setFont(UIUtilities.getDefaultFont());
        if (w instanceof WidgetContainer && !(w instanceof BMenuBar)) {
            Iterator<Widget> children = ((WidgetContainer)w).getChildren().iterator();
            while (children.hasNext()) {
                UIUtilities.applyDefaultFont(children.next());
            }
        }
    }

    public static void applyDefaultBackground(Widget w) {
        UIUtilities.applyBackground(w, ThemeManager.getAppBackgroundColor());
        UIUtilities.applyTextColor(w, ThemeManager.getTextColor());
    }

    public static void applyBackground(Widget w, Color color) {
        if (w instanceof WidgetContainer) {
            w.setBackground(color);
            Iterator<Widget> children = ((WidgetContainer)w).getChildren().iterator();
            while (children.hasNext()) {
                UIUtilities.applyBackground(children.next(), color);
            }
        } else if (w instanceof BLabel) {
            w.setBackground(color);
        } else if (w instanceof BButton || w instanceof BComboBox || w instanceof BCheckBox || w instanceof BRadioButton) {
            ((JComponent)w.getComponent()).setOpaque(false);
        }
    }

    public static void applyTextColor(Widget w, Color color) {
        if (w instanceof WidgetContainer) {
            Iterator<Widget> children = ((WidgetContainer)w).getChildren().iterator();
            while (children.hasNext()) {
                UIUtilities.applyTextColor(children.next(), color);
            }
        } else if (w instanceof BLabel || w instanceof BCheckBox || w instanceof BRadioButton) {
            w.getComponent().setForeground(color);
        }
    }

    public static WidgetContainer createScrollingList(BList list) {
        BScrollPane scroll = new BScrollPane(list, BScrollPane.SCROLLBAR_AS_NEEDED, BScrollPane.SCROLLBAR_ALWAYS);
        scroll.setBackground(list.getBackground());
        scroll.setForceWidth(true);
        return BOutline.createBevelBorder(scroll, false);
    }

    public static WindowWidget findWindow(Widget w) {
        if (w instanceof WindowWidget) {
            return (WindowWidget)w;
        }
        if (w == null) {
            return null;
        }
        return UIUtilities.findWindow(w.getParent());
    }

    public static BFrame findFrame(Widget w) {
        if (w instanceof BFrame) {
            return (BFrame)w;
        }
        if (w == null) {
            return null;
        }
        return UIUtilities.findFrame(w.getParent());
    }

    public static String[] breakString(String s) {
        int lines = s.length() / 60 + 1;
        if (lines < 2) {
            return new String[]{s};
        }
        int lineLength = s.length() / lines;
        Vector<String> line = new Vector<String>();
        int index = 0;
        while (index + lineLength < s.length()) {
            int next = s.indexOf(32, index + lineLength);
            if (next == -1) {
                next = s.length();
            }
            line.addElement(s.substring(index, next).trim());
            index = next;
        }
        if (index < s.length()) {
            line.addElement(s.substring(index).trim());
        }
        Object[] result = new String[line.size()];
        line.copyInto(result);
        return result;
    }

    public static void setEnabled(Widget w, boolean enabled) {
        w.setEnabled(enabled);
        if (w instanceof WidgetContainer) {
            Iterator<Widget> children = ((WidgetContainer)w).getChildren().iterator();
            while (children.hasNext()) {
                UIUtilities.setEnabled(children.next(), enabled);
            }
        }
    }

    public static List<Widget> findAllChildren(Widget w) {
        ArrayList<Widget> list = new ArrayList<Widget>();
        UIUtilities.addChildrenToList(w, list);
        return list;
    }

    private static void addChildrenToList(Widget w, List<Widget> list) {
        if (w instanceof WidgetContainer) {
            for (Widget child : ((WidgetContainer)w).getChildren()) {
                list.add(child);
                UIUtilities.addChildrenToList(child, list);
            }
        }
    }

    static {
        standardDialogInsets = 0;
    }
}

