/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.PluginRegistry;
import buoy.event.CommandEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.Shortcut;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Translate {
    private static Locale locale = Locale.getDefault();
    private static Map<String, ResourceBundle> bundles = new HashMap<String, ResourceBundle>();

    public static void setLocale(Locale l) {
        locale = l;
        bundles.clear();
    }

    public static Locale getLocale() {
        return locale;
    }

    public static Locale[] getAvailableLocales() {
        return new Locale[]{new Locale("af", "ZA"), Locale.SIMPLIFIED_CHINESE, new Locale("da", "DK"), new Locale("nl", "NL"), Locale.US, new Locale("fi", "FI"), Locale.FRENCH, Locale.GERMAN, Locale.ITALIAN, Locale.JAPANESE, new Locale("pt", "BR"), new Locale("es", "ES"), new Locale("sv", "SE"), new Locale("vi", "VN")};
    }

    private static String getValue(String key, String prefix, String suffix) throws MissingResourceException {
        String bundle;
        int colon = key.indexOf(58);
        if (colon == -1) {
            bundle = "artofillusion";
        } else {
            bundle = key.substring(0, colon);
            key = key.substring(colon + 1);
        }
        if (prefix != null && suffix != null) {
            key = prefix + key + suffix;
        } else if (prefix != null) {
            key = prefix + key;
        } else if (suffix != null) {
            key = key + suffix;
        }
        ResourceBundle resources = bundles.get(bundle);
        if (resources == null) {
            PluginRegistry.PluginResource plugin = PluginRegistry.getResource("TranslateBundle", bundle);
            if (plugin == null) {
                throw new MissingResourceException("No TranslateBundle defined", bundle, key);
            }
            resources = ResourceBundle.getBundle(plugin.getName(), locale, plugin.getClassLoader());
            bundles.put(bundle, resources);
        }
        return resources.getString(key);
    }

    public static BMenu menu(String name) {
        String title = name;
        try {
            title = Translate.getValue(name, "menu.", null);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        BMenu menu = new BMenu(title);
        menu.setName(name);
        return menu;
    }

    public static BMenuItem menuItem(String name, Object listener, String method) {
        String command = name;
        try {
            command = Translate.getValue(name, "menu.", null);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        BMenuItem item = new BMenuItem(command);
        item.setActionCommand(name);
        try {
            String shortcut = Translate.getValue(name, "menu.", ".shortcut");
            if (shortcut.length() > 1 && shortcut.charAt(0) == '^') {
                item.setShortcut(new Shortcut(shortcut.charAt(1), 65537));
            } else if (shortcut.length() > 0) {
                item.setShortcut(new Shortcut(shortcut.charAt(0)));
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        if (listener != null) {
            item.addEventLink(CommandEvent.class, listener, method);
        }
        return item;
    }

    public static BMenuItem menuItem(String name, Object listener, String method, Shortcut shortcut) {
        String command = name;
        try {
            command = Translate.getValue(name, "menu.", null);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        BMenuItem item = new BMenuItem(command);
        item.setActionCommand(name);
        if (shortcut != null) {
            item.setShortcut(shortcut);
        }
        if (listener != null) {
            item.addEventLink(CommandEvent.class, listener, method);
        }
        return item;
    }

    public static BCheckBoxMenuItem checkboxMenuItem(String name, Object listener, String method, boolean state) {
        String command = name;
        try {
            command = Translate.getValue(name, "menu.", null);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        BCheckBoxMenuItem item = new BCheckBoxMenuItem(command, state);
        item.setActionCommand(name);
        try {
            String shortcut = Translate.getValue(name, "menu.", ".shortcut");
            if (shortcut.length() > 1 && shortcut.charAt(0) == '^') {
                item.setShortcut(new Shortcut(shortcut.charAt(1), 65537));
            } else if (shortcut.length() > 0) {
                item.setShortcut(new Shortcut(shortcut.charAt(0)));
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        if (listener != null) {
            item.addEventLink(CommandEvent.class, listener, method);
        }
        return item;
    }

    public static BButton button(String name, Object listener, String method) {
        return Translate.button(name, null, listener, method);
    }

    public static BButton button(String name, String suffix, Object listener, String method) {
        String command = name;
        try {
            command = Translate.getValue(name, "button.", null);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        if (suffix != null) {
            command = command + suffix;
        }
        BButton b = new BButton(command);
        b.setActionCommand(name);
        if (listener != null) {
            b.addEventLink(CommandEvent.class, listener, method);
        }
        return b;
    }

    public static BLabel label(String name) {
        return Translate.label(name, null);
    }

    public static BLabel label(String name, String suffix) {
        try {
            name = Translate.getValue(name, null, null);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (suffix != null) {
            name = name + suffix;
        }
        return new BLabel(name);
    }

    public static String text(String name) {
        try {
            return Translate.getValue(name, null, null);
        }
        catch (MissingResourceException ex) {
            return name;
        }
    }

    public static String text(String name, Object arg1) {
        String pattern = name;
        try {
            pattern = Translate.getValue(name, null, null);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return MessageFormat.format(pattern, arg1);
    }

    public static String text(String name, Object arg1, Object arg2) {
        String pattern = name;
        try {
            pattern = Translate.getValue(name, null, null);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return MessageFormat.format(pattern, arg1, arg2);
    }

    public static String text(String name, Object[] args) {
        String pattern = name;
        try {
            pattern = Translate.getValue(name, null, null);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return MessageFormat.format(pattern, args);
    }
}

