/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ArtOfIllusion;
import artofillusion.PluginRegistry;
import artofillusion.ViewerCanvas;
import artofillusion.math.RGBColor;
import artofillusion.ui.DefaultToolButton;
import artofillusion.ui.EditingTool;
import artofillusion.ui.ToolButton;
import artofillusion.ui.Translate;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ThemeManager {
    private static ThemeInfo selectedTheme;
    private static ThemeInfo defaultTheme;
    private static ColorSet selectedColorSet;
    private static ThemeInfo[] themeList;
    private static Map<String, ThemeInfo> themeIdMap;
    private static DocumentBuilderFactory documentBuilderFactory;
    private static final ImageIcon notFoundIcon;

    public static ThemeInfo getSelectedTheme() {
        return selectedTheme;
    }

    public static void setSelectedTheme(ThemeInfo theme) {
        selectedTheme = theme;
        ThemeManager.setSelectedColorSet(theme.colorSets[0]);
        ThemeManager.applyButtonProperties();
    }

    public static ColorSet getSelectedColorSet() {
        return selectedColorSet;
    }

    public static void setSelectedColorSet(ColorSet colorSet) {
        selectedColorSet = colorSet;
        ThemeManager.applyThemeColors();
    }

    public static List getThemes() {
        return Collections.unmodifiableList(Arrays.asList(themeList));
    }

    public static ThemeInfo getDefaultTheme() {
        return defaultTheme;
    }

    private static void applyThemeColors() {
        ColorSet set = selectedColorSet;
        ViewerCanvas.backgroundColor = new Color(set.viewerBackground.getRed(), set.viewerBackground.getGreen(), set.viewerBackground.getBlue());
        ViewerCanvas.lineColor = new Color(set.viewerLine.getRed(), set.viewerLine.getGreen(), set.viewerLine.getBlue());
        ViewerCanvas.handleColor = new Color(set.viewerHandle.getRed(), set.viewerHandle.getGreen(), set.viewerHandle.getBlue());
        ViewerCanvas.highlightColor = new Color(set.viewerHighlight.getRed(), set.viewerHighlight.getGreen(), set.viewerHighlight.getBlue());
        ViewerCanvas.specialHighlightColor = new Color(set.viewerSpecialHighlight.getRed(), set.viewerSpecialHighlight.getGreen(), set.viewerSpecialHighlight.getBlue());
        ViewerCanvas.disabledColor = new Color(set.viewerDisabled.getRed(), set.viewerDisabled.getGreen(), set.viewerDisabled.getBlue());
        Color viewerSurface = new Color(set.viewerSurface.getRed(), set.viewerSurface.getGreen(), set.viewerSurface.getBlue());
        Color viewerTransparent = new Color(set.viewerTransparent.getRed(), set.viewerTransparent.getGreen(), set.viewerTransparent.getBlue());
        Color viewerLowValue = new Color(set.viewerLowValue.getRed(), set.viewerLowValue.getGreen(), set.viewerLowValue.getBlue());
        Color viewerHighValue = new Color(set.viewerHighValue.getRed(), set.viewerHighValue.getGreen(), set.viewerHighValue.getBlue());
        ViewerCanvas.surfaceColor = viewerSurface;
        ViewerCanvas.surfaceRGBColor = new RGBColor((double)viewerSurface.getRed() / 255.0, (double)viewerSurface.getGreen() / 255.0, (double)viewerSurface.getBlue() / 255.0);
        ViewerCanvas.transparentColor = new RGBColor((double)viewerTransparent.getRed() / 255.0, (double)viewerTransparent.getGreen() / 255.0, (double)viewerTransparent.getBlue() / 255.0);
        ViewerCanvas.lowValueColor = new RGBColor((double)viewerLowValue.getRed() / 255.0, (double)viewerLowValue.getGreen() / 255.0, (double)viewerLowValue.getBlue() / 255.0);
        ViewerCanvas.highValueColor = new RGBColor((double)viewerHighValue.getRed() / 255.0, (double)viewerHighValue.getGreen() / 255.0, (double)viewerHighValue.getBlue() / 255.0);
    }

    private static void applyButtonProperties() {
        Class buttonClass = ThemeManager.selectedTheme.buttonClass;
        try {
            Method m = buttonClass.getMethod("setProperties", Object.class);
            m.invoke((Object)buttonClass, ThemeManager.selectedTheme.buttonProperties);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Throwable t) {
            System.out.println("Error applying Button proterties: " + t);
        }
    }

    private static URL getIconURL(String name) {
        ThemeInfo source = selectedTheme;
        ThemeInfo defaultSource = defaultTheme;
        int colon = name.indexOf(58);
        if (colon > -1) {
            defaultSource = themeIdMap.get(name.substring(0, colon));
            name = name.substring(colon + 1);
        }
        URL url = null;
        url = source.loader.getResource(name + ".png");
        if (url == null) {
            url = source.loader.getResource(name + ".gif");
        }
        if (url == null && defaultSource != null) {
            url = defaultSource.loader.getResource(name + ".png");
        }
        if (url == null && defaultSource != null) {
            url = defaultSource.loader.getResource(name + ".gif");
        }
        return url;
    }

    public static URL getNotFoundURL(Object owner) {
        String notFound = null;
        ButtonStyle bstyle = ThemeManager.getButtonStyle(owner);
        if (bstyle != null) {
            notFound = bstyle.getAttribute("notFound");
        }
        if (notFound == null) {
            notFound = "iconNotFound";
        }
        return ThemeManager.getIconURL(notFound);
    }

    public static ImageIcon getNotFoundIcon(Object owner) {
        URL url = ThemeManager.getNotFoundURL(owner);
        if (url != null) {
            return new ImageIcon(url);
        }
        return notFoundIcon;
    }

    public static ToolButton getToolButton(Object owner, String iconName, String selectedIconName) {
        System.out.println("**Deprecated method called: ThemeManager.getToolButton(Object, String, String)");
        Exception e = new Exception();
        StackTraceElement[] trace = e.getStackTrace();
        if (trace.length > 1) {
            StackTraceElement frame = trace[1];
            String name = frame.getClassName();
            int cut = name.lastIndexOf(46);
            System.out.print("\tcalled from ");
            if (frame.getFileName() != null) {
                System.out.print(frame.getFileName());
                System.out.print(':');
                System.out.print(String.valueOf(frame.getLineNumber()));
            } else {
                System.out.print(cut > 0 ? name.substring(cut + 1) : name);
                System.out.print('.');
                System.out.print(frame.getMethodName());
                System.out.print("() (unknown source)");
            }
            System.out.println();
        }
        return ThemeManager.getToolButton(owner, iconName);
    }

    public static ToolButton getToolButton(Object owner, String iconName) {
        Class buttonClass = ThemeManager.selectedTheme.buttonClass;
        URL url = ThemeManager.getIconURL(iconName);
        ImageIcon selected = null;
        if (url != null) {
            String path = url.getFile();
            int cut = path.lastIndexOf(47);
            if (cut > 0) {
                path = path.substring(0, cut) + "/selected" + path.substring(cut);
            }
            try {
                selected = new ImageIcon(new URL(url.getProtocol(), url.getHost(), path));
            }
            catch (Throwable t) {
                selected = null;
            }
        }
        if (selected != null && selected.getIconWidth() > 0) {
            try {
                Constructor ctor = buttonClass.getConstructor(Object.class, ImageIcon.class, ImageIcon.class);
                return (ToolButton)ctor.newInstance(owner, new ImageIcon(url), selected);
            }
            catch (Throwable t) {
                System.out.println("Could not find a usable Ctor for ToolButton: " + buttonClass.getName() + ": " + iconName + "\n\t" + t);
            }
        }
        if (url == null) {
            url = ThemeManager.getNotFoundURL(owner);
        }
        if (url != null) {
            try {
                Constructor ctor = buttonClass.getConstructor(Object.class, ImageIcon.class);
                return (ToolButton)ctor.newInstance(owner, new ImageIcon(url));
            }
            catch (Throwable t) {
                System.out.println("Could not find a usable Ctor for ToolButton: " + buttonClass.getName() + ": " + iconName + "\n\t" + t);
            }
        }
        return new DefaultToolButton(owner, notFoundIcon);
    }

    public static ImageIcon getIcon(String iconName) {
        URL url = ThemeManager.getIconURL(iconName);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public static Color getAppBackgroundColor() {
        return ThemeManager.selectedColorSet.appBackground;
    }

    public static Color getPaletteBackgroundColor() {
        return ThemeManager.selectedColorSet.paletteBackground;
    }

    public static Color getDockableBarColor1() {
        return ThemeManager.selectedColorSet.dockableBarColor1;
    }

    public static Color getDockableBarColor2() {
        return ThemeManager.selectedColorSet.dockableBarColor2;
    }

    public static Color getDockableTitleColor() {
        return ThemeManager.selectedColorSet.dockableTitleColor;
    }

    public static Color getTextColor() {
        return ThemeManager.selectedColorSet.textColor;
    }

    public static void initThemes() {
        int i;
        if (themeList != null) {
            throw new IllegalStateException("The themes have already been initialized.");
        }
        themeIdMap = new HashMap<String, ThemeInfo>();
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        List<PluginRegistry.PluginResource> resources = PluginRegistry.getResources("UITheme");
        ArrayList<ThemeInfo> list = new ArrayList<ThemeInfo>();
        for (i = 0; i < resources.size(); ++i) {
            try {
                ThemeInfo themeInfo = new ThemeInfo(resources.get(i));
                list.add(themeInfo);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        themeList = list.toArray(new ThemeInfo[list.size()]);
        for (i = 0; i < themeList.length; ++i) {
            themeIdMap.put(ThemeManager.themeList[i].resource.getId(), themeList[i]);
        }
        defaultTheme = themeIdMap.get("default");
        ThemeManager.setSelectedTheme(defaultTheme);
    }

    private static int getIntegerValueFromNode(Node node) {
        String s;
        if (node != null && (s = ThemeManager.getAttribute(node, "value")) != null) {
            return Integer.parseInt(s);
        }
        return 0;
    }

    private static Color getColorFromNode(Node node) {
        if (node == null) {
            return new Color(0, 0, 0);
        }
        String s = ThemeManager.getAttribute(node, "R");
        int r = 0;
        if (s != null) {
            r = Integer.valueOf(s);
        }
        int g = 0;
        s = ThemeManager.getAttribute(node, "G");
        if (s != null) {
            g = Integer.valueOf(s);
        }
        int b = 0;
        s = ThemeManager.getAttribute(node, "B");
        if (s != null) {
            b = Integer.valueOf(s);
        }
        return new Color(r, g, b);
    }

    public static int getPaletteMargin() {
        return ThemeManager.selectedTheme.paletteMargin;
    }

    public static int getButtonMargin() {
        return ThemeManager.selectedTheme.buttonMargin;
    }

    public static ButtonStyle getButtonStyle(Object owner) {
        return ThemeManager.selectedTheme.buttonStyles != null ? ThemeManager.selectedTheme.buttonStyles.getStyle(owner) : null;
    }

    private static Node getNodeFromNodeList(NodeList nl, String nodeName) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(nodeName)) continue;
            return n;
        }
        return null;
    }

    private static String getAttribute(Node node, String name) {
        NamedNodeMap nm = node.getAttributes();
        if (nm == null) {
            return null;
        }
        Node nn = nm.getNamedItem(name);
        if (nn == null) {
            return null;
        }
        return nn.getNodeValue();
    }

    static {
        URL url = null;
        ImageIcon icon = null;
        try {
            url = Class.forName("artofillusion.ArtOfIllusion").getResource("artofillusion/Icons/iconNotFound.png");
            icon = new ImageIcon(url);
        }
        catch (Exception e) {
            BufferedImage image = new BufferedImage(16, 16, 13);
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            graphics.setColor(new Color(128, 128, 128));
            graphics.fillRect(0, 0, 16, 16);
            graphics.setColor(new Color(200, 100, 100));
            graphics.fillOval(3, 3, 10, 10);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(7, 4, 2, 4);
            graphics.fillOval(7, 10, 2, 2);
            icon = new ImageIcon(image);
        }
        notFoundIcon = icon;
    }

    public static class ButtonStyle {
        protected Class ownerType;
        protected int width = -1;
        protected int height = -1;
        protected HashMap<String, String> attributes = new HashMap();
        protected ButtonStyle next;

        public ButtonStyle(Node node) {
            NamedNodeMap kids = node.getAttributes();
            for (int i = 0; i < kids.getLength(); ++i) {
                node = kids.item(i);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                this.attributes.put(name, value);
                if (name.equalsIgnoreCase("owner")) {
                    try {
                        this.ownerType = ArtOfIllusion.getClass(value);
                    }
                    catch (Exception e) {
                        String msg = e.getMessage();
                        System.out.println("Unable to identify ButtonStyle.owner: " + (msg != null ? msg : e.toString()));
                    }
                }
                if (!name.equalsIgnoreCase("size")) continue;
                int cut = value.indexOf(44);
                if (cut >= 0) {
                    this.width = Integer.parseInt(value.substring(0, cut).trim());
                    this.height = Integer.parseInt(value.substring(cut + 1).trim());
                    continue;
                }
                this.width = this.height = Integer.parseInt(value.trim());
            }
            if (this.ownerType == null) {
                this.ownerType = EditingTool.class;
            }
        }

        protected void add(Node node) {
            if (this.next == null) {
                this.next = new ButtonStyle(node);
            } else {
                this.next.add(node);
            }
        }

        public ButtonStyle getStyle(Object owner) {
            if (this.ownerType != null && this.ownerType.isInstance(owner)) {
                return this;
            }
            return this.next != null ? this.next.getStyle(owner) : null;
        }

        public String getAttribute(String name) {
            return this.attributes.get(name);
        }
    }

    public static class ThemeInfo {
        private final String name;
        public final String author;
        public final String description;
        public final Class buttonClass;
        public final Object buttonProperties;
        public final int buttonMargin;
        public final int paletteMargin;
        private final ColorSet[] colorSets;
        public final boolean classicToolBarButtons;
        public final PluginRegistry.PluginResource resource;
        public final ClassLoader loader;
        public final boolean selectable;
        protected ButtonStyle buttonStyles;

        private ThemeInfo(PluginRegistry.PluginResource resource) throws IOException, SAXException, ParserConfigurationException {
            int i;
            InputStream is = resource.getInputStream();
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            Document document = builder.parse(is);
            is.close();
            Element rootNode = document.getDocumentElement();
            NodeList themeNodeList = rootNode.getChildNodes();
            this.resource = resource;
            URL url = resource.getURL();
            String path = url.getPath();
            int cut = path.lastIndexOf(47);
            path = cut > 0 ? path.substring(0, cut + 1) : "/";
            url = new URL(url.getProtocol(), url.getHost(), path);
            this.loader = new URLClassLoader(new URL[]{url});
            Node node = ThemeManager.getNodeFromNodeList(themeNodeList, "name");
            this.name = node != null ? node.getFirstChild().getNodeValue() : "";
            node = ThemeManager.getNodeFromNodeList(themeNodeList, "author");
            this.author = node != null ? node.getFirstChild().getNodeValue() : "";
            node = ThemeManager.getNodeFromNodeList(themeNodeList, "description");
            this.description = node != null ? node.getFirstChild().getNodeValue() : "";
            node = ThemeManager.getNodeFromNodeList(themeNodeList, "selectable");
            this.selectable = node != null ? Boolean.valueOf(node.getFirstChild().getNodeValue()) : true;
            node = ThemeManager.getNodeFromNodeList(themeNodeList, "button");
            if (node != null) {
                String className = ThemeManager.getAttribute(node, "class");
                Object properties = null;
                Class cls = DefaultToolButton.class;
                try {
                    cls = resource.getClassLoader().loadClass(className);
                    Method m = cls.getMethod("readPropertiesFromXMLNode", Node.class);
                    properties = m.invoke((Object)className, node);
                }
                catch (NoSuchMethodException ex) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ButtonStyle bstyle = null;
                NodeList list = node.getChildNodes();
                Node kid = null;
                for (int i2 = 0; i2 < list.getLength(); ++i2) {
                    kid = list.item(i2);
                    if (!kid.getNodeName().equals("style")) continue;
                    if (bstyle == null) {
                        bstyle = new ButtonStyle(kid);
                        continue;
                    }
                    bstyle.add(kid);
                }
                this.buttonClass = cls;
                this.buttonProperties = properties;
                this.buttonStyles = bstyle;
                String s = ThemeManager.getAttribute(node, "useintoolbars");
                this.classicToolBarButtons = s != null ? !Boolean.valueOf(s).booleanValue() : false;
            } else {
                this.buttonClass = DefaultToolButton.class;
                this.buttonProperties = null;
                this.classicToolBarButtons = false;
            }
            node = ThemeManager.getNodeFromNodeList(themeNodeList, "palettemargin");
            this.paletteMargin = ThemeManager.getIntegerValueFromNode(node);
            node = ThemeManager.getNodeFromNodeList(themeNodeList, "buttonmargin");
            this.buttonMargin = ThemeManager.getIntegerValueFromNode(node);
            int count = 0;
            for (i = 0; i < themeNodeList.getLength(); ++i) {
                node = themeNodeList.item(i);
                if (!node.getNodeName().equals("colorset")) continue;
                ++count;
            }
            this.colorSets = new ColorSet[count];
            count = 0;
            for (i = 0; i < themeNodeList.getLength(); ++i) {
                node = themeNodeList.item(i);
                if (!node.getNodeName().equals("colorset")) continue;
                this.colorSets[count++] = new ColorSet(node);
            }
        }

        public String getName() {
            return Translate.text(this.name);
        }

        public ColorSet[] getColorSets() {
            return (ColorSet[])this.colorSets.clone();
        }
    }

    public static class ColorSet {
        public final Color appBackground;
        public final Color paletteBackground;
        public final Color viewerBackground;
        public final Color viewerLine;
        public final Color viewerHandle;
        public final Color viewerHighlight;
        public final Color viewerSpecialHighlight;
        public final Color viewerDisabled;
        public final Color viewerSurface;
        public final Color viewerTransparent;
        public final Color viewerLowValue;
        public final Color viewerHighValue;
        public final Color dockableBarColor1;
        public final Color dockableBarColor2;
        public final Color dockableTitleColor;
        public final Color textColor;
        private final String name;

        private ColorSet(Node node) {
            this.name = ThemeManager.getAttribute(node, "name");
            NodeList list = node.getChildNodes();
            node = ThemeManager.getNodeFromNodeList(list, "applicationbackground");
            this.appBackground = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "palettebackground");
            this.paletteBackground = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerbackground");
            this.viewerBackground = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerline");
            this.viewerLine = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerhandle");
            this.viewerHandle = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerhighlight");
            this.viewerHighlight = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerspecialhighlight");
            this.viewerSpecialHighlight = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerdisabled");
            this.viewerDisabled = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewersurface");
            this.viewerSurface = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerlowvalue");
            this.viewerLowValue = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerhighvalue");
            this.viewerHighValue = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewertransparent");
            this.viewerTransparent = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "dockablebarcolor1");
            this.dockableBarColor1 = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "dockablebarcolor2");
            this.dockableBarColor2 = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "dockabletitlecolor");
            this.dockableTitleColor = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "textcolor");
            this.textColor = ThemeManager.getColorFromNode(node);
        }

        public String getName() {
            return Translate.text(this.name);
        }
    }
}

