/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.Translate;
import buoy.event.SelectionChangedEvent;
import buoy.widget.BFileChooser;
import java.awt.Dimension;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ImageFileChooser
extends BFileChooser {
    private JLabel preview = new JLabel();
    private static final int PREVIEW_SIZE = 200;
    private static final int INSET = 5;

    public ImageFileChooser(String title) {
        super(BFileChooser.OPEN_FILE, title);
        this.preview.setPreferredSize(new Dimension(210, 210));
        this.preview.setHorizontalAlignment(0);
        this.preview.setVerticalAlignment(0);
        this.getComponent().setAccessory(this.preview);
        this.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
        this.selectionChanged();
    }

    private void selectionChanged() {
        File file = null;
        if (this.isMultipleSelectionEnabled()) {
            File[] files = this.getSelectedFiles();
            if (files.length > 1) {
                this.preview.setIcon(null);
                this.preview.setText(null);
                return;
            }
            if (files.length == 1) {
                file = files[0];
            }
        } else {
            file = this.getSelectedFile();
        }
        if (file == null || !file.isFile()) {
            this.preview.setIcon(null);
            this.preview.setText(Translate.text("noFileSelected"));
        } else {
            ImageIcon image = new ImageIcon(file.getAbsolutePath());
            if (image.getImageLoadStatus() != 8) {
                this.preview.setIcon(null);
                this.preview.setText(Translate.text("noPreviewAvailable"));
            } else {
                this.preview.setText(null);
                int width = image.getIconWidth();
                int height = image.getIconHeight();
                if (width > 200 && width >= height) {
                    image = new ImageIcon(image.getImage().getScaledInstance(200, -1, 1));
                } else if (height > 200) {
                    image = new ImageIcon(image.getImage().getScaledInstance(-1, 200, 1));
                }
                this.preview.setIcon(image);
            }
        }
    }
}

