/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.math.RGBColor;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueSlider;
import buoy.event.KeyPressedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WindowActivatedEvent;
import buoy.widget.BButton;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;

public class ColorChooser
extends BDialog {
    private RGBColor oldColor;
    private RGBColor newColor;
    private ValueSlider slider1;
    private ValueSlider slider2;
    private ValueSlider slider3;
    private BLabel label1;
    private BLabel label2;
    private BLabel label3;
    private Widget oldColorPatch;
    private Widget newColorPatch;
    private BComboBox modeC;
    private BComboBox rangeC;
    private boolean ok;
    private static final int RECENT_COLOR_COUNT = 15;
    private static ArrayList<RGBColor> recentColors;
    private static int mode;
    private static int rangeMode;

    public ColorChooser(BFrame parent, String title, RGBColor c) {
        this(parent, title, c, true);
    }

    public ColorChooser(BFrame parent, String title, RGBColor c, boolean show) {
        super(parent, title, true);
        BorderContainer content = new BorderContainer();
        this.setContent(BOutline.createEmptyBorder(content, UIUtilities.getStandardDialogInsets()));
        this.oldColor = c;
        this.newColor = c.duplicate();
        RowContainer buttons = new RowContainer();
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "dispose"));
        content.add(buttons, BorderContainer.SOUTH, new LayoutInfo());
        FormContainer center = new FormContainer(new double[]{0.0, 1.0, 0.0}, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0});
        center.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, null, null));
        content.add(center, BorderContainer.CENTER);
        LayoutInfo labelLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, new Insets(5, 0, 0, 10), null);
        this.label1 = Translate.label("Red");
        center.add(this.label1, 0, 0, 2, 1, labelLayout);
        this.label2 = Translate.label("Green");
        center.add(this.label2, 0, 2, 2, 1, labelLayout);
        this.label3 = Translate.label("Blue");
        center.add(this.label3, 0, 4, 2, 1, labelLayout);
        LayoutInfo sliderLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, new Insets(0, 0, 0, 5), null);
        double componentMax = rangeMode == 0 ? 1.0 : 255.0;
        this.slider1 = new ValueSlider(0.0, componentMax, 100, this.newColor.getRed());
        center.add(this.slider1, 0, 1, 2, 1, sliderLayout);
        this.slider2 = new ValueSlider(0.0, componentMax, 100, this.newColor.getGreen());
        center.add(this.slider2, 0, 3, 2, 1, sliderLayout);
        this.slider3 = new ValueSlider(0.0, componentMax, 100, this.newColor.getBlue());
        center.add(this.slider3, 0, 5, 2, 1, sliderLayout);
        this.label1.setAlignment(BLabel.EAST);
        this.label2.setAlignment(BLabel.EAST);
        this.label3.setAlignment(BLabel.EAST);
        this.label1.setTextPosition(BLabel.WEST);
        this.label2.setTextPosition(BLabel.WEST);
        this.label3.setTextPosition(BLabel.WEST);
        this.slider1.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
        this.slider2.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
        this.slider3.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
        RowContainer choicesRow = new RowContainer();
        center.add(choicesRow, 0, 6, 3, 1);
        choicesRow.add(Translate.label("colorModel"));
        this.modeC = new BComboBox(new String[]{"RGB", "HSV", "HLS"});
        choicesRow.add(this.modeC, new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 0, 0, 8), null));
        choicesRow.add(Translate.label("colorComponentRange"));
        this.modeC.addEventLink(ValueChangedEvent.class, (Object)this, "modeChanged");
        this.modeC.setSelectedIndex(mode);
        this.rangeC = new BComboBox(new String[]{"0 to 1", "0 to 255"});
        choicesRow.add(this.rangeC, new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
        this.rangeC.addEventLink(ValueChangedEvent.class, (Object)this, "rangeChanged");
        this.rangeC.setSelectedIndex(rangeMode);
        LayoutInfo patchLayout = new LayoutInfo();
        center.add(Translate.label("originalColor"), 2, 0, patchLayout);
        this.oldColorPatch = this.oldColor.getSample(50, 30);
        center.add(this.oldColorPatch, 2, 1, patchLayout);
        center.add(Translate.label("newColor"), 2, 2, patchLayout);
        this.newColorPatch = this.newColor.getSample(50, 30);
        center.add(this.newColorPatch, 2, 3, patchLayout);
        center.add(Translate.label("recentColors"), 0, 7, 3, 1);
        RowContainer recentColorRow = new RowContainer();
        center.add(recentColorRow, 0, 8, 3, 1);
        for (int i = 0; i < recentColors.size(); ++i) {
            final RGBColor color = recentColors.get(i);
            Widget sample = color.getSample(16, 16);
            recentColorRow.add(sample);
            sample.addEventLink(MousePressedEvent.class, new Object(){

                void processEvent() {
                    ColorChooser.this.setColor(color);
                }
            });
        }
        this.addAsListener(this);
        this.modeChanged();
        this.pack();
        this.addEventLink(WindowActivatedEvent.class, new Object(){

            void processEvent() {
                ColorChooser.this.updateColorGradients();
            }
        });
        this.setResizable(false);
        UIUtilities.centerDialog(this, parent);
        if (show) {
            this.setVisible(true);
        }
    }

    public RGBColor getColor() {
        return this.newColor.duplicate();
    }

    public boolean clickedOk() {
        return this.ok;
    }

    private void addAsListener(Widget w) {
        w.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        if (w instanceof WidgetContainer) {
            for (Widget child : ((WidgetContainer)w).getChildren()) {
                this.addAsListener(child);
            }
        }
    }

    private void doOk() {
        this.oldColor.setRGB(this.newColor.getRed(), this.newColor.getGreen(), this.newColor.getBlue());
        for (int i = 0; i < recentColors.size(); ++i) {
            if (!recentColors.get(i).equals(this.newColor)) continue;
            recentColors.remove(i);
            break;
        }
        if (recentColors.size() == 15) {
            recentColors.remove(recentColors.size() - 1);
        }
        recentColors.add(0, this.newColor.duplicate());
        this.ok = true;
        this.dispose();
    }

    private void valueChanged() {
        float[] values = new float[]{(float)this.slider1.getValue(), (float)this.slider2.getValue(), (float)this.slider3.getValue()};
        if (rangeMode == 1) {
            values[0] = (float)((double)values[0] / 255.0);
            values[1] = (float)((double)values[1] / 255.0);
            values[2] = (float)((double)values[2] / 255.0);
        }
        if (mode == 0) {
            this.newColor.setRGB(values[0], values[1], values[2]);
        } else if (mode == 1) {
            this.newColor.setHSV(values[0] * 360.0f, values[1], values[2]);
        } else {
            this.newColor.setHLS(values[0] * 360.0f, values[1], values[2]);
        }
        this.newColorPatch.setBackground(this.newColor.getColor());
        this.newColorPatch.repaint();
        this.updateColorGradients();
        this.dispatchEvent(new ValueChangedEvent(this));
    }

    private void setColor(RGBColor color) {
        this.newColor.copy(color);
        this.newColorPatch.setBackground(this.newColor.getColor());
        this.newColorPatch.repaint();
        this.dispatchEvent(new ValueChangedEvent(this));
        this.modeChanged();
    }

    private void keyPressed(KeyPressedEvent ev) {
        int code = ev.getKeyCode();
        if (code != 10 && code != 27) {
            return;
        }
        if (code == 10 && ev.getWidget() instanceof BButton) {
            return;
        }
        if (code == 10) {
            this.oldColor.setRGB(this.newColor.getRed(), this.newColor.getGreen(), this.newColor.getBlue());
        }
        this.dispose();
    }

    private void modeChanged() {
        float[] values;
        mode = this.modeC.getSelectedIndex();
        if (mode == 0) {
            this.label1.setText(Translate.text("Red"));
            this.label2.setText(Translate.text("Green"));
            this.label3.setText(Translate.text("Blue"));
            values = new float[]{this.newColor.getRed(), this.newColor.getGreen(), this.newColor.getBlue()};
        } else if (mode == 1) {
            this.label1.setText(Translate.text("Hue"));
            this.label2.setText(Translate.text("Saturation"));
            this.label3.setText(Translate.text("Value"));
            values = this.newColor.getHSV();
            values[0] = (float)((double)values[0] / 360.0);
        } else {
            this.label1.setText(Translate.text("Hue"));
            this.label2.setText(Translate.text("Lightness"));
            this.label3.setText(Translate.text("Saturation"));
            values = this.newColor.getHLS();
            values[0] = (float)((double)values[0] / 360.0);
        }
        double scale = rangeMode == 0 ? 1.0 : 255.0;
        this.slider1.setValue(scale * (double)values[0]);
        this.slider2.setValue(scale * (double)values[1]);
        this.slider3.setValue(scale * (double)values[2]);
        Preferences.userNodeForPackage(ColorChooser.class).putInt("defaultColorModel", mode);
        this.updateColorGradients();
    }

    private void rangeChanged() {
        rangeMode = this.rangeC.getSelectedIndex();
        double componentMax = rangeMode == 0 ? 1.0 : 255.0;
        this.slider1.setMaximumValue(componentMax);
        this.slider2.setMaximumValue(componentMax);
        this.slider3.setMaximumValue(componentMax);
        Preferences.userNodeForPackage(ColorChooser.class).putInt("defaultColorRange", rangeMode);
        this.modeChanged();
    }

    private void updateColorGradients() {
        int width = this.slider1.slider.getBounds().width;
        if (width <= 0) {
            return;
        }
        BLabel[] labels = new BLabel[]{this.label1, this.label2, this.label3};
        for (int whichPatch = 0; whichPatch < 3; ++whichPatch) {
            BLabel label = labels[whichPatch];
            ImageIcon icon = (ImageIcon)label.getIcon();
            if (icon == null) {
                icon = new ImageIcon(new BufferedImage(width - 10, 15, 1));
                label.setIcon(icon);
            }
            BufferedImage image = (BufferedImage)icon.getImage();
            int gradientRange = image.getWidth();
            int gradientHeight = image.getHeight();
            float[] tempVals = new float[]{(float)this.slider1.getValue(), (float)this.slider2.getValue(), (float)this.slider3.getValue()};
            RGBColor workingColor = new RGBColor();
            if (rangeMode == 1) {
                tempVals[0] = (float)((double)tempVals[0] / 255.0);
                tempVals[1] = (float)((double)tempVals[1] / 255.0);
                tempVals[2] = (float)((double)tempVals[2] / 255.0);
            }
            for (int i = 0; i < gradientRange; ++i) {
                tempVals[whichPatch] = (float)i / (float)gradientRange;
                if (mode == 0) {
                    workingColor.setRGB(tempVals[0], tempVals[1], tempVals[2]);
                } else if (mode == 1) {
                    workingColor.setHSV(tempVals[0] * 360.0f, tempVals[1], tempVals[2]);
                } else {
                    workingColor.setHLS(tempVals[0] * 360.0f, tempVals[1], tempVals[2]);
                }
                int javaRGB = workingColor.getColor().getRGB();
                for (int h = 0; h < gradientHeight; ++h) {
                    image.setRGB(i, h, javaRGB);
                }
            }
            label.repaint();
        }
    }

    static {
        try {
            mode = Preferences.userNodeForPackage(ColorChooser.class).getInt("defaultColorModel", 1);
            rangeMode = Preferences.userNodeForPackage(ColorChooser.class).getInt("defaultColorRange", 0);
        }
        catch (Exception ex) {
            mode = 1;
            rangeMode = 0;
        }
        recentColors = new ArrayList();
        for (int i = 0; i < 15; ++i) {
            recentColors.add(new RGBColor(1.0, 1.0, 1.0));
        }
    }
}

