/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.ArtOfIllusion;
import artofillusion.MeshViewer;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Skeleton;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.Texture2D;
import artofillusion.texture.UVMappingWindow;
import artofillusion.ui.MeshEditController;
import buoy.event.MouseScrolledEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class UVMappingViewer
extends MeshViewer {
    private Texture2D tex;
    private UVMappingWindow window;
    private UVMesh uvmesh;
    private ObjectInfo meshInfo;
    private UVEditController controller;
    private double minu;
    private double maxu;
    private double minv;
    private double maxv;
    private double time;
    private double[] param;
    private int component;
    private int sampling;
    private int deselect;
    private boolean[] selected;
    private boolean dragging;
    private boolean draggingSelectionBox;
    private Point[] screenVert;
    private Vec2[] coord;
    private int[] vertIndex;
    private static final int MARKER_SIZE = 4;

    public UVMappingViewer(Texture2D tex, UVMappingWindow window, double minu, double maxu, double minv, double maxv, int component, int sampling, double time, double[] param) {
        super(window, new RowContainer());
        this.tex = tex;
        this.window = window;
        this.time = time;
        this.param = param;
        this.uvmesh = new UVMesh();
        this.meshInfo = new ObjectInfo(this.uvmesh, new CoordinateSystem(), "");
        this.controller = new UVEditController();
        this.screenVert = new Point[0];
        this.selected = new boolean[0];
        this.setParameters(minu, maxu, minv, maxv, component, sampling);
        this.setShowTemplate(true);
        this.getComponent().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                UVMappingViewer.this.createImage();
            }
        });
    }

    public MeshEditController getController() {
        return this.controller;
    }

    public void setParameters(double minu, double maxu, double minv, double maxv) {
        this.setParameters(minu, maxu, minv, maxv, this.component, this.sampling);
    }

    public void setParameters(double minu, double maxu, double minv, double maxv, int component, int sampling) {
        this.minu = minu;
        this.maxu = maxu;
        this.minv = minv;
        this.maxv = maxv;
        this.component = component;
        this.sampling = sampling;
        this.adjustCamera();
        this.createImage();
        this.calcScreenPositions();
        this.repaint();
        this.window.displayRangeChanged();
    }

    private void adjustCamera() {
        Rectangle dim = this.getBounds();
        double uscale = (double)dim.width / (this.maxu - this.minu);
        double vscale = (double)dim.height / (this.maxv - this.minv);
        this.theCamera.setScreenParamsParallel(1.0, dim.width, dim.height);
        Mat4 worldToView = Mat4.scale(-uscale, vscale, 1.0).times(Mat4.translation(-this.minu - 0.5 * (double)dim.width / uscale, -this.maxv + 0.5 * (double)dim.height / vscale, 0.0));
        Mat4 viewToWorld = Mat4.translation(this.minu + 0.5 * (double)dim.width / uscale, this.maxv - 0.5 * (double)dim.height / vscale, 0.0).times(Mat4.scale(-1.0 / uscale, 1.0 / vscale, 1.0));
        this.theCamera.setViewTransform(worldToView, viewToWorld);
    }

    private void createImage() {
        Rectangle dim = this.getBounds();
        if (dim.width < 1 || dim.height < 1) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        double uoffset = 0.5 * (double)this.sampling * (this.maxu - this.minu) / (double)dim.width;
        double voffset = 0.5 * (double)this.sampling * (this.maxv - this.minv) / (double)dim.height;
        Image theImage = ((Texture2D)this.tex.duplicate()).createComponentImage(this.minu + uoffset, this.maxu + uoffset, this.minv - voffset, this.maxv - voffset, dim.width / this.sampling, dim.height / this.sampling, this.component, this.time, this.param);
        if (this.sampling > 1) {
            theImage = theImage.getScaledInstance(dim.width, dim.height, 4);
        }
        this.setTemplateImage(theImage);
        this.adjustCamera();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public double[] estimateDepthRange() {
        return new double[]{-1.0, 1.0};
    }

    private void calcScreenPositions() {
        Rectangle dim = this.getBounds();
        double uscale = (double)dim.width / (this.maxu - this.minu);
        double vscale = (double)dim.height / (this.maxv - this.minv);
        this.screenVert = new Point[this.uvmesh.vert.length];
        for (int i = 0; i < this.uvmesh.vert.length; ++i) {
            int x = (int)((this.uvmesh.vert[i].r.x - this.minu) * uscale - 0.5);
            int y = (int)((this.maxv - this.uvmesh.vert[i].r.y) * vscale - 0.5);
            this.screenVert[i] = new Point(x, y);
        }
    }

    public synchronized void updateImage() {
        this.adjustCamera();
        for (int i = 0; i < this.screenVert.length; ++i) {
            int x = this.screenVert[i].x;
            int y = this.screenVert[i].y;
            this.drawBox(x - 4, y - 1, 9, 3, Color.white);
            this.drawBox(x - 1, y - 4, 3, 9, Color.white);
            this.drawBox(x - 4 + 1, y, 7, 1, this.selected[i] ? Color.red : Color.black);
            this.drawBox(x, y - 4 + 1, 1, 7, this.selected[i] ? Color.red : Color.black);
        }
        this.currentTool.drawOverlay(this);
    }

    protected void drawObject() {
    }

    public boolean[] getSelection() {
        boolean[] sel = new boolean[this.coord.length];
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            sel[this.vertIndex[i]] = true;
        }
        return sel;
    }

    public void setMesh(Mesh mesh) {
        this.window.setMesh(mesh);
    }

    public void setDisplayedVertices(Vec2[] coord, boolean[] display) {
        int i;
        this.coord = coord;
        int count = 0;
        for (i = 0; i < display.length; ++i) {
            if (!display[i]) continue;
            ++count;
        }
        this.vertIndex = new int[count];
        count = 0;
        for (i = 0; i < display.length; ++i) {
            if (!display[i]) continue;
            this.vertIndex[count++] = i;
        }
        this.updateVertexPositions(coord);
        this.selected = new boolean[this.vertIndex.length];
        this.window.selectionDistance = null;
        this.repaint();
    }

    public void updateVertexPositions(Vec2[] coord) {
        Vec2[] shown = new Vec2[this.vertIndex.length];
        for (int i = 0; i < shown.length; ++i) {
            shown[i] = coord[this.vertIndex[i]];
        }
        this.uvmesh.setVertices(shown);
        this.calcScreenPositions();
    }

    public double getMinU() {
        return this.minu;
    }

    public double getMaxU() {
        return this.maxu;
    }

    public double getMinV() {
        return this.minv;
    }

    public double getMaxV() {
        return this.maxv;
    }

    public boolean isDragInProgress() {
        return this.dragging;
    }

    public void objectChanged() {
        this.calcScreenPositions();
        this.window.getObject().clearCachedMeshes();
        for (int i = 0; i < this.vertIndex.length; ++i) {
            this.coord[this.vertIndex[i]] = new Vec2(this.uvmesh.vert[i].r.x, this.uvmesh.vert[i].r.y);
        }
        this.window.setTextureCoords(this.coord);
        this.window.updateTextFields();
    }

    protected void mousePressed(WidgetMouseEvent e) {
        boolean wantHandleClicks;
        this.sentClick = true;
        this.deselect = -1;
        this.dragging = false;
        this.clickPoint = e.getPoint();
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if ((this.activeTool.whichClicks() & 1) != 0) {
            this.activeTool.mousePressed(e, this);
            this.dragging = true;
        }
        boolean allowSelectionChange = this.activeTool.allowSelectionChanges();
        boolean bl = wantHandleClicks = (this.activeTool.whichClicks() & 4) != 0;
        if (!allowSelectionChange && !wantHandleClicks) {
            return;
        }
        int i = this.findClickTarget(e.getPoint());
        if (i == -1) {
            this.draggingSelectionBox = true;
            this.beginDraggingSelection(e.getPoint(), false);
            this.sentClick = false;
            return;
        }
        if (this.selected[i]) {
            if (e.isShiftDown()) {
                this.deselect = i;
            }
            this.activeTool.mousePressedOnHandle(e, this, 0, i);
            return;
        }
        if (!e.isShiftDown()) {
            for (int k = 0; k < this.selected.length; ++k) {
                this.selected[k] = false;
            }
        }
        this.selected[i] = true;
        this.window.selectionDistance = null;
        this.currentTool.getWindow().updateMenus();
        if (e.isShiftDown()) {
            this.sentClick = false;
            this.repaint();
        } else {
            this.activeTool.mousePressedOnHandle(e, this, 0, i);
        }
    }

    protected void mouseDragged(WidgetMouseEvent e) {
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        super.mouseDragged(e);
    }

    protected void mouseReleased(WidgetMouseEvent e) {
        this.endDraggingSelection();
        if (this.draggingSelectionBox && !e.isShiftDown() && !e.isControlDown()) {
            for (int i = 0; i < this.selected.length; ++i) {
                this.selected[i] = false;
            }
        }
        if (this.selectBounds != null) {
            boolean newsel = !e.isControlDown();
            for (int i = 0; i < this.selected.length; ++i) {
                if (!this.selectionRegionContains(this.screenVert[i])) continue;
                this.selected[i] = newsel;
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        boolean wasDragging = this.dragging;
        this.dragging = false;
        if (this.sentClick) {
            if (!wasDragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            this.selected[this.deselect] = false;
        }
        this.window.selectionDistance = null;
        this.currentTool.getWindow().updateMenus();
        this.repaint();
    }

    protected void processMouseScrolled(MouseScrolledEvent ev) {
        int amount = ev.getWheelRotation();
        if (!ev.isAltDown()) {
            amount *= 10;
        }
        if (ArtOfIllusion.getPreferences().getReverseZooming()) {
            amount *= -1;
        }
        double factor = Math.pow(1.01, -amount);
        double midu = (this.minu + this.maxu) / 2.0;
        double midv = (this.minv + this.maxv) / 2.0;
        double newminu = (this.minu - midu) / factor + midu;
        double newmaxu = (this.maxu - midu) / factor + midu;
        double newminv = (this.minv - midv) / factor + midv;
        double newmaxv = (this.maxv - midv) / factor + midv;
        this.setParameters(newminu, newmaxu, newminv, newmaxv);
    }

    private int findClickTarget(Point pos) {
        MeshVertex[] v = this.uvmesh.getVertices();
        for (int i = v.length - 1; i >= 0; --i) {
            int dy;
            int dx = this.screenVert[i].x - pos.x;
            if (dx < -4 || dx > 4 || (dy = this.screenVert[i].y - pos.y) < -4 || dy > 4) continue;
            return i;
        }
        return -1;
    }

    static /* synthetic */ boolean[] access$302(UVMappingViewer x0, boolean[] x1) {
        x0.selected = x1;
        return x1;
    }

    private class UVEditController
    implements MeshEditController {
        private UVEditController() {
        }

        public ObjectInfo getObject() {
            return UVMappingViewer.this.meshInfo;
        }

        public void setMesh(Mesh mesh) {
        }

        public void objectChanged() {
            UVMappingViewer.this.objectChanged();
        }

        public int getSelectionMode() {
            return 0;
        }

        public void setSelectionMode(int mode) {
        }

        public boolean[] getSelection() {
            return UVMappingViewer.this.selected;
        }

        public void setSelection(boolean[] selected) {
            UVMappingViewer.access$302(UVMappingViewer.this, selected);
        }

        public int[] getSelectionDistance() {
            int[] selectionDistance = new int[UVMappingViewer.this.selected.length];
            for (int i = 0; i < UVMappingViewer.this.selected.length; ++i) {
                selectionDistance[i] = UVMappingViewer.this.selected[i] ? 0 : -1;
            }
            return selectionDistance;
        }

        public double getMeshTension() {
            return 1.0;
        }

        public int getTensionDistance() {
            return 0;
        }
    }

    private static class UVMesh
    extends Object3D
    implements Mesh {
        public MeshVertex[] vert;

        public UVMesh() {
            this.vert = new MeshVertex[0];
        }

        public UVMesh(Vec2[] uv) {
            this.vert = new MeshVertex[uv.length];
            for (int i = 0; i < this.vert.length; ++i) {
                this.vert[i] = new MeshVertex(new Vec3(uv[i].x, uv[i].y, 0.0));
            }
        }

        public Object3D duplicate() {
            Vec2[] uv = new Vec2[this.vert.length];
            for (int i = 0; i < this.vert.length; ++i) {
                uv[i] = new Vec2(this.vert[i].r.x, this.vert[i].r.y);
            }
            return new UVMesh(uv);
        }

        public void copyObject(Object3D obj) {
            UVMesh mesh = (UVMesh)obj;
            this.vert = new MeshVertex[mesh.vert.length];
            for (int i = 0; i < mesh.vert.length; ++i) {
                this.vert[i] = new MeshVertex(new Vec3(mesh.vert[i].r));
            }
        }

        public MeshVertex[] getVertices() {
            return this.vert;
        }

        public Vec3[] getVertexPositions() {
            Vec3[] v = new Vec3[this.vert.length];
            for (int i = 0; i < v.length; ++i) {
                v[i] = new Vec3(this.vert[i].r);
            }
            return v;
        }

        public void setVertexPositions(Vec3[] v) {
            this.vert = new MeshVertex[v.length];
            for (int i = 0; i < v.length; ++i) {
                this.vert[i] = new MeshVertex(v[i]);
            }
        }

        public void setVertices(Vec2[] v) {
            this.vert = new MeshVertex[v.length];
            for (int i = 0; i < v.length; ++i) {
                this.vert[i] = new MeshVertex(new Vec3(v[i].x, v[i].y, 0.0));
            }
        }

        public BoundingBox getBounds() {
            return null;
        }

        public void setSize(double xsize, double ysize, double zsize) {
        }

        public WireframeMesh getWireframeMesh() {
            return null;
        }

        public Keyframe getPoseKeyframe() {
            return null;
        }

        public void applyPoseKeyframe(Keyframe k) {
        }

        public Vec3[] getNormals() {
            return null;
        }

        public Skeleton getSkeleton() {
            return null;
        }

        public void setSkeleton(Skeleton s) {
        }

        public MeshViewer createMeshViewer(MeshEditController controller, RowContainer options) {
            return null;
        }
    }
}

