/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.TextureMappingDialog;
import artofillusion.TextureParameter;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.FacetedMesh;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectWrapper;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.Texture2D;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UVMappedTriangle;
import artofillusion.texture.UVMappingWindow;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.FormContainer;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class UVMapping
extends Mapping2D {
    int numTextureParams;
    TextureParameter uparam;
    TextureParameter vparam;

    public UVMapping(Object3D theObject, Texture theTexture) {
        super(theObject, theTexture);
    }

    public static String getName() {
        return "UV";
    }

    public TextureParameter getUParameter() {
        if (this.uparam == null) {
            this.getParameters();
        }
        return this.uparam;
    }

    public TextureParameter getVParameter() {
        if (this.vparam == null) {
            this.getParameters();
        }
        return this.vparam;
    }

    public static boolean legalMapping(Object3D obj, Texture tex) {
        while (obj instanceof ObjectWrapper) {
            obj = ((ObjectWrapper)obj).getWrappedObject();
        }
        return tex instanceof Texture2D && obj instanceof Mesh;
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        return new UVMappedTriangle(v1, v2, v3, n1, n2, n3);
    }

    public void setParameters(RenderingTriangle tri, double[] p1, double[] p2, double[] p3, RenderingMesh mesh) {
        UVMappedTriangle uv = (UVMappedTriangle)tri;
        uv.setTextureCoordinates((float)p1[this.numTextureParams], (float)p1[this.numTextureParams + 1], (float)p2[this.numTextureParams], (float)p2[this.numTextureParams + 1], (float)p3[this.numTextureParams], (float)p3[this.numTextureParams + 1], mesh.vert[uv.v1], mesh.vert[uv.v2], mesh.vert[uv.v3]);
    }

    public void getTextureSpec(Vec3 pos, TextureSpec spec, double angle, double size, double time, double[] param) {
        if (!this.appliesToFace(angle > 0.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        this.texture.getTextureSpec(spec, pos.x, pos.y, size, size, angle, time, param);
        if (this.texture.hasComponent(5)) {
            double s = spec.bumpGrad.x;
            double t = spec.bumpGrad.y;
            spec.bumpGrad.set(s, t, 0.0);
        }
    }

    public void getTransparency(Vec3 pos, RGBColor trans, double angle, double size, double time, double[] param) {
        if (!this.appliesToFace(angle > 0.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
        } else {
            this.texture.getTransparency(trans, pos.x, pos.y, size, size, angle, time, param);
        }
    }

    public double getDisplacement(Vec3 pos, double size, double time, double[] param) {
        return this.texture.getDisplacement(pos.x, pos.y, size, size, time, param);
    }

    public Vec2[] findTextureCoordinates(Mesh mesh) {
        TextureParameter[] param = mesh.getParameters();
        ParameterValue[] values = mesh.getParameterValues();
        if (mesh instanceof FacetedMesh && this.isPerFaceVertex((FacetedMesh)mesh)) {
            FacetedMesh fm = (FacetedMesh)mesh;
            FaceVertexParameterValue uval = null;
            FaceVertexParameterValue vval = null;
            for (int i = 0; i < param.length; ++i) {
                if (param[i].equals(this.uparam)) {
                    uval = (FaceVertexParameterValue)values[i];
                    continue;
                }
                if (!param[i].equals(this.vparam)) continue;
                vval = (FaceVertexParameterValue)values[i];
            }
            Vec2[] uv = new Vec2[mesh.getVertices().length];
            for (int i = 0; i < fm.getFaceCount(); ++i) {
                for (int j = 0; j < fm.getFaceVertexCount(i); ++j) {
                    uv[fm.getFaceVertexIndex((int)i, (int)j)] = new Vec2(uval.getValue(i, j), vval.getValue(i, j));
                }
            }
            return uv;
        }
        double[] uval = null;
        double[] vval = null;
        for (int i = 0; i < param.length; ++i) {
            if (param[i].equals(this.uparam)) {
                uval = ((VertexParameterValue)values[i]).getValue();
                continue;
            }
            if (!param[i].equals(this.vparam)) continue;
            vval = ((VertexParameterValue)values[i]).getValue();
        }
        Vec2[] uv = new Vec2[uval.length];
        for (int i = 0; i < uv.length; ++i) {
            uv[i] = new Vec2(uval[i], vval[i]);
        }
        return uv;
    }

    public Vec2[][] findFaceTextureCoordinates(FacetedMesh mesh) {
        int faces = mesh.getFaceCount();
        TextureParameter[] param = mesh.getParameters();
        ParameterValue[] values = mesh.getParameterValues();
        FaceVertexParameterValue uval = null;
        FaceVertexParameterValue vval = null;
        for (int i = 0; i < param.length; ++i) {
            if (param[i].equals(this.uparam)) {
                uval = (FaceVertexParameterValue)values[i];
                continue;
            }
            if (!param[i].equals(this.vparam)) continue;
            vval = (FaceVertexParameterValue)values[i];
        }
        Vec2[][] uv = new Vec2[faces][];
        for (int i = 0; i < faces; ++i) {
            uv[i] = new Vec2[mesh.getFaceVertexCount(i)];
            for (int j = 0; j < uv[i].length; ++j) {
                uv[i][j] = new Vec2(uval.getValue(i, j), vval.getValue(i, j));
            }
        }
        return uv;
    }

    public void setTextureCoordinates(Object3D obj, Vec2[] uv) {
        this.setTextureCoordinates(obj, uv, this.uparam, this.vparam);
    }

    public void setTextureCoordinates(Object3D obj, Vec2[] uv, TextureParameter uParameter, TextureParameter vParameter) {
        double[] uval = new double[uv.length];
        double[] vval = new double[uv.length];
        for (int i = 0; i < uv.length; ++i) {
            uval[i] = uv[i].x;
            vval[i] = uv[i].y;
        }
        obj.setParameterValue(uParameter, new VertexParameterValue(uval));
        obj.setParameterValue(vParameter, new VertexParameterValue(vval));
    }

    public void setFaceTextureCoordinates(Object3D obj, Vec2[][] uv) {
        this.setFaceTextureCoordinates(obj, uv, this.uparam, this.vparam);
    }

    public void setFaceTextureCoordinates(Object3D obj, Vec2[][] uv, TextureParameter uParameter, TextureParameter vParameter) {
        while (obj instanceof ObjectWrapper) {
            obj = ((ObjectWrapper)obj).getWrappedObject();
        }
        FacetedMesh mesh = (FacetedMesh)((Object)obj);
        int faces = mesh.getFaceCount();
        double[][] uval = new double[faces][];
        double[][] vval = new double[faces][];
        for (int i = 0; i < faces; ++i) {
            uval[i] = new double[uv[i].length];
            vval[i] = new double[uv[i].length];
            for (int j = 0; j < uval[i].length; ++j) {
                uval[i][j] = uv[i][j].x;
                vval[i][j] = uv[i][j].y;
            }
        }
        obj.setParameterValue(this.uparam, new FaceVertexParameterValue(uval));
        obj.setParameterValue(this.vparam, new FaceVertexParameterValue(vval));
    }

    public boolean isPerFaceVertex(FacetedMesh mesh) {
        TextureParameter[] param = mesh.getParameters();
        for (int i = 0; i < param.length; ++i) {
            if (!param[i].equals(this.uparam) && !param[i].equals(this.vparam)) continue;
            return mesh.getParameterValues()[i] instanceof FaceVertexParameterValue;
        }
        return false;
    }

    public TextureMapping duplicate() {
        return this.duplicate(this.object, this.texture);
    }

    public TextureMapping duplicate(Object3D obj, Texture tex) {
        UVMapping map = new UVMapping(obj, tex);
        map.numTextureParams = this.numTextureParams;
        map.uparam = this.uparam;
        map.vparam = this.vparam;
        return map;
    }

    public void copy(TextureMapping mapping) {
        UVMapping map = (UVMapping)mapping;
        this.numTextureParams = map.numTextureParams;
        this.uparam = map.uparam;
        this.vparam = map.vparam;
    }

    public TextureParameter[] getParameters() {
        TextureParameter[] tp = this.getTexture().getParameters();
        this.numTextureParams = tp.length;
        TextureParameter[] p = new TextureParameter[this.numTextureParams + 2];
        System.arraycopy(tp, 0, p, 0, this.numTextureParams);
        if (this.uparam == null) {
            this.uparam = new TextureParameter(this, "U", -1.7976931348623157E308, Double.MAX_VALUE, 0.0);
            this.vparam = new TextureParameter(this, "V", -1.7976931348623157E308, Double.MAX_VALUE, 0.0);
            this.uparam.type = 1;
            this.vparam.type = 2;
        }
        p[this.numTextureParams] = this.uparam;
        p[this.numTextureParams + 1] = this.vparam;
        return p;
    }

    public Widget getEditingPanel(Object3D obj, MaterialPreviewer preview) {
        return new Editor(obj, preview);
    }

    public UVMapping(DataInputStream in, Object3D theObject, Texture theTexture) throws IOException, InvalidObjectException {
        super(theObject, theTexture);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.setAppliesTo(in.readShort());
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(0);
        out.writeShort(this.appliesTo());
    }

    class Editor
    extends FormContainer {
        BComboBox applyToChoice;
        Object3D theObject;
        MaterialPreviewer preview;

        public Editor(Object3D obj, MaterialPreviewer preview) {
            super(1, 2);
            this.theObject = obj;
            this.preview = preview;
            this.add(Translate.button("editUVCoords", this, "doEdit"), 0, 0);
            RowContainer applyRow = new RowContainer();
            applyRow.add(new BLabel(Translate.text("applyTo") + ":"));
            this.applyToChoice = new BComboBox(new String[]{Translate.text("frontAndBackFaces"), Translate.text("frontFacesOnly"), Translate.text("backFacesOnly")});
            applyRow.add(this.applyToChoice);
            this.add(applyRow, 0, 1);
            this.applyToChoice.setSelectedIndex(UVMapping.this.appliesTo());
            this.applyToChoice.addEventLink(ValueChangedEvent.class, (Object)this, "applyToChanged");
        }

        private void doEdit() {
            WidgetContainer parent;
            new UVMappingWindow((BDialog)UIUtilities.findWindow(this), this.theObject, UVMapping.this);
            for (parent = this.getParent(); !(parent instanceof TextureMappingDialog) && parent != null; parent = parent.getParent()) {
            }
            if (parent != null) {
                ((TextureMappingDialog)parent).setPreviewMapping(UVMapping.this);
            }
            this.preview.render();
        }

        private void applyToChanged() {
            UVMapping.this.setAppliesTo((short)this.applyToChoice.getSelectedIndex());
            this.preview.setTexture(UVMapping.this.getTexture(), UVMapping.this);
            this.preview.render();
        }
    }
}

