/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.ViewerCanvas;
import artofillusion.texture.UVMappingViewer;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Point;
import java.awt.Rectangle;

public class MoveUVViewTool
extends EditingTool {
    private Point clickPoint;
    private boolean controlDown;
    private double minu;
    private double maxu;
    private double minv;
    private double maxv;
    private int vwidth;
    private int vheight;

    public MoveUVViewTool(EditingWindow fr) {
        super(fr);
        this.initButton("moveView");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("moveViewTool.helpText"));
    }

    public int whichClicks() {
        return 1;
    }

    public boolean hilightSelection() {
        return true;
    }

    public String getToolTipText() {
        return Translate.text("moveViewTool.tipText");
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        UVMappingViewer uvview = (UVMappingViewer)view;
        this.controlDown = e.isControlDown();
        this.clickPoint = e.getPoint();
        this.minu = uvview.getMinU();
        this.maxu = uvview.getMaxU();
        this.minv = uvview.getMinV();
        this.maxv = uvview.getMaxV();
        Rectangle d = uvview.getBounds();
        this.vwidth = d.width;
        this.vheight = d.height;
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        Point dragPoint = e.getPoint();
        UVMappingViewer uvview = (UVMappingViewer)view;
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (this.controlDown) {
            double factor = Math.pow(1.01, dy);
            double midu = (this.minu + this.maxu) / 2.0;
            double midv = (this.minv + this.maxv) / 2.0;
            double newminu = (this.minu - midu) / factor + midu;
            double newmaxu = (this.maxu - midu) / factor + midu;
            double newminv = (this.minv - midv) / factor + midv;
            double newmaxv = (this.maxv - midv) / factor + midv;
            uvview.setParameters(newminu, newmaxu, newminv, newmaxv);
        } else {
            if (e.isShiftDown()) {
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0;
                } else {
                    dx = 0;
                }
            }
            double du = (this.minu - this.maxu) * (double)dx / (double)this.vwidth;
            double dv = (this.maxv - this.minv) * (double)dy / (double)this.vheight;
            uvview.setParameters(this.minu + du, this.maxu + du, this.minv + dv, this.maxv + dv);
        }
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        this.mouseDragged(e, view);
        this.theWindow.updateImage();
    }
}

