/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.ArtOfIllusion;
import artofillusion.object.ObjectInfo;
import artofillusion.script.ScriptEditor;
import artofillusion.script.ScriptedObject;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.FocusLostEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BDialog;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BList;
import buoy.widget.BOutline;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextField;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class ScriptedObjectEditorWindow
extends BFrame {
    private EditingWindow window;
    private ObjectInfo info;
    private ScriptEditor scriptText;
    private String scriptName;
    private Runnable onClose;
    private static File scriptDir;

    public ScriptedObjectEditorWindow(EditingWindow parent, ObjectInfo obj, Runnable onClose) {
        super("Script '" + obj.getName() + "'");
        this.window = parent;
        this.info = obj;
        this.onClose = onClose;
        this.scriptName = "Untitled.bsh";
        if (scriptDir == null) {
            scriptDir = new File(ArtOfIllusion.OBJECT_SCRIPT_DIRECTORY);
        }
        BorderContainer content = new BorderContainer();
        this.setContent(content);
        this.scriptText = new ScriptEditor(((ScriptedObject)this.info.getObject()).getScript());
        content.add(BOutline.createBevelBorder(this.scriptText.createContainer(), false), BorderContainer.CENTER);
        RowContainer buttons = new RowContainer();
        content.add(buttons, BorderContainer.SOUTH, new LayoutInfo());
        buttons.add(Translate.button("ok", this, "commitChanges"));
        buttons.add(Translate.button("Load", "...", this, "loadScript"));
        buttons.add(Translate.button("Save", "...", this, "saveScript"));
        buttons.add(Translate.button("scriptParameters", this, "editParameters"));
        buttons.add(Translate.button("cancel", this, "dispose"));
        this.addEventLink(WindowClosingEvent.class, (Object)this, "commitChanges");
        this.scriptText.setCaretPosition(0);
        this.pack();
        UIUtilities.centerWindow(this);
        this.setVisible(true);
    }

    private void editParameters() {
        new ParametersDialog();
    }

    private void loadScript() {
        BFileChooser fc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("selectScriptToLoad"));
        fc.setDirectory(scriptDir);
        fc.showDialog(this);
        if (fc.getSelectedFile() == null) {
            return;
        }
        scriptDir = fc.getDirectory();
        this.setCursor(Cursor.getPredefinedCursor(3));
        File f = fc.getSelectedFile();
        try {
            int c;
            BufferedReader in = new BufferedReader(new FileReader(f));
            StringBuffer buf = new StringBuffer();
            while ((c = in.read()) != -1) {
                buf.append((char)c);
            }
            in.close();
            this.scriptText.setText(buf.toString());
        }
        catch (Exception ex) {
            new BStandardDialog(null, new String[]{Translate.text("errorReadingScript"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
        }
        this.scriptName = fc.getSelectedFile().getName();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void saveScript() {
        BFileChooser fc = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text("saveScriptToFile"));
        fc.setDirectory(scriptDir);
        fc.setSelectedFile(new File(scriptDir, this.scriptName));
        fc.showDialog(this);
        if (fc.getSelectedFile() == null) {
            return;
        }
        scriptDir = fc.getDirectory();
        this.setCursor(Cursor.getPredefinedCursor(3));
        File f = fc.getSelectedFile();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write(this.scriptText.getText().toCharArray());
            out.close();
        }
        catch (Exception ex) {
            new BStandardDialog(null, new String[]{Translate.text("errorWritingScript"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
        }
        this.scriptName = fc.getSelectedFile().getName();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void commitChanges() {
        ScriptedObject so = (ScriptedObject)this.info.getObject();
        this.setCursor(Cursor.getPredefinedCursor(3));
        so.setScript(this.scriptText.getText());
        so.sceneChanged(this.info, this.window.getScene());
        if (this.onClose != null) {
            this.onClose.run();
        }
        this.window.updateImage();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.dispose();
    }

    private class ParametersDialog
    extends BDialog {
        private ScriptedObject script;
        private BList paramList;
        private BTextField nameField;
        private ValueField valueField;
        private String[] name;
        private double[] value;
        private int current;

        public ParametersDialog() {
            super(ScriptedObjectEditorWindow.this, Translate.text("objectParameters"), true);
            this.script = (ScriptedObject)ScriptedObjectEditorWindow.this.info.getObject();
            FormContainer content = new FormContainer(new double[]{0.0, 1.0}, new double[]{1.0, 0.0, 0.0, 0.0});
            content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, null, null));
            this.setContent(content);
            this.name = new String[this.script.getNumParameters()];
            this.value = new double[this.script.getNumParameters()];
            for (int i = 0; i < this.name.length; ++i) {
                this.name[i] = this.script.getParameterName(i);
                this.value[i] = this.script.getParameterValue(i);
            }
            this.paramList = new BList();
            content.add(UIUtilities.createScrollingList(this.paramList), 0, 0, 2, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
            this.paramList.setPreferredVisibleRows(5);
            this.buildParameterList();
            this.paramList.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
            content.add(Translate.label("Name"), 0, 1);
            content.add(Translate.label("Value"), 0, 2);
            this.nameField = new BTextField();
            content.add(this.nameField, 1, 1);
            this.nameField.addEventLink(ValueChangedEvent.class, (Object)this, "textChanged");
            this.nameField.addEventLink(FocusLostEvent.class, (Object)this, "focusLost");
            this.valueField = new ValueField(0.0, 0);
            content.add(this.valueField, 1, 2);
            this.valueField.addEventLink(ValueChangedEvent.class, (Object)this, "textChanged");
            RowContainer buttons = new RowContainer();
            content.add(buttons, 0, 3, 2, 1, new LayoutInfo());
            buttons.add(Translate.button("add", this, "doAdd"));
            buttons.add(Translate.button("remove", this, "doRemove"));
            buttons.add(Translate.button("ok", this, "doOk"));
            buttons.add(Translate.button("cancel", this, "dispose"));
            this.setSelectedParameter(this.name.length == 0 ? -1 : 0);
            this.pack();
            UIUtilities.centerDialog(this, ScriptedObjectEditorWindow.this);
            this.setVisible(true);
        }

        private void buildParameterList() {
            this.paramList.removeAll();
            for (int i = 0; i < this.name.length; ++i) {
                this.paramList.add(this.name[i]);
            }
            if (this.name.length == 0) {
                this.paramList.add("(no parameters)");
            }
        }

        private void setSelectedParameter(int which) {
            if (which != this.paramList.getSelectedIndex()) {
                this.paramList.clearSelection();
                this.paramList.setSelected(which, true);
            }
            this.current = which;
            if (which == -1 || which >= this.name.length) {
                this.nameField.setEnabled(false);
                this.valueField.setEnabled(false);
            } else {
                this.nameField.setEnabled(true);
                this.valueField.setEnabled(true);
                this.nameField.setText(this.name[which]);
                this.valueField.setValue(this.value[which]);
            }
        }

        private void textChanged(ValueChangedEvent ev) {
            if (this.current < 0 || this.current > this.name.length) {
                return;
            }
            if (ev.getWidget() == this.nameField) {
                this.name[this.current] = this.nameField.getText();
            } else {
                this.value[this.current] = this.valueField.getValue();
            }
        }

        private void focusLost() {
            this.paramList.replace(this.current, this.name[this.current]);
        }

        private void selectionChanged() {
            this.setSelectedParameter(this.paramList.getSelectedIndex());
        }

        private void doAdd() {
            String[] newName = new String[this.name.length + 1];
            double[] newValue = new double[this.value.length + 1];
            System.arraycopy(this.name, 0, newName, 0, this.name.length);
            System.arraycopy(this.value, 0, newValue, 0, this.value.length);
            newName[this.name.length] = "";
            newValue[this.value.length] = 0.0;
            this.name = newName;
            this.value = newValue;
            this.buildParameterList();
            this.setSelectedParameter(this.name.length - 1);
            this.nameField.requestFocus();
        }

        private void doRemove() {
            int which = this.paramList.getSelectedIndex();
            String[] newName = new String[this.name.length - 1];
            double[] newValue = new double[this.value.length - 1];
            int j = 0;
            for (int i = 0; i < this.name.length; ++i) {
                if (i == which) continue;
                newName[j] = this.name[i];
                newValue[j] = this.value[i];
                ++j;
            }
            this.name = newName;
            this.value = newValue;
            this.buildParameterList();
            this.setSelectedParameter(-1);
        }

        private void doOk() {
            this.script.setParameters(this.name, this.value);
            this.dispose();
        }
    }
}

