/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.Widget;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ViewAngleModule
extends Module {
    private boolean abs;
    private PointInfo point;

    public ViewAngleModule(Point position) {
        super(Translate.text("menu.viewAngleModule"), new IOPort[0], new IOPort[]{new IOPort(0, 1, 3, new String[]{Translate.text("menu.viewAngleModule")})}, position);
    }

    public void init(PointInfo p) {
        this.point = p;
    }

    public double getAverageValue(int which, double blur) {
        if (this.abs && this.point.viewangle < 0.0) {
            return -this.point.viewangle;
        }
        return this.point.viewangle;
    }

    public double getValueError(int which, double blur) {
        return 0.0;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        grad.set(0.0, 0.0, 0.0);
    }

    public Module duplicate() {
        ViewAngleModule mod = new ViewAngleModule(new Point(this.bounds.x, this.bounds.y));
        mod.abs = this.abs;
        mod.layout();
        return mod;
    }

    public boolean edit(final ProcedureEditor editor, Scene theScene) {
        final BCheckBox absBox = new BCheckBox(Translate.text("outputAbsValue"), this.abs);
        absBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                ViewAngleModule.this.abs = absBox.getState();
                editor.updatePreview();
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), Translate.text("selectOutputProperties"), new Widget[]{absBox}, new String[]{null});
        return dlg.clickedOk();
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeBoolean(this.abs);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.abs = in.readBoolean();
    }
}

