/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.BLabel;
import buoy.widget.RowContainer;
import buoy.widget.WindowWidget;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ScaleShiftModule
extends Module {
    private double scale = 1.0;
    private double shift = 0.0;

    public ScaleShiftModule(Point position) {
        super("\u00d7 1.0 + 0.0", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Input", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Output"})}, position);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double val) {
        this.scale = val;
    }

    public double getShift() {
        return this.shift;
    }

    public void setShift(double val) {
        this.shift = val;
    }

    public double getAverageValue(int which, double blur) {
        if (this.linkFrom[0] == null) {
            return this.shift;
        }
        return this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur) * this.scale + this.shift;
    }

    public double getValueError(int which, double blur) {
        if (this.linkFrom[0] == null) {
            return 0.0;
        }
        return this.linkFrom[0].getValueError(this.linkFromIndex[0], blur) * Math.abs(this.scale);
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.linkFrom[0] == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
        grad.set(grad.x * this.scale + this.shift, grad.y * this.scale + this.shift, grad.z * this.scale + this.shift);
    }

    public boolean edit(final ProcedureEditor editor, Scene theScene) {
        final ValueField scaleField = new ValueField(this.scale, 0, 5);
        final ValueField shiftField = new ValueField(this.shift, 0, 5);
        Object listener = new Object(){

            void processEvent() {
                ScaleShiftModule.this.scale = scaleField.getValue();
                ScaleShiftModule.this.shift = shiftField.getValue();
                editor.updatePreview();
            }
        };
        scaleField.addEventLink(ValueChangedEvent.class, listener);
        shiftField.addEventLink(ValueChangedEvent.class, listener);
        RowContainer row = new RowContainer();
        row.add(new BLabel(Translate.text("scaleShiftEquation")));
        row.add(scaleField);
        row.add(new BLabel(" + "));
        row.add(shiftField);
        PanelDialog dlg = new PanelDialog((WindowWidget)editor.getParentFrame(), Translate.text("selectScaleShiftProperties"), row);
        if (!dlg.clickedOk()) {
            return false;
        }
        this.scale = scaleField.getValue();
        this.shift = shiftField.getValue();
        this.name = "\u00d7 " + this.scale + " + " + this.shift;
        this.layout();
        return true;
    }

    public Module duplicate() {
        ScaleShiftModule mod = new ScaleShiftModule(new Point(this.bounds.x, this.bounds.y));
        mod.scale = this.scale;
        mod.shift = this.shift;
        mod.name = this.name;
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(this.scale);
        out.writeDouble(this.shift);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.scale = in.readDouble();
        this.shift = in.readDouble();
        this.name = "\u00d7 " + this.scale + " + " + this.shift;
        this.layout();
    }
}

