/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.ArtOfIllusion;
import artofillusion.Scene;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.ImageModule;
import artofillusion.procedural.InfoBox;
import artofillusion.procedural.Link;
import artofillusion.procedural.Module;
import artofillusion.procedural.ModuleMenu;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.ui.AutoScroller;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.BMenuItem;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextField;
import buoy.widget.BorderContainer;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class ProcedureEditor
extends CustomWidget {
    private BFrame parent;
    private Procedure proc;
    private ProcedureOwner owner;
    private Scene theScene;
    private EditingWindow win;
    private Dimension size;
    private ModuleMenu moduleMenu;
    private BMenuItem undoItem;
    private BMenuItem redoItem;
    private BMenuItem cutItem;
    private BMenuItem copyItem;
    private BMenuItem pasteItem;
    private BMenuItem clearItem;
    private BTextField nameField;
    private boolean[] selectedModule;
    private boolean[] selectedLink;
    private boolean draggingLink;
    private boolean draggingModule;
    private boolean draggingBox;
    private Point clickPos;
    private Point lastPos;
    private InfoBox inputInfo;
    private InfoBox outputInfo;
    private IOPort dragFromPort;
    private IOPort dragToPort;
    private BScrollPane scroll;
    private Object preview;
    private ByteArrayOutputStream cancelBuffer;
    private ArrayList<ByteArrayOutputStream> undoStack;
    private ArrayList<ByteArrayOutputStream> redoStack;
    private final Color darkLinkColor = Color.darkGray;
    private final Color blueLinkColor = new Color(40, 40, 255);
    private final Color selectedLinkColor = new Color(255, 50, 50);
    private final Color outputBackgroundColor = new Color(210, 210, 240);
    private static final float BEZIER_HARDNESS = 0.5f;
    private static final Stroke normal = new BasicStroke();
    private static final Stroke bold = new BasicStroke(1.5f, 1, 1);
    private static ClipboardSelection clipboard;

    public ProcedureEditor(Procedure proc, ProcedureOwner owner, Scene scene) {
        int i;
        this.proc = proc;
        this.owner = owner;
        this.theScene = scene;
        this.selectedModule = new boolean[proc.getModules().length];
        this.selectedLink = new boolean[proc.getLinks().length];
        this.inputInfo = new InfoBox();
        this.outputInfo = new InfoBox();
        this.cancelBuffer = new ByteArrayOutputStream();
        this.undoStack = new ArrayList();
        this.redoStack = new ArrayList();
        this.parent = new BFrame(owner.getWindowTitle());
        BorderContainer content = new BorderContainer();
        this.parent.setContent(content);
        this.scroll = new BScrollPane(this);
        content.add(this.scroll, BorderContainer.CENTER);
        this.scroll.setPreferredViewSize(new Dimension(600, 600));
        new AutoScroller(this.scroll, 5, 5);
        this.size = new Dimension(1000, 1000);
        this.setBackground(Color.white);
        this.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
        DataOutputStream out = new DataOutputStream(this.cancelBuffer);
        try {
            proc.writeToStream(out, this.theScene);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        FormContainer top = new FormContainer(new double[]{0.0, 0.0, 1.0, 0.0, 0.0}, new double[]{1.0});
        top.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(0, 0, 0, 5), null));
        top.add(Translate.button("properties", this, "actionPerformed"), 0, 0);
        if (owner.canEditName()) {
            top.add(new BLabel(Translate.text("Name") + ':'), 1, 0);
            this.nameField = new BTextField(owner.getName());
            top.add(this.nameField, 2, 0);
        }
        top.add(Translate.button("ok", this, "doOk"), 3, 0);
        top.add(Translate.button("cancel", this, "actionPerformed"), 4, 0);
        this.parent.addEventLink(WindowClosingEvent.class, (Object)this, "doOk");
        content.add(top, BorderContainer.NORTH);
        this.moduleMenu = new ModuleMenu(this);
        content.add(this.moduleMenu, BorderContainer.WEST);
        OutputModule[] output = proc.getOutputModules();
        int widest = 0;
        for (i = 0; i < output.length; ++i) {
            output[i].calcSize();
            if (output[i].getBounds().width <= widest) continue;
            widest = output[i].getBounds().width;
        }
        int x = this.size.width - widest;
        int y = 15;
        for (i = 0; i < output.length; ++i) {
            output[i].setWidth(widest);
            output[i].setPosition(x - 15, y);
            y += output[i].getBounds().height + 15;
        }
        BMenuBar mb = new BMenuBar();
        this.parent.setMenuBar(mb);
        mb.add(this.getEditMenu());
        this.updateMenus();
        this.parent.pack();
        this.scroll.getHorizontalScrollBar().setBlockIncrement(100);
        this.scroll.getVerticalScrollBar().setBlockIncrement(100);
        this.scroll.getHorizontalScrollBar().setUnitIncrement(10);
        this.scroll.getVerticalScrollBar().setUnitIncrement(10);
        this.parent.setVisible(true);
        this.scroll.getHorizontalScrollBar().setValue(this.getBounds().width - this.scroll.getViewSize().width);
        this.preview = owner.getPreview(this);
    }

    private BMenu getEditMenu() {
        BMenu editMenu = Translate.menu("edit");
        this.undoItem = Translate.menuItem("undo", this, "undo");
        editMenu.add(this.undoItem);
        this.redoItem = Translate.menuItem("redo", this, "redo");
        editMenu.add(this.redoItem);
        this.undoItem.setEnabled(false);
        this.redoItem.setEnabled(false);
        editMenu.addSeparator();
        this.cutItem = Translate.menuItem("cut", this, "actionPerformed");
        editMenu.add(this.cutItem);
        this.copyItem = Translate.menuItem("copy", this, "actionPerformed");
        editMenu.add(this.copyItem);
        this.pasteItem = Translate.menuItem("paste", this, "actionPerformed");
        editMenu.add(this.pasteItem);
        this.clearItem = Translate.menuItem("clear", this, "actionPerformed");
        editMenu.add(this.clearItem);
        editMenu.addSeparator();
        editMenu.add(Translate.menuItem("properties", this, "actionPerformed"));
        return editMenu;
    }

    public BFrame getParentFrame() {
        return this.parent;
    }

    public ProcedureOwner getOwner() {
        return this.owner;
    }

    public Scene getScene() {
        return this.theScene;
    }

    public void setEditingWindow(EditingWindow window) {
        this.win = window;
    }

    public EditingWindow getEditingWindow() {
        return this.win;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    private void paint(RepaintEvent ev) {
        this.paint(ev.getGraphics());
    }

    private void paint(Graphics2D g) {
        int i;
        OutputModule[] output = this.proc.getOutputModules();
        Module[] module = this.proc.getModules();
        Link[] link = this.proc.getLinks();
        int divider = output[0].getBounds().x - 5;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.outputBackgroundColor);
        g.fillRoundRect(divider, 5, this.size.width - divider - 10, this.size.height - 10, 8, 8);
        for (OutputModule mod : output) {
            mod.draw(g, false);
        }
        for (i = 0; i < module.length; ++i) {
            module[i].draw(g, this.selectedModule[i]);
        }
        g.setStroke(bold);
        for (i = 0; i < link.length; ++i) {
            if (this.selectedLink[i]) continue;
            g.setColor(link[i].from.getValueType() == 0 ? this.darkLinkColor : this.blueLinkColor);
            g.draw(this.createBezierCurve(link[i]));
        }
        g.setColor(this.selectedLinkColor);
        for (i = 0; i < link.length; ++i) {
            if (!this.selectedLink[i]) continue;
            g.draw(this.createBezierCurve(link[i]));
        }
        g.setStroke(normal);
        if (this.draggingLink) {
            boolean isInput;
            boolean bl = isInput = this.dragFromPort.getType() == 0;
            if (isInput || this.dragToPort != null) {
                this.inputInfo.draw(g);
            }
            if (!isInput || this.dragToPort != null) {
                this.outputInfo.draw(g);
            }
        }
        g.setColor(Color.BLACK);
        if (this.draggingBox && this.lastPos != null) {
            Rectangle rect = this.getRectangle(this.clickPos, this.lastPos);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.draggingLink && this.lastPos != null) {
            if (this.dragToPort == null) {
                g.drawLine(this.clickPos.x, this.clickPos.y, this.lastPos.x, this.lastPos.y);
            } else {
                Point pos = this.dragToPort.getPosition();
                g.drawLine(this.clickPos.x, this.clickPos.y, pos.x, pos.y);
            }
        }
    }

    private Shape createBezierCurve(Link link) {
        float ctrly2;
        float ctrlx2;
        float ctrly1;
        float ctrlx1;
        int x1 = link.from.getPosition().x;
        int y1 = link.from.getPosition().y;
        int x2 = link.to.getPosition().x;
        int y2 = link.to.getPosition().y;
        if (link.from.getLocation() == 2 || link.from.getLocation() == 3) {
            ctrlx1 = (float)(x2 - x1) * 0.5f + (float)x1;
            ctrly1 = y1;
        } else {
            ctrlx1 = x1;
            ctrly1 = (float)(y2 - y1) * 0.5f + (float)y1;
        }
        if (link.to.getLocation() == 2 || link.to.getLocation() == 3) {
            ctrlx2 = 0.5f * (float)(x2 - x1) + (float)x1;
            ctrly2 = y2;
        } else {
            ctrlx2 = x2;
            ctrly2 = 0.5f * (float)(y2 - y1) + (float)y1;
        }
        return new CubicCurve2D.Float(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
    }

    private void updateMenus() {
        boolean anyModule = false;
        boolean anyLink = false;
        for (boolean selected : this.selectedModule) {
            if (!selected) continue;
            anyModule = true;
        }
        for (boolean selected : this.selectedLink) {
            if (!selected) continue;
            anyLink = true;
        }
        this.cutItem.setEnabled(anyModule);
        this.copyItem.setEnabled(anyModule);
        this.pasteItem.setEnabled(clipboard != null);
        this.clearItem.setEnabled(anyModule || anyLink);
    }

    private void actionPerformed(CommandEvent e) {
        String command = e.getActionCommand();
        Point p = new Point(this.scroll.getHorizontalScrollBar().getValue(), this.scroll.getVerticalScrollBar().getValue());
        Rectangle bounds = this.scroll.getBounds();
        p.x += (int)(0.5 * (double)bounds.width * Math.random());
        p.y += (int)(0.5 * (double)bounds.height * Math.random());
        if (command.equals("cancel")) {
            this.undoStack.add(this.cancelBuffer);
            this.undo();
            this.owner.disposePreview(this.preview);
            this.parent.dispose();
        } else if (command.equals("cut")) {
            clipboard = new ClipboardSelection(this.proc, this.selectedModule, this.selectedLink);
            this.deleteSelection();
            this.updateMenus();
        } else if (command.equals("copy")) {
            clipboard = new ClipboardSelection(this.proc, this.selectedModule, this.selectedLink);
            this.updateMenus();
        } else if (command.equals("paste") && clipboard != null) {
            this.saveState(false);
            clipboard.paste(this);
            this.repaint();
        } else if (command.equals("clear")) {
            this.deleteSelection();
        } else if (command.equals("properties")) {
            this.owner.editProperties(this);
            this.updatePreview();
        }
    }

    private void doOk() {
        if (this.owner.canEditName()) {
            this.owner.setName(this.nameField.getText());
        }
        this.owner.acceptEdits(this);
        this.owner.disposePreview(this.preview);
        this.parent.dispose();
    }

    public void addModule(Module mod) {
        this.selectedModule = new boolean[this.selectedModule.length + 1];
        this.selectedModule[this.selectedModule.length - 1] = true;
        for (int i = 0; i < this.selectedLink.length; ++i) {
            this.selectedLink[i] = false;
        }
        this.proc.addModule(mod);
        this.updateMenus();
    }

    private void addLink(IOPort port1, IOPort port2) {
        IOPort to;
        IOPort from;
        this.selectedLink = new boolean[this.selectedLink.length + 1];
        this.selectedLink[this.selectedLink.length - 1] = true;
        for (int i = 0; i < this.selectedModule.length; ++i) {
            this.selectedModule[i] = false;
        }
        if (port1.getType() == 1) {
            from = port1;
            to = port2;
        } else {
            from = port2;
            to = port1;
        }
        this.proc.addLink(new Link(from, to));
        if (this.proc.checkFeedback()) {
            this.proc.deleteLink(this.proc.getLinks().length - 1);
            this.selectedLink = new boolean[this.proc.getLinks().length];
            new BStandardDialog(null, new String[]{"The link you have selected cannot be created,", "as it would result in a feedback loop."}, BStandardDialog.ERROR).showMessageDialog(this.parent);
        }
        this.updateMenus();
    }

    public void saveState(boolean redo) {
        ArrayList<ByteArrayOutputStream> stack;
        ArrayList<ByteArrayOutputStream> arrayList = stack = redo ? this.redoStack : this.undoStack;
        if (stack.size() == ArtOfIllusion.getPreferences().getUndoLevels()) {
            stack.remove(0);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buffer);
        try {
            this.proc.writeToStream(out, this.theScene);
            out.close();
            stack.add(buffer);
            if (redo) {
                this.redoItem.setEnabled(true);
            } else {
                this.undoItem.setEnabled(true);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void undo() {
        if (this.undoStack.size() == 0) {
            return;
        }
        this.saveState(true);
        ByteArrayOutputStream buffer = this.undoStack.get(this.undoStack.size() - 1);
        this.undoStack.remove(this.undoStack.size() - 1);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        try {
            this.proc.readFromStream(in, this.theScene);
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.redoStack.size() == ArtOfIllusion.getPreferences().getUndoLevels()) {
            this.redoStack.remove(0);
        }
        this.undoItem.setEnabled(this.undoStack.size() > 0);
        this.selectedModule = new boolean[this.proc.getModules().length];
        this.selectedLink = new boolean[this.proc.getLinks().length];
        this.repaint();
        this.updatePreview();
        this.updateMenus();
    }

    private void redo() {
        if (this.redoStack.size() == 0) {
            return;
        }
        this.saveState(false);
        ByteArrayOutputStream buffer = this.redoStack.get(this.redoStack.size() - 1);
        this.redoStack.remove(this.redoStack.size() - 1);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        try {
            this.proc.readFromStream(in, this.theScene);
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.undoStack.size() == ArtOfIllusion.getPreferences().getUndoLevels()) {
            this.undoStack.remove(0);
        }
        this.redoItem.setEnabled(this.redoStack.size() > 0);
        this.selectedModule = new boolean[this.proc.getModules().length];
        this.selectedLink = new boolean[this.proc.getLinks().length];
        this.repaint();
        this.updatePreview();
        this.updateMenus();
    }

    public void updatePreview() {
        this.owner.updatePreview(this.preview);
    }

    private void mouseClicked(MouseClickedEvent e) {
        Point pos = e.getPoint();
        if (e.getClickCount() == 2) {
            Module[] module;
            for (Module mod : module = this.proc.getModules()) {
                if (!mod.getBounds().contains(pos)) continue;
                this.saveState(false);
                if (mod.edit(this, this.theScene)) {
                    this.repaint();
                    this.updatePreview();
                } else {
                    this.undo();
                }
                return;
            }
        }
    }

    protected void mousePressed(MousePressedEvent e) {
        IOPort port;
        int i;
        OutputModule[] output = this.proc.getOutputModules();
        Module[] module = this.proc.getModules();
        Link[] link = this.proc.getLinks();
        this.requestFocus();
        this.clickPos = e.getPoint();
        this.lastPos = null;
        for (i = 0; i < module.length; ++i) {
            port = module[i].getClickedPort(this.clickPos);
            if (port == null) continue;
            this.startDragLink(port);
            return;
        }
        for (i = 0; i < output.length; ++i) {
            port = output[i].getClickedPort(this.clickPos);
            if (port == null) continue;
            this.startDragLink(port);
            return;
        }
        for (i = module.length - 1; i >= 0; --i) {
            if (!this.selectedModule[i] || !module[i].getBounds().contains(this.clickPos)) continue;
            this.draggingModule = true;
            if (e.getWidget() == this) {
                this.saveState(false);
            }
            this.lastPos = this.clickPos;
            this.repaint();
            return;
        }
        for (i = module.length - 1; i >= 0; --i) {
            if (this.selectedModule[i] || !module[i].getBounds().contains(this.clickPos)) continue;
            this.draggingModule = true;
            this.saveState(false);
            if (!e.isShiftDown()) {
                Arrays.fill(this.selectedModule, false);
                Arrays.fill(this.selectedLink, false);
            }
            this.selectedModule[i] = true;
            this.lastPos = this.clickPos;
            this.repaint();
            this.updateMenus();
            return;
        }
        for (i = 0; i < link.length; ++i) {
            int tol = 2;
            if (!this.createBezierCurve(link[i]).intersects(new Rectangle(this.clickPos.x - tol, this.clickPos.y - tol, 2 * tol, 2 * tol))) continue;
            if (!e.isShiftDown()) {
                Arrays.fill(this.selectedModule, false);
                Arrays.fill(this.selectedLink, false);
            }
            this.selectedLink[i] = true;
            this.repaint();
            this.updateMenus();
            return;
        }
        if (!e.isShiftDown()) {
            Arrays.fill(this.selectedModule, false);
            Arrays.fill(this.selectedLink, false);
        }
        this.draggingBox = true;
        this.repaint();
        this.updateMenus();
    }

    protected void mouseReleased() {
        if (this.draggingLink) {
            this.draggingLink = false;
            if (this.dragToPort != null) {
                this.saveState(false);
                this.addLink(this.dragFromPort, this.dragToPort);
                this.updatePreview();
            }
            this.repaint();
            return;
        }
        if (this.draggingBox) {
            if (this.lastPos == null) {
                this.draggingBox = false;
                this.repaint();
                return;
            }
            Rectangle rect = this.getRectangle(this.clickPos, this.lastPos);
            Module[] module = this.proc.getModules();
            for (int i = 0; i < this.selectedModule.length; ++i) {
                if (!module[i].getBounds().intersects(rect)) continue;
                this.selectedModule[i] = true;
            }
            this.draggingBox = false;
            this.repaint();
            this.updateMenus();
            return;
        }
        if (this.draggingModule) {
            this.draggingModule = false;
        }
        this.repaint();
    }

    protected void mouseDragged(MouseDraggedEvent e) {
        Point pos = e.getPoint();
        if (this.draggingBox) {
            Rectangle rect;
            Graphics g = this.getComponent().getGraphics();
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            if (this.lastPos != null) {
                rect = this.getRectangle(this.clickPos, this.lastPos);
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
            }
            this.lastPos = pos;
            rect = this.getRectangle(this.clickPos, this.lastPos);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
            g.dispose();
            return;
        }
        if (this.draggingLink) {
            int j;
            IOPort[] port;
            Module[] module;
            boolean isInput;
            if (this.dragToPort != null && this.dragToPort.contains(pos)) {
                return;
            }
            boolean bl = isInput = this.dragFromPort.getType() == 0;
            if (this.dragToPort != null) {
                this.dragToPort = null;
            }
            OutputModule[] output = this.proc.getOutputModules();
            for (Module module2 : module = this.proc.getModules()) {
                port = isInput ? module2.getOutputPorts() : module2.getInputPorts();
                for (j = 0; j < port.length; ++j) {
                    if (!isInput && module2.inputConnected(j) || port[j].getValueType() != this.dragFromPort.getValueType() || !port[j].contains(pos)) continue;
                    this.dragToPort = port[j];
                }
                if (this.dragToPort != null) break;
            }
            if (!isInput) {
                for (Module module3 : output) {
                    port = module3.getInputPorts();
                    for (j = 0; j < port.length; ++j) {
                        if (module3.inputConnected(j) || port[j].getValueType() != this.dragFromPort.getValueType() || !port[j].contains(pos)) continue;
                        this.dragToPort = port[j];
                    }
                    if (this.dragToPort != null) break;
                }
            }
            if (this.dragToPort != null) {
                InfoBox info = isInput ? this.outputInfo : this.inputInfo;
                Rectangle rect = info.getBounds();
                pos = this.dragToPort.getPosition();
                if (isInput) {
                    info.setPosition(pos.x - rect.width - 10, pos.y - rect.height / 2);
                } else {
                    info.setPosition(pos.x + 10, pos.y - rect.height / 2);
                }
                info.setText(this.dragToPort.getDescription());
            }
            this.lastPos = pos;
            this.repaint();
            return;
        }
        if (!this.draggingModule) {
            return;
        }
        int dx = 0;
        int dy = 0;
        Module[] module = this.proc.getModules();
        if (this.lastPos != null) {
            dx = pos.x - this.lastPos.x;
            dy = pos.y - this.lastPos.y;
        }
        for (int i = 0; i < this.selectedModule.length; ++i) {
            if (!this.selectedModule[i]) continue;
            Rectangle rect = module[i].getBounds();
            module[i].setPosition(rect.x + dx, rect.y + dy);
        }
        this.repaint();
        this.lastPos = pos;
    }

    private void startDragLink(IOPort port) {
        boolean isInput = port.getType() == 0;
        InfoBox info = isInput ? this.inputInfo : this.outputInfo;
        Point pos = port.getPosition();
        this.draggingLink = true;
        this.draggingModule = false;
        this.dragFromPort = port;
        this.dragToPort = null;
        this.clickPos = port.getPosition();
        info.setText(port.getDescription());
        Rectangle rect = info.getBounds();
        if (isInput) {
            info.setPosition(pos.x + 10, pos.y - rect.height / 2);
        } else {
            info.setPosition(pos.x - rect.width - 10, pos.y - rect.height / 2);
        }
        Graphics g = this.getComponent().getGraphics();
        info.draw(g);
        g.dispose();
        if (isInput) {
            Module module = port.getModule();
            IOPort[] inputs = module.getInputPorts();
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i] != port || !module.inputConnected(i)) continue;
                this.draggingLink = false;
            }
        }
    }

    private void keyPressed(KeyPressedEvent e) {
        int key = e.getKeyCode();
        if (key != 8 && key != 127) {
            return;
        }
        this.deleteSelection();
    }

    private void deleteSelection() {
        int i;
        this.saveState(false);
        Module[] module = this.proc.getModules();
        Link[] link = this.proc.getLinks();
        for (i = 0; i < this.selectedLink.length; ++i) {
            for (int j = 0; j < this.selectedModule.length; ++j) {
                if ((module[j] != link[i].from.getModule() || !this.selectedModule[j]) && (module[j] != link[i].to.getModule() || !this.selectedModule[j])) continue;
                this.selectedLink[i] = true;
            }
        }
        for (i = this.selectedLink.length - 1; i >= 0; --i) {
            if (!this.selectedLink[i]) continue;
            this.proc.deleteLink(i);
        }
        for (i = this.selectedModule.length - 1; i >= 0; --i) {
            if (!this.selectedModule[i]) continue;
            this.proc.deleteModule(i);
        }
        this.selectedModule = new boolean[this.proc.getModules().length];
        this.selectedLink = new boolean[this.proc.getLinks().length];
        this.updatePreview();
        this.repaint();
        this.updateMenus();
    }

    public Rectangle getRectangle(Point p1, Point p2) {
        int x = Math.min(p1.x, p2.x);
        int y = Math.min(p1.y, p2.y);
        int width = Math.abs(p1.x - p2.x);
        int height = Math.abs(p1.y - p2.y);
        return new Rectangle(x, y, width, height);
    }

    private static class ClipboardSelection {
        Module[] module;
        Link[] link;

        public ClipboardSelection(Procedure proc, boolean[] selectedModule, boolean[] selectedLink) {
            int i;
            ArrayList<Module> mod = new ArrayList<Module>();
            ArrayList<Link> ln = new ArrayList<Link>();
            Module[] allModules = proc.getModules();
            Link[] allLinks = proc.getLinks();
            for (i = 0; i < selectedModule.length; ++i) {
                if (!selectedModule[i]) continue;
                mod.add(allModules[i]);
            }
            for (i = 0; i < selectedLink.length; ++i) {
                if (mod.indexOf(allLinks[i].from.getModule()) <= -1 || mod.indexOf(allLinks[i].to.getModule()) <= -1) continue;
                ln.add(allLinks[i]);
            }
            this.module = new Module[mod.size()];
            this.link = new Link[ln.size()];
            for (i = 0; i < this.module.length; ++i) {
                this.module[i] = ((Module)mod.get(i)).duplicate();
            }
            for (i = 0; i < this.link.length; ++i) {
                Link thisLink = (Link)ln.get(i);
                int from = mod.indexOf(thisLink.from.getModule());
                int to = mod.indexOf(thisLink.to.getModule());
                int fromPort = thisLink.getFromPortIndex();
                int toPort = thisLink.getToPortIndex();
                this.link[i] = new Link(this.module[from].getOutputPorts()[fromPort], this.module[to].getInputPorts()[toPort]);
            }
        }

        public void paste(ProcedureEditor editor) {
            int i;
            int numModules = editor.selectedModule.length;
            int numLinks = editor.selectedLink.length;
            Module[] realMod = new Module[this.module.length];
            for (int i2 = 0; i2 < this.module.length; ++i2) {
                if (this.module[i2] instanceof ParameterModule && !editor.owner.allowParameters()) continue;
                realMod[i2] = this.module[i2].duplicate();
                if (realMod[i2] instanceof ImageModule && editor.theScene.indexOf(((ImageModule)realMod[i2]).getMap()) == -1) {
                    ((ImageModule)realMod[i2]).setMap(null);
                }
                Rectangle bounds = realMod[i2].getBounds();
                realMod[i2].setPosition(bounds.x - 30, bounds.y + 30);
                editor.addModule(realMod[i2]);
            }
            for (Link ln : this.link) {
                int from = 0;
                while (this.module[from] != ln.from.getModule()) {
                    ++from;
                }
                int to = 0;
                while (this.module[to] != ln.to.getModule()) {
                    ++to;
                }
                if (realMod[from] == null || realMod[to] == null) continue;
                int fromPort = ln.getFromPortIndex();
                int toPort = ln.getToPortIndex();
                editor.addLink(realMod[from].getOutputPorts()[fromPort], realMod[to].getInputPorts()[toPort]);
            }
            for (i = 0; i < editor.selectedModule.length; ++i) {
                ((ProcedureEditor)editor).selectedModule[i] = i >= numModules;
            }
            for (i = 0; i < editor.selectedLink.length; ++i) {
                ((ProcedureEditor)editor).selectedLink[i] = i >= numLinks;
            }
            editor.updateMenus();
        }
    }
}

