/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.Widget;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class NumberModule
extends Module {
    private double value;

    public NumberModule(Point position) {
        super("0.0", new IOPort[0], new IOPort[]{new IOPort(0, 1, 3, new String[]{"Value"})}, position);
    }

    public NumberModule(Point position, double v) {
        super(Double.toString(v), new IOPort[0], new IOPort[]{new IOPort(0, 1, 3, new String[]{"Value"})}, position);
        this.value = v;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double v) {
        this.value = v;
    }

    public boolean edit(final ProcedureEditor editor, Scene theScene) {
        final ValueField field = new ValueField(this.value, 0);
        field.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                NumberModule.this.value = field.getValue();
                editor.updatePreview();
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), Translate.text("selectValue"), new Widget[]{field}, new String[]{null});
        if (!dlg.clickedOk()) {
            return false;
        }
        this.value = field.getValue();
        this.name = Double.toString(this.value);
        this.layout();
        return true;
    }

    public double getAverageValue(int which, double blur) {
        return this.value;
    }

    public void getValueGradient(Vec3 grad, double blur) {
        grad.set(0.0, 0.0, 0.0);
    }

    public Module duplicate() {
        NumberModule mod = new NumberModule(new Point(this.bounds.x, this.bounds.y));
        mod.value = this.value;
        mod.name = "" + this.value;
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(this.value);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.value = in.readDouble();
        this.name = "" + this.value;
        this.layout();
    }
}

