/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Noise;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.Widget;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MarbleModule
extends Module {
    boolean valueOk;
    boolean gradOk;
    int octaves = 4;
    double value;
    double error;
    double amplitude = 5.0;
    double spacing = 1.0;
    double lastBlur;
    Vec3 gradient = new Vec3();
    Vec3 tempVec = new Vec3();
    PointInfo point;

    public MarbleModule(Point position) {
        super(Translate.text("menu.marbleModule"), new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"}), new IOPort(0, 0, 2, new String[]{"Z", "(Z)"}), new IOPort(0, 0, 2, new String[]{"Noise", "(0.5)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Value"})}, position);
    }

    public int getOctaves() {
        return this.octaves;
    }

    public void setOctaves(int o) {
        this.octaves = o;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(double a) {
        this.amplitude = a;
    }

    public double getSpacing() {
        return this.spacing;
    }

    public void setSpacing(double s) {
        this.spacing = s;
    }

    public void init(PointInfo p) {
        this.point = p;
        this.gradOk = false;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        double x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double y = this.linkFrom[1] == null ? this.point.y : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        double z = this.linkFrom[2] == null ? this.point.z : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
        double persistence = this.linkFrom[3] == null ? 0.5 : this.linkFrom[3].getAverageValue(this.linkFromIndex[3], blur);
        double xsize = this.linkFrom[0] == null ? 0.5 * this.point.xsize + blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double ysize = this.linkFrom[1] == null ? 0.5 * this.point.ysize + blur : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        double zsize = this.linkFrom[2] == null ? 0.5 * this.point.zsize + blur : this.linkFrom[2].getValueError(this.linkFromIndex[2], blur);
        double amp = 0.5 * this.amplitude;
        double scale = 1.0;
        double cutoff = 0.5 / Math.max(Math.max(xsize, ysize), zsize);
        this.value = 0.0;
        this.error = 0.0;
        this.gradient.set(0.0, 0.0, 0.0);
        for (int i = 0; i < this.octaves && cutoff > scale; scale *= 2.0, ++i) {
            double d = amp * Noise.value(x * scale + 123.456, y * scale + 123.456, z * scale + 123.456);
            Noise.calcGradient(this.tempVec, x * scale + 123.456, y * scale + 123.456, z * scale + 123.456);
            if (d > 0.0) {
                this.tempVec.scale(amp * scale);
            } else {
                this.tempVec.scale(-amp * scale);
            }
            this.error += Math.abs(xsize * this.tempVec.x) + Math.abs(ysize * this.tempVec.y) + Math.abs(zsize * this.tempVec.z);
            if (scale > 0.5 * cutoff) {
                d *= 2.0 * (1.0 - scale / cutoff);
                this.tempVec.scale(2.0 * (1.0 - scale / cutoff));
            }
            this.value += Math.abs(d);
            this.gradient.add(this.tempVec);
            amp *= persistence;
        }
        scale = Math.PI * 2 / this.spacing;
        if (this.linkFrom[0] == null) {
            this.tempVec.set(1.0, 0.0, 0.0);
        } else {
            this.linkFrom[0].getValueGradient(this.linkFromIndex[0], this.tempVec, blur);
        }
        this.gradient.set(scale * this.tempVec.x + this.gradient.x, scale * this.tempVec.y + this.gradient.y, scale * this.tempVec.z + this.gradient.z);
        this.gradient.scale(0.5 * Math.cos(x * scale + this.value));
        this.value = this.error == 0.0 ? 0.5 + 0.5 * Math.sin(x * scale + this.value) : 0.5 + 0.25 * (Math.sin(x * scale + this.value - this.error) - Math.sin(x * scale + this.value + this.error)) / this.error;
        this.error = Math.abs(xsize * this.gradient.x) + Math.abs(ysize * this.gradient.y) + Math.abs(zsize * this.gradient.z);
        if (this.error > 0.5) {
            this.error = 0.5;
        }
        this.valueOk = true;
        this.lastBlur = blur;
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.gradOk && blur == this.lastBlur) {
            grad.set(this.gradient);
            return;
        }
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        double dx = this.gradient.x;
        double dy = this.gradient.y;
        double dz = this.gradient.z;
        if (dx != 0.0) {
            if (this.linkFrom[0] == null) {
                this.gradient.set(dx, 0.0, 0.0);
            } else {
                this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
                this.gradient.x = dx * grad.x;
                this.gradient.y = dx * grad.y;
                this.gradient.z = dx * grad.z;
            }
        } else {
            this.gradient.set(0.0, 0.0, 0.0);
        }
        if (dy != 0.0) {
            if (this.linkFrom[1] == null) {
                this.gradient.y += dy;
            } else {
                this.linkFrom[1].getValueGradient(this.linkFromIndex[1], grad, blur);
                this.gradient.x += dy * grad.x;
                this.gradient.y += dy * grad.y;
                this.gradient.z += dy * grad.z;
            }
        }
        if (dz != 0.0) {
            if (this.linkFrom[2] == null) {
                this.gradient.z += dz;
            } else {
                this.linkFrom[2].getValueGradient(this.linkFromIndex[2], grad, blur);
                this.gradient.x += dz * grad.x;
                this.gradient.y += dz * grad.y;
                this.gradient.z += dz * grad.z;
            }
        }
        this.gradOk = true;
        grad.set(this.gradient);
    }

    public boolean edit(final ProcedureEditor editor, Scene theScene) {
        final ValueField octavesField = new ValueField((double)this.octaves, 7);
        final ValueField ampField = new ValueField(this.amplitude, 0);
        final ValueField spacingField = new ValueField(this.spacing, 3);
        Object listener = new Object(){

            void processEvent() {
                MarbleModule.this.octaves = (int)octavesField.getValue();
                MarbleModule.this.amplitude = ampField.getValue();
                MarbleModule.this.spacing = spacingField.getValue();
                editor.updatePreview();
            }
        };
        octavesField.addEventLink(ValueChangedEvent.class, listener);
        ampField.addEventLink(ValueChangedEvent.class, listener);
        spacingField.addEventLink(ValueChangedEvent.class, listener);
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), Translate.text("selectMarbleProperties"), new Widget[]{ampField, spacingField, octavesField}, new String[]{Translate.text("Noise Amplitude"), Translate.text("Band Spacing"), Translate.text("Octaves")});
        return dlg.clickedOk();
    }

    public Module duplicate() {
        MarbleModule mod = new MarbleModule(new Point(this.bounds.x, this.bounds.y));
        mod.octaves = this.octaves;
        mod.amplitude = this.amplitude;
        mod.spacing = this.spacing;
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeInt(this.octaves);
        out.writeDouble(this.amplitude);
        out.writeDouble(this.spacing);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.octaves = in.readInt();
        this.amplitude = in.readDouble();
        this.spacing = in.readDouble();
    }
}

